/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.configurable.providers.toml;

import io.ballerina.runtime.api.Module;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ModuleInfo {
    private final Set<String> moduleNames = new HashSet<String>();
    private final Set<String> orgNames = new HashSet<String>();
    private final Set<Module> moduleSet;
    private boolean hasModuleAmbiguity;

    public ModuleInfo(Set<Module> moduleSet) {
        this.moduleSet = moduleSet;
    }

    void analyseModules(Module rootModule) {
        for (Module entry : this.moduleSet) {
            String orgName;
            String rootModuleName = rootModule.getName();
            if (rootModuleName.startsWith((orgName = entry.getOrg()) + ".") || rootModuleName.equals(orgName)) {
                this.hasModuleAmbiguity = true;
            }
            this.orgNames.add(entry.getOrg());
            Collections.addAll(this.moduleNames, entry.getName().split("\\."));
        }
    }

    boolean hasModuleAmbiguity() {
        return this.hasModuleAmbiguity;
    }

    boolean containsOrg(String nodeName) {
        return this.orgNames.contains(nodeName);
    }

    boolean containsModule(String nodeName) {
        return this.moduleNames.contains(nodeName);
    }

    Module getModuleFromName(String nodeName) {
        for (Module entry : this.moduleSet) {
            if (!entry.getName().equals(nodeName)) continue;
            return entry;
        }
        return null;
    }
}

