/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.configurable.providers.toml;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.TableType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.internal.TypeConverter;
import io.ballerina.runtime.internal.commons.TypeValuePair;
import io.ballerina.runtime.internal.configurable.ConfigProvider;
import io.ballerina.runtime.internal.configurable.ConfigValue;
import io.ballerina.runtime.internal.configurable.VariableKey;
import io.ballerina.runtime.internal.configurable.exceptions.ConfigException;
import io.ballerina.runtime.internal.configurable.providers.toml.ModuleInfo;
import io.ballerina.runtime.internal.configurable.providers.toml.TomlConfigValue;
import io.ballerina.runtime.internal.configurable.providers.toml.Utils;
import io.ballerina.runtime.internal.diagnostics.RuntimeDiagnosticLog;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.types.BFiniteType;
import io.ballerina.runtime.internal.types.BIntersectionType;
import io.ballerina.runtime.internal.types.BTableType;
import io.ballerina.runtime.internal.types.BTupleType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.utils.RuntimeUtils;
import io.ballerina.runtime.internal.utils.ValueUtils;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import io.ballerina.toml.api.Toml;
import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlArrayValueNode;
import io.ballerina.toml.semantic.ast.TomlBasicValueNode;
import io.ballerina.toml.semantic.ast.TomlInlineTableValueNode;
import io.ballerina.toml.semantic.ast.TomlKeyValueNode;
import io.ballerina.toml.semantic.ast.TomlNode;
import io.ballerina.toml.semantic.ast.TomlTableArrayNode;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.tools.text.LineRange;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class TomlProvider
implements ConfigProvider {
    private final Module rootModule;
    private final Set<TomlNode> visitedNodes = new HashSet<TomlNode>();
    private final Set<LineRange> invalidTomlLines = new HashSet<LineRange>();
    private final ModuleInfo moduleInfo;
    Map<Module, List<TomlTableNode>> moduleNodeMap = new HashMap<Module, List<TomlTableNode>>();
    Set<String> invalidRequiredModuleSet = new HashSet<String>();
    TomlTableNode tomlNode;

    TomlProvider(Module rootModule, Set<Module> moduleSet) {
        this.rootModule = rootModule;
        this.moduleInfo = new ModuleInfo(moduleSet);
    }

    @Override
    public void initialize() {
        this.moduleInfo.analyseModules(this.rootModule);
    }

    @Override
    public void complete(RuntimeDiagnosticLog diagnosticLog) {
        if (this.tomlNode == null) {
            return;
        }
        this.validateUnusedNodes(this.tomlNode, "", diagnosticLog);
        this.visitedNodes.clear();
    }

    private void validateUnusedNodes(TomlTableNode baseNode, String moduleHeader, RuntimeDiagnosticLog diagnosticLog) {
        block5: for (Map.Entry<String, TopLevelNode> nodeEntry : baseNode.entries().entrySet()) {
            TomlNode node = nodeEntry.getValue();
            String lineRange = Utils.getLineRange(node);
            String entryKey = nodeEntry.getKey();
            boolean isInvalidNode = this.invalidTomlLines.contains(node.location().lineRange());
            switch (node.kind()) {
                case KEY_VALUE: {
                    if (this.visitedNodes.contains(node) || isInvalidNode) break;
                    diagnosticLog.error(ErrorCodes.CONFIG_TOML_UNUSED_VALUE, null, lineRange, moduleHeader + entryKey);
                    break;
                }
                case TABLE: {
                    this.validateUnusedTableNodes((TomlTableNode)node, diagnosticLog, moduleHeader, entryKey);
                    break;
                }
                case TABLE_ARRAY: {
                    if (!this.visitedNodes.contains(node) && !isInvalidNode) {
                        diagnosticLog.error(ErrorCodes.CONFIG_TOML_UNUSED_VALUE, null, lineRange, moduleHeader + entryKey);
                    }
                    for (TomlTableNode tableNode : ((TomlTableArrayNode)node).children()) {
                        this.validateUnusedNodes(tableNode, entryKey + ".", diagnosticLog);
                    }
                    continue block5;
                }
            }
        }
    }

    private void validateUnusedTableNodes(TomlTableNode node, RuntimeDiagnosticLog diagnosticLog, String moduleHeader, String nodeName) {
        if (!this.visitedNodes.contains(node)) {
            Module module;
            String lineRange = Utils.getLineRange(node);
            boolean containsOrg = this.moduleInfo.containsOrg(nodeName);
            boolean containsModule = this.moduleInfo.containsModule(nodeName);
            if (!containsOrg && containsModule && (module = this.moduleInfo.getModuleFromName(nodeName)) != null && !this.invalidRequiredModuleSet.contains(module.toString()) && !this.rootModule.getOrg().equals(module.getOrg())) {
                diagnosticLog.error(ErrorCodes.CONFIG_TOML_INVALID_MODULE_STRUCTURE, null, lineRange, nodeName, Utils.getModuleKey(module));
            }
            if (!(containsOrg || containsModule || this.invalidTomlLines.contains(node.location().lineRange()))) {
                diagnosticLog.error(ErrorCodes.CONFIG_TOML_UNUSED_VALUE, null, lineRange, moduleHeader + nodeName);
            }
        }
        this.validateUnusedNodes(node, moduleHeader + nodeName + ".", diagnosticLog);
    }

    @Override
    public boolean hasConfigs() {
        return this.tomlNode != null && !this.tomlNode.entries().isEmpty();
    }

    @Override
    public Optional<ConfigValue> getAsIntAndMark(Module module, VariableKey key) {
        Object value2 = this.getPrimitiveTomlValue(module, key);
        if (value2 == null) {
            return Optional.empty();
        }
        return this.getTomlConfigValue(value2, key);
    }

    @Override
    public Optional<ConfigValue> getAsByteAndMark(Module module, VariableKey key) {
        TomlNode valueNode = this.getBasicTomlValue(module, key);
        if (valueNode == null) {
            return Optional.empty();
        }
        int byteValue = ((Long)((TomlBasicValueNode)valueNode).getValue()).intValue();
        if (!RuntimeUtils.isByteLiteral(byteValue)) {
            this.invalidTomlLines.add(valueNode.location().lineRange());
            throw new ConfigException(ErrorCodes.CONFIG_INVALID_BYTE_RANGE, Utils.getLineRange(valueNode), key.variable, byteValue);
        }
        return this.getTomlConfigValue(byteValue, key);
    }

    @Override
    public Optional<ConfigValue> getAsStringAndMark(Module module, VariableKey key) {
        Object value2 = this.getPrimitiveTomlValue(module, key);
        if (value2 == null) {
            return Optional.empty();
        }
        String stringVal = (String)value2;
        return this.getTomlConfigValue(StringUtils.fromString(stringVal), key);
    }

    @Override
    public Optional<ConfigValue> getAsFloatAndMark(Module module, VariableKey key) {
        Object value2 = this.getPrimitiveTomlValue(module, key);
        if (value2 == null) {
            return Optional.empty();
        }
        return this.getTomlConfigValue(value2, key);
    }

    @Override
    public Optional<ConfigValue> getAsBooleanAndMark(Module module, VariableKey key) {
        Object value2 = this.getPrimitiveTomlValue(module, key);
        if (value2 == null) {
            return Optional.empty();
        }
        return this.getTomlConfigValue(value2, key);
    }

    @Override
    public Optional<ConfigValue> getAsDecimalAndMark(Module module, VariableKey key) {
        Object value2 = this.getPrimitiveTomlValue(module, key);
        if (value2 == null) {
            return Optional.empty();
        }
        return this.getTomlConfigValue(ValueCreator.createDecimalValue(BigDecimal.valueOf((Double)value2)), key);
    }

    @Override
    public Optional<ConfigValue> getAsArrayAndMark(Module module, VariableKey key) {
        Type effectiveType = ((IntersectionType)key.type).getEffectiveType();
        List<TomlTableNode> moduleTomlNodes = this.getModuleTomlNodes(module, key);
        for (TomlTableNode moduleNode : moduleTomlNodes) {
            if (!moduleNode.entries().containsKey(key.variable)) continue;
            TomlNode tomlValue = moduleNode.entries().get(key.variable);
            this.validateArrayValue(tomlValue, key.variable, (ArrayType)effectiveType);
            return this.getTomlConfigValue(tomlValue, key);
        }
        return Optional.empty();
    }

    @Override
    public Optional<ConfigValue> getAsRecordAndMark(Module module, VariableKey key) {
        List<TomlTableNode> moduleTomlNodes = this.getModuleTomlNodes(module, key);
        for (TomlTableNode moduleNode : moduleTomlNodes) {
            if (!moduleNode.entries().containsKey(key.variable)) continue;
            TomlNode tomlValue = moduleNode.entries().get(key.variable);
            this.validateRecordValue(tomlValue, key.variable, key.type);
            return this.getTomlConfigValue(tomlValue, key);
        }
        return Optional.empty();
    }

    @Override
    public Optional<ConfigValue> getAsMapAndMark(Module module, VariableKey key) {
        String variableName = key.variable;
        MapType effectiveType = (MapType)((IntersectionType)key.type).getEffectiveType();
        List<TomlTableNode> moduleTomlNodes = this.getModuleTomlNodes(module, key);
        for (TomlTableNode moduleNode : moduleTomlNodes) {
            if (!moduleNode.entries().containsKey(variableName)) continue;
            TomlNode tomlValue = moduleNode.entries().get(variableName);
            this.validateMapValue(tomlValue, variableName, effectiveType);
            return this.getTomlConfigValue(tomlValue, key);
        }
        return Optional.empty();
    }

    private void validateMapValue(TomlNode tomlValue, String variableName, MapType mapType) {
        if (!Utils.checkEffectiveTomlType(tomlValue.kind(), mapType, variableName)) {
            this.throwTypeIncompatibleError(tomlValue, variableName, mapType);
        }
        this.visitedNodes.add(tomlValue);
        TomlTableNode tomlTableValue = (TomlTableNode)tomlValue;
        for (Map.Entry<String, TopLevelNode> field : tomlTableValue.entries().entrySet()) {
            String fieldName = variableName + "." + field.getKey();
            TomlNode value2 = field.getValue();
            this.visitedNodes.add(value2);
            this.validateValue(value2, fieldName, mapType.getConstrainedType());
        }
    }

    private void validateValue(TomlNode tomlValue, String variableName, Type type) {
        if (Utils.isSimpleType(type.getTag()) || Utils.isXMLType(type)) {
            this.validatePrimitiveValue(tomlValue, variableName, type);
        } else {
            this.validateStructuredValue(tomlValue, variableName, type);
        }
    }

    private void validateStructuredValue(TomlNode tomlValue, String variableName, Type type) {
        if (tomlValue.kind() == TomlType.INLINE_TABLE) {
            tomlValue = ((TomlInlineTableValueNode)tomlValue).toTable();
        }
        switch (type.getTag()) {
            case 44: {
                this.validateTupleValue(tomlValue, variableName, (TupleType)type);
                break;
            }
            case 32: {
                this.validateArrayValue(tomlValue, variableName, (ArrayType)type);
                break;
            }
            case 24: {
                this.validateRecordValue(tomlValue, variableName, type);
                break;
            }
            case 27: {
                this.validateMapValue(tomlValue, variableName, (MapType)type);
                break;
            }
            case 17: {
                this.validateTableValue(tomlValue, variableName, (TableType)type);
                break;
            }
            case 34: {
                Type effectiveType = ((IntersectionType)type).getEffectiveType();
                if (effectiveType.getTag() == 24) {
                    this.validateRecordValue(tomlValue, variableName, type);
                    break;
                }
                this.validateValue(tomlValue, variableName, effectiveType);
                break;
            }
            case 15: 
            case 23: 
            case 33: {
                this.validateUnionValue(tomlValue, variableName, (BUnionType)type);
                break;
            }
            case 53: {
                this.validateValue(tomlValue, variableName, ((ReferenceType)type).getReferredType());
                break;
            }
            case 46: {
                this.validateAndGetFiniteValue(tomlValue, variableName, (BFiniteType)type);
                break;
            }
            default: {
                this.invalidTomlLines.add(tomlValue.location().lineRange());
                throw new ConfigException(ErrorCodes.CONFIG_TYPE_NOT_SUPPORTED, variableName, type.toString());
            }
        }
    }

    @Override
    public Optional<ConfigValue> getAsTableAndMark(Module module, VariableKey key) {
        TableType tableType = (TableType)((BIntersectionType)key.type).getEffectiveType();
        List<TomlTableNode> moduleTomlNodes = this.getModuleTomlNodes(module, key);
        for (TomlTableNode moduleNode : moduleTomlNodes) {
            if (!moduleNode.entries().containsKey(key.variable)) continue;
            TomlNode tomlValue = moduleNode.entries().get(key.variable);
            this.validateTableValue(tomlValue, key.variable, tableType);
            return this.getTomlConfigValue(tomlValue, key);
        }
        return Optional.empty();
    }

    @Override
    public Optional<ConfigValue> getAsUnionAndMark(Module module, VariableKey key) {
        List<TomlTableNode> moduleTomlNodes = this.getModuleTomlNodes(module, key);
        for (TomlTableNode moduleNode : moduleTomlNodes) {
            if (!moduleNode.entries().containsKey(key.variable)) continue;
            TomlNode tomlValue = moduleNode.entries().get(key.variable);
            BUnionType unionType = (BUnionType)((BIntersectionType)key.type).getEffectiveType();
            this.validateUnionValue(tomlValue, key.variable, unionType);
            return this.getTomlConfigValue(tomlValue, key);
        }
        return Optional.empty();
    }

    @Override
    public Optional<ConfigValue> getAsFiniteAndMark(Module module, VariableKey key) {
        List<TomlTableNode> moduleTomlNodes = this.getModuleTomlNodes(module, key);
        for (TomlTableNode moduleNode : moduleTomlNodes) {
            if (!moduleNode.entries().containsKey(key.variable)) continue;
            TomlNode tomlValue = moduleNode.entries().get(key.variable);
            BFiniteType type = key.type.getTag() == 34 ? (BFiniteType)((IntersectionType)key.type).getEffectiveType() : (BFiniteType)TypeUtils.getImpliedType(key.type);
            return this.getTomlConfigValue(this.validateAndGetFiniteValue(tomlValue, key.variable, type), key);
        }
        return Optional.empty();
    }

    @Override
    public Optional<ConfigValue> getAsXmlAndMark(Module module, VariableKey key) {
        Object value2 = this.getPrimitiveTomlValue(module, key);
        if (value2 == null) {
            return Optional.empty();
        }
        return this.getTomlConfigValue(ValueUtils.createReadOnlyXmlValue((String)value2), key);
    }

    @Override
    public Optional<ConfigValue> getAsTupleAndMark(Module module, VariableKey key) {
        for (TomlTableNode moduleNode : this.getModuleTomlNodes(module, key)) {
            if (!moduleNode.entries().containsKey(key.variable)) continue;
            TomlNode tomlValue = moduleNode.entries().get(key.variable);
            BTupleType tupleType = (BTupleType)((BIntersectionType)key.type).getEffectiveType();
            TomlType tomlType = tomlValue.kind();
            if (tomlType != TomlType.KEY_VALUE) {
                this.throwTypeIncompatibleError(tomlValue, key.variable, tupleType);
            }
            this.visitedNodes.add(tomlValue);
            this.validateTupleValue(((TomlKeyValueNode)tomlValue).value(), key.variable, tupleType);
            return this.getTomlConfigValue(tomlValue, key);
        }
        return Optional.empty();
    }

    private void validateTupleValue(TomlNode value2, String variableName, TupleType tupleType) {
        if (!Utils.checkEffectiveTomlType((value2 = Utils.getValueFromKeyValueNode(value2)).kind(), tupleType, variableName)) {
            this.throwTypeIncompatibleError(value2, variableName, tupleType);
        }
        this.visitedNodes.add(value2);
        List<TomlValueNode> elements2 = ((TomlArrayValueNode)value2).elements();
        List<Type> tupleElementTypes = tupleType.getTupleTypes();
        int tomlSize = elements2.size();
        int tupleSize = tupleElementTypes.size();
        if (tomlSize != tupleSize && tupleType.getRestType() == null) {
            this.invalidTomlLines.add(value2.location().lineRange());
            throw new ConfigException(ErrorCodes.CONFIG_SIZE_MISMATCH, Utils.getLineRange(value2), variableName, tupleSize, tomlSize);
        }
        for (int i = 0; i < tomlSize; ++i) {
            Type elementType = Utils.getTupleElementType(tupleElementTypes, i, tupleType);
            TomlValueNode tomlElement = elements2.get(i);
            String elementName = variableName + "[" + i + "]";
            if (Utils.isSimpleType(elementType.getTag()) || Utils.isXMLType(elementType)) {
                this.validateSimpleValue(elementName, elementType, tomlElement);
                continue;
            }
            this.validateStructuredValue(tomlElement, elementName, elementType);
        }
    }

    private Object getPrimitiveTomlValue(Module module, VariableKey key) {
        TomlNode tomlValue = this.getBasicTomlValue(module, key);
        if (tomlValue == null) {
            return null;
        }
        return ((TomlBasicValueNode)tomlValue).getValue();
    }

    private TomlNode getBasicTomlValue(Module module, VariableKey key) {
        String variableName = key.variable;
        List<TomlTableNode> moduleTomlNodes = this.getModuleTomlNodes(module, key);
        for (TomlTableNode moduleNode : moduleTomlNodes) {
            if (!moduleNode.entries().containsKey(variableName)) continue;
            TomlNode tomlValue = moduleNode.entries().get(variableName);
            return this.getTomlNode(tomlValue, variableName, TypeUtils.getImpliedType(key.type));
        }
        return null;
    }

    private TomlNode getTomlNode(TomlNode tomlValue, String variableName, Type type) {
        TomlType tomlType = tomlValue.kind();
        if (tomlType != TomlType.KEY_VALUE) {
            this.throwTypeIncompatibleError(tomlValue, variableName, type);
        }
        this.visitedNodes.add(tomlValue);
        tomlValue = ((TomlKeyValueNode)tomlValue).value();
        tomlType = tomlValue.kind();
        if (!Utils.checkEffectiveTomlType(tomlType, type, variableName)) {
            this.throwTypeIncompatibleError(tomlValue, variableName, type);
        }
        return tomlValue;
    }

    private List<TomlTableNode> retrieveModuleNode(Module module, boolean hasRequired, String variableName) {
        Toml baseToml = new Toml(this.tomlNode);
        String orgName = module.getOrg();
        String moduleName = module.getName();
        if (orgName.equals(this.rootModule.getOrg())) {
            if (moduleName.equals(this.rootModule.getName())) {
                return this.getRootModuleNode(baseToml);
            }
            return this.getNonDefaultModuleNode(baseToml, module, hasRequired, variableName);
        }
        return this.getImportedModuleNode(baseToml, module, hasRequired, variableName);
    }

    private List<TomlTableNode> getImportedModuleNode(Toml baseToml, Module module, boolean hasRequired, String variableName) {
        String moduleKey = Utils.getModuleKey(module);
        Optional<Toml> table2 = baseToml.getTable(moduleKey);
        ArrayList<TomlTableNode> moduleNodes = new ArrayList<TomlTableNode>();
        if (table2.isEmpty() && hasRequired) {
            this.throwInvalidImportedModuleError(baseToml, module, variableName);
        }
        table2.ifPresent(toml -> this.addToModuleNodesList((Toml)toml, (List<TomlTableNode>)moduleNodes));
        return moduleNodes;
    }

    private void addToModuleNodesList(Toml table2, List<TomlTableNode> moduleNodes) {
        TomlTableNode tableNode = table2.rootNode();
        moduleNodes.add(tableNode);
        this.visitedNodes.add(tableNode);
    }

    private void throwInvalidImportedModuleError(Toml toml, Module module, String variableName) {
        String orgModuleKey = Utils.getModuleKey(module);
        TomlNode errorNode = this.getErrorNode(toml, module.getName(), orgModuleKey, variableName);
        if (errorNode != null) {
            this.invalidRequiredModuleSet.add(module.toString());
            this.invalidTomlLines.add(errorNode.location().lineRange());
            throw new ConfigException(ErrorCodes.CONFIG_TOML_INVALID_MODULE_STRUCTURE_WITH_VARIABLE, Utils.getLineRange(errorNode), orgModuleKey, variableName, orgModuleKey);
        }
    }

    private List<TomlTableNode> getNonDefaultModuleNode(Toml baseToml, Module module, boolean hasRequired, String variableName) {
        Optional<Toml> table2;
        String moduleName = module.getName();
        ArrayList<TomlTableNode> moduleNodes = new ArrayList<TomlTableNode>();
        String orgModuleKey = Utils.getModuleKey(module);
        if (this.moduleInfo.hasModuleAmbiguity()) {
            table2 = baseToml.getTable(orgModuleKey);
            if (table2.isPresent()) {
                this.addToModuleNodesList(table2.get(), moduleNodes);
            } else if (hasRequired) {
                this.invalidRequiredModuleSet.add(module.toString());
                throw new ConfigException(ErrorCodes.CONFIG_TOML_MODULE_AMBIGUITY, Utils.getLineRange(baseToml.rootNode()), moduleName, orgModuleKey);
            }
        }
        table2 = baseToml.getTable(moduleName);
        table2.ifPresent(toml -> this.addToModuleNodesList((Toml)toml, (List<TomlTableNode>)moduleNodes));
        table2 = baseToml.getTable(orgModuleKey);
        table2.ifPresent(toml -> this.addToModuleNodesList((Toml)toml, (List<TomlTableNode>)moduleNodes));
        if (moduleNodes.isEmpty() && hasRequired) {
            this.throwInvalidSubModuleError(baseToml, module, variableName);
        }
        return moduleNodes;
    }

    private void throwInvalidSubModuleError(Toml toml, Module module, String variableName) {
        Optional<Toml> tomlValueNode;
        String moduleName = module.getName();
        TomlNode errorNode = this.getErrorNode(toml, moduleName, Utils.getModuleKey(module), variableName);
        if (errorNode == null && (tomlValueNode = toml.getTable(moduleName.replaceFirst(this.rootModule.getName() + ".", ""))).isPresent()) {
            errorNode = tomlValueNode.get().rootNode();
        }
        if (errorNode != null) {
            this.invalidRequiredModuleSet.add(module.toString());
            this.invalidTomlLines.add(errorNode.location().lineRange());
            throw new ConfigException(ErrorCodes.CONFIG_TOML_INVALID_MODULE_STRUCTURE_WITH_VARIABLE, Utils.getLineRange(errorNode), moduleName, variableName, moduleName);
        }
    }

    private TomlNode getErrorNode(Toml toml, String moduleName, String orgModuleKey, String variableName) {
        Optional valueNode = toml.get(moduleName);
        if (valueNode.isPresent()) {
            return (TomlNode)valueNode.get();
        }
        valueNode = toml.get(orgModuleKey);
        if (valueNode.isPresent()) {
            return (TomlNode)valueNode.get();
        }
        valueNode = toml.get(variableName);
        if (valueNode.isPresent()) {
            return (TomlNode)valueNode.get();
        }
        Optional<Toml> tableNode = toml.getTable(moduleName);
        if (tableNode.isPresent()) {
            return tableNode.get().rootNode();
        }
        tableNode = toml.getTable(orgModuleKey);
        if (tableNode.isPresent()) {
            return tableNode.get().rootNode();
        }
        tableNode = toml.getTable(variableName);
        if (tableNode.isPresent()) {
            return tableNode.get().rootNode();
        }
        List<Toml> tomlTables = toml.getTables(moduleName);
        if (!tomlTables.isEmpty()) {
            return tomlTables.get(0).rootNode();
        }
        tomlTables = toml.getTables(orgModuleKey);
        if (!tomlTables.isEmpty()) {
            return tomlTables.get(0).rootNode();
        }
        tomlTables = toml.getTables(variableName);
        if (!tomlTables.isEmpty()) {
            return tomlTables.get(0).rootNode();
        }
        return null;
    }

    private List<TomlTableNode> getRootModuleNode(Toml baseToml) {
        String moduleName = this.rootModule.getName();
        String moduleKey = Utils.getModuleKey(this.rootModule);
        Optional<Toml> table2 = baseToml.getTable(moduleKey);
        ArrayList<TomlTableNode> moduleNodes = new ArrayList<TomlTableNode>();
        if (table2.isPresent()) {
            this.addToModuleNodesList(table2.get(), moduleNodes);
        } else if (this.moduleInfo.hasModuleAmbiguity()) {
            throw new ConfigException(ErrorCodes.CONFIG_TOML_MODULE_AMBIGUITY, Utils.getLineRange(baseToml.rootNode()), moduleName, moduleKey);
        }
        table2 = baseToml.getTable(moduleName);
        table2.ifPresent(toml -> this.addToModuleNodesList((Toml)toml, (List<TomlTableNode>)moduleNodes));
        this.addToModuleNodesList(baseToml, moduleNodes);
        return moduleNodes;
    }

    private void validatePrimitiveValue(TomlNode tomlValue, String variableName, Type type) {
        TomlType tomlType = tomlValue.kind();
        if (tomlType != TomlType.KEY_VALUE) {
            this.throwTypeIncompatibleError(tomlValue, variableName, type);
        }
        this.visitedNodes.add(tomlValue);
        TomlValueNode value2 = ((TomlKeyValueNode)tomlValue).value();
        this.validateSimpleValue(variableName, type, value2);
    }

    private Object validateAndGetFiniteValue(TomlNode tomlValue, String variableName, BFiniteType type) {
        this.visitedNodes.add(tomlValue);
        Object balValue = Utils.getFiniteBalValue(tomlValue, this.visitedNodes, type, this.invalidTomlLines, variableName);
        if (!type.valueSpace.contains(balValue)) {
            this.throwTypeIncompatibleError(tomlValue, variableName, type);
        }
        return balValue;
    }

    private void validateUnionValue(TomlNode tomlValue, String variableName, BUnionType unionType) {
        Type type;
        this.visitedNodes.add(tomlValue);
        Object balValue = Utils.getBalValueFromToml(tomlValue, this.visitedNodes, unionType, this.invalidTomlLines, variableName);
        Type convertibleType = TypeConverter.getConvertibleType(balValue, unionType, variableName, new HashSet<TypeValuePair>(), new ArrayList<String>(), false);
        if (convertibleType == null) {
            this.throwTypeIncompatibleError(tomlValue, variableName, unionType);
        }
        if (Utils.isSimpleType((type = Utils.getEffectiveType(TypeUtils.getImpliedType(convertibleType))).getTag()) || Utils.isXMLType(type)) {
            return;
        }
        if (type.getTag() == 46) {
            if (((BFiniteType)type).valueSpace.contains(balValue)) {
                return;
            }
            this.throwTypeIncompatibleError(tomlValue, variableName, type);
        }
        this.visitedNodes.add(tomlValue);
        this.validateStructuredValue(tomlValue, variableName, type);
    }

    private void validateArrayValue(TomlNode tomlValue, String variableName, ArrayType arrayType) {
        Type elementType = TypeUtils.getImpliedType(arrayType.getElementType());
        if (Utils.isSimpleType(elementType.getTag())) {
            this.visitedNodes.add(tomlValue);
            tomlValue = Utils.getValueFromKeyValueNode(tomlValue);
            this.validatePrimitiveArray(tomlValue, variableName, arrayType);
        } else {
            this.validateNonPrimitiveArray(tomlValue, variableName, arrayType, elementType);
        }
    }

    private void validateNonPrimitiveArray(TomlNode tomlValue, String variableName, ArrayType arrayType, Type elementType) {
        switch (elementType.getTag()) {
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 32: 
            case 40: 
            case 44: 
            case 46: {
                this.visitedNodes.add(tomlValue);
                tomlValue = Utils.getValueFromKeyValueNode(tomlValue);
                this.validatePrimitiveArray(tomlValue, variableName, arrayType);
                break;
            }
            case 24: 
            case 27: {
                this.validateMapValueArray(tomlValue, variableName, arrayType, elementType);
                break;
            }
            case 15: 
            case 23: 
            case 33: {
                this.visitedNodes.add(tomlValue);
                tomlValue = Utils.getValueFromKeyValueNode(tomlValue);
                this.validateUnionValueArray(tomlValue, variableName, arrayType, (BUnionType)elementType);
                break;
            }
            case 17: {
                this.validateTableValueArray(tomlValue, variableName, arrayType, (BTableType)elementType);
                break;
            }
            default: {
                Type effectiveType = ((IntersectionType)elementType).getEffectiveType();
                this.validateNonPrimitiveArray(tomlValue, variableName, arrayType, effectiveType);
            }
        }
    }

    private void validateTableValueArray(TomlNode tomlValue, String variableName, ArrayType arrayType, BTableType elementType) {
        TomlType tomlType = tomlValue.kind();
        switch (tomlType) {
            case ARRAY: {
                this.visitedNodes.add(tomlValue);
                List<TomlValueNode> nodeList = ((TomlArrayValueNode)tomlValue).elements();
                for (int i = 0; i < nodeList.size(); ++i) {
                    this.validateValue(nodeList.get(i), variableName + "[" + i + "]", elementType);
                }
                return;
            }
            case KEY_VALUE: {
                this.visitedNodes.add(tomlValue);
                tomlValue = ((TomlKeyValueNode)tomlValue).value();
                this.validateTableValueArray(tomlValue, variableName, arrayType, elementType);
                return;
            }
        }
        this.throwTypeIncompatibleError(tomlValue, variableName, arrayType);
    }

    private void validateMapValueArray(TomlNode tomlValue, String variableName, ArrayType arrayType, Type elementType) {
        TomlType tomlType = tomlValue.kind();
        switch (tomlType) {
            case TABLE_ARRAY: {
                this.visitedNodes.add(tomlValue);
                List<TomlTableNode> tableNodeList = ((TomlTableArrayNode)tomlValue).children();
                for (int i = 0; i < tableNodeList.size(); ++i) {
                    this.validateValue(tableNodeList.get(i), variableName + "[" + i + "]", elementType);
                }
                return;
            }
            case ARRAY: {
                this.visitedNodes.add(tomlValue);
                List<TomlValueNode> nodeList = ((TomlArrayValueNode)tomlValue).elements();
                for (int i = 0; i < nodeList.size(); ++i) {
                    this.validateValue(nodeList.get(i), variableName + "[" + i + "]", elementType);
                }
                return;
            }
            case KEY_VALUE: {
                this.visitedNodes.add(tomlValue);
                tomlValue = ((TomlKeyValueNode)tomlValue).value();
                this.validateMapValueArray(tomlValue, variableName, arrayType, elementType);
                return;
            }
        }
        this.throwTypeIncompatibleError(tomlValue, variableName, arrayType);
    }

    private void validateUnionValueArray(TomlNode tomlValue, String variableName, ArrayType arrayType, BUnionType elementType) {
        if (tomlValue.kind() == TomlType.TABLE_ARRAY) {
            this.validateMapUnionArray((TomlTableArrayNode)tomlValue, variableName, arrayType, elementType);
            return;
        }
        if (!Utils.checkEffectiveTomlType(tomlValue.kind(), arrayType, variableName)) {
            this.throwTypeIncompatibleError(tomlValue, variableName, arrayType);
        }
        this.visitedNodes.add(tomlValue);
        this.validateArrayElements(variableName, ((TomlArrayValueNode)tomlValue).elements(), elementType);
    }

    private void validateMapUnionArray(TomlTableArrayNode tomlValue, String variableName, ArrayType arrayType, BUnionType elementType) {
        if (!Utils.containsMapType(elementType.getMemberTypes())) {
            this.throwTypeIncompatibleError(tomlValue, variableName, arrayType);
        }
        this.visitedNodes.add(tomlValue);
        for (TomlNode tomlNode : tomlValue.children()) {
            this.validateUnionValue(tomlNode, variableName, elementType);
        }
    }

    private void validatePrimitiveArray(TomlNode tomlValue, String variableName, ArrayType arrayType) {
        if (!Utils.checkEffectiveTomlType(tomlValue.kind(), arrayType, variableName)) {
            this.throwTypeIncompatibleError(tomlValue, variableName, arrayType);
        }
        List<TomlValueNode> arrayList = ((TomlArrayValueNode)tomlValue).elements();
        this.validateArrayElements(variableName, arrayList, TypeUtils.getImpliedType(arrayType.getElementType()));
    }

    private void validateArrayElements(String variableName, List<TomlValueNode> arrayList, Type elementType) {
        int arraySize = arrayList.size();
        block7: for (int i = 0; i < arraySize; ++i) {
            String elementName = variableName + "[" + i + "]";
            TomlValueNode tomlValueNode = arrayList.get(i);
            switch (elementType.getTag()) {
                case 34: {
                    this.validateArrayElements(variableName, arrayList, ((BIntersectionType)elementType).getEffectiveType());
                    continue block7;
                }
                case 32: {
                    this.validateArrayValue(tomlValueNode, variableName, (ArrayType)elementType);
                    continue block7;
                }
                case 44: {
                    this.validateTupleValue(tomlValueNode, variableName, (TupleType)elementType);
                    continue block7;
                }
                case 15: 
                case 23: 
                case 33: {
                    this.validateUnionValue(tomlValueNode, variableName, (BUnionType)elementType);
                    continue block7;
                }
                case 46: {
                    this.validateAndGetFiniteValue(tomlValueNode, variableName, (BFiniteType)elementType);
                    continue block7;
                }
                default: {
                    this.validateSimpleValue(elementName, elementType, tomlValueNode);
                }
            }
        }
    }

    private void validateSimpleValue(String variableName, Type type, TomlValueNode tomlValue) {
        if (!Utils.checkEffectiveTomlType(tomlValue.kind(), type, variableName)) {
            this.throwTypeIncompatibleError(tomlValue, variableName, type);
        }
        this.validateByteValue(variableName, type, tomlValue);
        this.visitedNodes.add(tomlValue);
    }

    private void validateRecordValue(TomlNode tomlNode, String variableName, Type type) {
        RecordType recordType = type.getTag() == 24 ? (RecordType)type : (RecordType)ReadOnlyUtils.getMutableType((BIntersectionType)type);
        if (!Utils.checkEffectiveTomlType(tomlNode.kind(), recordType, variableName)) {
            this.throwTypeIncompatibleError(tomlNode, variableName, recordType);
        }
        TomlTableNode tomlValue = (TomlTableNode)tomlNode;
        this.visitedNodes.add(tomlValue);
        for (Map.Entry<String, TopLevelNode> tomlField : tomlValue.entries().entrySet()) {
            String fieldName = tomlField.getKey();
            Field field = recordType.getFields().get(fieldName);
            TomlNode value2 = tomlField.getValue();
            if (field == null) {
                if (recordType.isSealed()) {
                    this.invalidTomlLines.add(value2.location().lineRange());
                    throw new ConfigException(ErrorCodes.CONFIG_TOML_INVALID_ADDTIONAL_RECORD_FIELD, Utils.getLineRange(value2), fieldName, recordType.toString());
                }
                field = Utils.createAdditionalField(recordType, fieldName, value2);
            }
            Type fieldType = TypeUtils.getImpliedType(field.getFieldType());
            String variableFieldName = variableName + "." + fieldName;
            this.visitedNodes.add(value2);
            this.validateValue(value2, variableFieldName, fieldType);
        }
        this.validateRequiredField(tomlValue.entries(), recordType, variableName, tomlValue);
    }

    private void validateRequiredField(Map<String, TopLevelNode> initialValueEntries, RecordType recordType, String variableName, TomlNode tomlNode) {
        for (Map.Entry<String, Field> field : recordType.getFields().entrySet()) {
            String fieldName = field.getKey();
            long flag = field.getValue().getFlags();
            if (!SymbolFlags.isFlagOn(flag, 256L) || initialValueEntries.get(fieldName) != null) continue;
            this.invalidTomlLines.add(tomlNode.location().lineRange());
            throw new ConfigException(ErrorCodes.CONFIG_TOML_REQUIRED_FILED_NOT_PROVIDED, Utils.getLineRange(tomlNode), fieldName, recordType.toString(), variableName);
        }
    }

    private void validateTableValue(TomlNode tomlValue, String variableName, TableType tableType) {
        Type constraintType = tableType.getConstrainedType();
        switch (tomlValue.kind()) {
            case TABLE_ARRAY: {
                this.validateTomlTableValue((TomlTableArrayNode)tomlValue, variableName, tableType, constraintType);
                break;
            }
            case ARRAY: {
                for (TomlValueNode node : ((TomlArrayValueNode)tomlValue).elements()) {
                    if (node.kind() == TomlType.INLINE_TABLE) continue;
                    this.throwTypeIncompatibleError(tomlValue, variableName, tableType);
                    return;
                }
                this.validateTomlInLineTableValue((TomlArrayValueNode)tomlValue, variableName, tableType, constraintType);
                break;
            }
            case KEY_VALUE: {
                this.visitedNodes.add(tomlValue);
                this.validateTableValue(((TomlKeyValueNode)tomlValue).value(), variableName, tableType);
                break;
            }
            default: {
                this.throwTypeIncompatibleError(tomlValue, variableName, tableType);
            }
        }
    }

    private void throwTypeIncompatibleError(TomlNode tomlValue, String variableName, Type type) {
        this.invalidTomlLines.add(tomlValue.location().lineRange());
        throw new ConfigException(ErrorCodes.CONFIG_INCOMPATIBLE_TYPE, Utils.getLineRange(tomlValue), variableName, type, Utils.getTomlTypeString(tomlValue));
    }

    private void validateTomlInLineTableValue(TomlArrayValueNode tomlValue, String variableName, TableType tableType, Type constraintType) {
        this.visitedNodes.add(tomlValue);
        List<TomlValueNode> tableNodeList = tomlValue.elements();
        String[] keys2 = tableType.getFieldNames();
        for (TomlValueNode tomlTableNode : tableNodeList) {
            this.validateValue(tomlTableNode, variableName, constraintType);
            if (keys2 == null) continue;
            this.validateKeyField(((TomlInlineTableValueNode)tomlTableNode).toTable(), keys2, tableType, variableName);
        }
    }

    private void validateTomlTableValue(TomlTableArrayNode tomlValue, String variableName, TableType tableType, Type constraintType) {
        this.visitedNodes.add(tomlValue);
        List<TomlTableNode> tableNodeList = tomlValue.children();
        String[] keys2 = tableType.getFieldNames();
        for (TomlTableNode tomlTableNode : tableNodeList) {
            if (keys2 != null) {
                this.validateKeyField(tomlTableNode, keys2, tableType, variableName);
            }
            this.validateValue(tomlTableNode, variableName, constraintType);
        }
    }

    private void validateKeyField(TomlTableNode recordTable, String[] fieldNames, Type tableType, String variableName) {
        for (String key : fieldNames) {
            if (recordTable.entries().get(key) != null) continue;
            this.invalidTomlLines.add(recordTable.location().lineRange());
            throw new ConfigException(ErrorCodes.CONFIG_TOML_TABLE_KEY_NOT_PROVIDED, Utils.getLineRange(recordTable), key, tableType.toString(), variableName);
        }
    }

    private void validateByteValue(String variableName, Type type, TomlValueNode tomlValueNode) {
        int value2;
        Object tomlValue = ((TomlBasicValueNode)tomlValueNode).getValue();
        if (Utils.getEffectiveType(type).getTag() == 2 && !RuntimeUtils.isByteLiteral(value2 = ((Long)tomlValue).intValue())) {
            this.invalidTomlLines.add(tomlValueNode.location().lineRange());
            throw new ConfigException(ErrorCodes.CONFIG_INVALID_BYTE_RANGE, Utils.getLineRange(tomlValueNode), variableName, value2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TomlTableNode> getModuleTomlNodes(Module module, VariableKey key) {
        List<TomlTableNode> moduleNodes;
        if (!(!this.moduleNodeMap.containsKey(module) || (moduleNodes = this.moduleNodeMap.get(module)) == null || moduleNodes.isEmpty() && key.isRequired())) {
            return moduleNodes;
        }
        List<TomlTableNode> tomlTableNodes = null;
        try {
            tomlTableNodes = this.retrieveModuleNode(module, key.isRequired(), key.variable);
        }
        finally {
            this.moduleNodeMap.put(module, tomlTableNodes);
        }
        return tomlTableNodes;
    }

    private Optional<ConfigValue> getTomlConfigValue(Object value2, VariableKey key) {
        return Optional.of(new TomlConfigValue(value2, key.type));
    }
}

