/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.diagnostics;

import io.ballerina.runtime.internal.diagnostics.RuntimeDiagnosticLocation;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.List;

public class RuntimeDiagnostic
extends Diagnostic {
    private final DiagnosticInfo diagnosticInfo;
    private final Object[] args;
    private final RuntimeDiagnosticLocation location;

    public RuntimeDiagnostic(DiagnosticInfo diagnosticInfo, String location, Object[] args2) {
        this.diagnosticInfo = diagnosticInfo;
        this.args = args2;
        this.location = new RuntimeDiagnosticLocation(location);
    }

    @Override
    public Location location() {
        return this.location;
    }

    @Override
    public DiagnosticInfo diagnosticInfo() {
        return this.diagnosticInfo;
    }

    @Override
    public String message() {
        return ErrorHelper.getErrorMessage(this.diagnosticInfo.messageFormat(), this.args).getValue();
    }

    @Override
    public List<DiagnosticProperty<?>> properties() {
        return null;
    }

    @Override
    public String toString() {
        String prefix = "error";
        if (this.diagnosticInfo.severity().equals((Object)DiagnosticSeverity.WARNING)) {
            prefix = "warning";
        }
        if (this.location.getLocation() == null) {
            return String.format("%s: %s", prefix, this.message());
        }
        return String.format("%s: %s\n\tat %s", prefix, this.message(), this.location.getLocation());
    }
}

