/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.errors;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BMapInitialValueEntry;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.MappingInitialValueEntry;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public final class ErrorHelper {
    private static final ResourceBundle messageBundle = ResourceBundle.getBundle("MessagesBundle", Locale.getDefault());
    private static final BString ERROR_MESSAGE_FIELD = StringUtils.fromString("message");

    private ErrorHelper() {
    }

    public static BError getRuntimeException(ErrorCodes errorCodes, Object ... params) {
        BString errorMsg = StringUtils.fromString(MessageFormat.format(messageBundle.getString(errorCodes.messageKey()), params));
        return ErrorCreator.createError(errorMsg);
    }

    public static BError getRuntimeException(BString reason, ErrorCodes errorCodes, Object ... params) {
        BMapInitialValueEntry[] initialValues = new MappingInitialValueEntry[]{new MappingInitialValueEntry.KeyValueEntry(ERROR_MESSAGE_FIELD, StringUtils.fromString(MessageFormat.format(messageBundle.getString(errorCodes.messageKey()), params)))};
        MapValueImpl<BString, Object> errorDetail = new MapValueImpl<BString, Object>(PredefinedTypes.TYPE_ERROR_DETAIL, initialValues);
        return ErrorCreator.createError(reason, errorDetail);
    }

    public static BString getErrorMessage(ErrorCodes errorCodes, Object ... params) {
        return StringUtils.fromString(MessageFormat.format(messageBundle.getString(errorCodes.messageKey()), params));
    }

    public static BMap<BString, Object> getErrorDetails(ErrorCodes errorCodes, Object ... params) {
        BMapInitialValueEntry[] initialValues = new MappingInitialValueEntry[]{new MappingInitialValueEntry.KeyValueEntry(ERROR_MESSAGE_FIELD, StringUtils.fromString(MessageFormat.format(messageBundle.getString(errorCodes.messageKey()), params)))};
        return new MapValueImpl<BString, Object>(PredefinedTypes.TYPE_ERROR_DETAIL, initialValues);
    }

    public static BString getErrorMessage(String messageFormat, Object ... params) {
        return StringUtils.fromString(MessageFormat.format(messageBundle.getString(messageFormat), params));
    }

    public static void handleXMLException(String operation, Throwable e2) {
        String errorDetail = ErrorHelper.isBErrorWithMessageDetail(e2) ? ((BMap)((BError)e2).getDetails()).get(ERROR_MESSAGE_FIELD).toString() : (e2.getCause() != null ? e2.getCause().getMessage() : e2.getMessage());
        throw ErrorCreator.createError(ErrorReasons.XML_OPERATION_ERROR, StringUtils.fromString("Failed to " + operation + ": " + errorDetail));
    }

    private static boolean isBErrorWithMessageDetail(Throwable e2) {
        if (!(e2 instanceof BError)) {
            return false;
        }
        BError error2 = (BError)e2;
        return ErrorHelper.hasMessageDetail(error2);
    }

    public static boolean hasMessageDetail(BError bError) {
        Object bErrorDetails = bError.getDetails();
        if (bErrorDetails == null) {
            return false;
        }
        return ((BMap)bErrorDetails).get(ERROR_MESSAGE_FIELD) != null;
    }
}

