/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.json;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BIterator;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTable;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.json.JsonDataSource;
import io.ballerina.runtime.internal.json.JsonGenerator;
import io.ballerina.runtime.internal.json.JsonParser;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import io.ballerina.runtime.internal.values.DecimalValue;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.TupleValueImpl;
import java.io.IOException;
import java.util.Map;

public class TableJsonDataSource
implements JsonDataSource {
    private final BTable<?, ?> tableValue;
    private final JSONObjectGenerator objGen;

    public TableJsonDataSource(BTable<?, ?> tableValue) {
        this(tableValue, new DefaultJSONObjectGenerator());
    }

    private TableJsonDataSource(BTable<?, ?> tableValue, JSONObjectGenerator objGen) {
        this.tableValue = tableValue;
        this.objGen = objGen;
    }

    @Override
    public void serialize(JsonGenerator gen2) throws IOException {
        gen2.writeStartArray();
        while (this.hasNext()) {
            gen2.serialize(this.next());
        }
        gen2.writeEndArray();
    }

    @Override
    public boolean hasNext() {
        return this.tableValue.getIterator().hasNext();
    }

    @Override
    public Object next() {
        return this.tableValue.getIterator().next();
    }

    @Override
    public Object build() {
        ArrayValueImpl values = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_JSON));
        BIterator<?> itr = this.tableValue.getIterator();
        while (itr.hasNext()) {
            TupleValueImpl tupleValue = (TupleValueImpl)itr.next();
            BMap record = (BMap)tupleValue.get(1L);
            values.append(this.objGen.transform(record));
        }
        return values;
    }

    private static void constructJsonData(BMap<?, ?> record, MapValue<BString, Object> jsonObject, BString key, Type type) {
        type = TypeUtils.getImpliedType(type);
        switch (type.getTag()) {
            case 5: {
                jsonObject.put(key, record.getStringValue(key));
                break;
            }
            case 1: {
                Long intVal = record.getIntValue(key);
                jsonObject.put(key, intVal);
                break;
            }
            case 2: {
                Integer byteVal = (Integer)record.get(key);
                jsonObject.put(key, byteVal);
                break;
            }
            case 3: {
                Double floatVal = record.getFloatValue(key);
                jsonObject.put(key, floatVal);
                break;
            }
            case 4: {
                DecimalValue decimalVal = (DecimalValue)record.get(key);
                jsonObject.put(key, decimalVal);
                break;
            }
            case 6: {
                Boolean boolVal = record.getBooleanValue(key);
                jsonObject.put(key, boolVal);
                break;
            }
            case 32: 
            case 44: {
                jsonObject.put(key, TableJsonDataSource.getDataArray(record.getArrayValue(key)));
                break;
            }
            case 15: {
                jsonObject.put(key, record.getStringValue(key) == null ? null : JsonParser.parse(record.getStringValue(key).toString()));
                break;
            }
            case 24: 
            case 27: {
                MapValueImpl<BString, Object> jsonData = new MapValueImpl<BString, Object>(new BMapType(PredefinedTypes.TYPE_JSON));
                for (Map.Entry<?, ?> entry : record.getMapValue(key).entrySet()) {
                    Type internalType = TypeChecker.getType(entry.getValue());
                    BString internalKeyName = StringUtils.fromString(entry.getKey().toString());
                    TableJsonDataSource.constructJsonData(record.getMapValue(key), jsonData, internalKeyName, internalType);
                }
                jsonObject.put(key, jsonData);
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                BString strVal = StringUtils.fromString(StringUtils.getStringValue(record.get(key)));
                jsonObject.put(key, strVal);
                break;
            }
            default: {
                throw ErrorCreator.createError(StringUtils.fromString("cannot construct json object from '" + String.valueOf(type) + "' type data"));
            }
        }
    }

    private static Object getDataArray(BArray dataArray) {
        ArrayValueImpl jsonArray = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_JSON));
        for (int i = 0; i < dataArray.size(); ++i) {
            jsonArray.append(dataArray.get(i));
        }
        return jsonArray;
    }

    private static class DefaultJSONObjectGenerator
    implements JSONObjectGenerator {
        private DefaultJSONObjectGenerator() {
        }

        @Override
        public Object transform(BMap<?, ?> record) {
            MapValueImpl<BString, Object> objNode = new MapValueImpl<BString, Object>(new BMapType(PredefinedTypes.TYPE_JSON));
            for (Map.Entry<?, ?> entry : record.entrySet()) {
                Type type = TypeChecker.getType(entry.getValue());
                BString keyName = StringUtils.fromString(entry.getKey().toString());
                TableJsonDataSource.constructJsonData(record, objNode, keyName, type);
            }
            return objNode;
        }
    }

    public static interface JSONObjectGenerator {
        public Object transform(BMap<?, ?> var1);
    }
}

