/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.query.clauses;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.query.clauses.QueryClause;
import io.ballerina.runtime.internal.query.utils.QueryConstants;
import io.ballerina.runtime.internal.query.utils.QueryException;
import java.util.stream.Stream;

public class Do
implements QueryClause {
    private final Environment env;
    private final BFunctionPointer function;

    private Do(Environment env, BFunctionPointer function2) {
        this.env = env;
        this.function = function2;
    }

    public static Do initDoClause(Environment env, BFunctionPointer function2) {
        return new Do(env, function2);
    }

    @Override
    public Stream<BMap<BString, Object>> process(Stream<BMap<BString, Object>> inputStream) {
        return inputStream.map(frame -> {
            Object result = this.function.call(this.env.getRuntime(), frame);
            if (result instanceof BError) {
                BError error2 = (BError)result;
                throw new QueryException(error2);
            }
            if (result != null) {
                frame.put(QueryConstants.VALUE_ACCESS_FIELD, result);
            }
            return frame;
        });
    }
}

