/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.query.clauses;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.query.clauses.QueryClause;
import io.ballerina.runtime.internal.query.utils.QueryException;
import java.util.stream.Stream;

public class Let
implements QueryClause {
    private final BFunctionPointer frameModifier;
    private final Environment env;

    private Let(Environment env, BFunctionPointer frameModifier) {
        this.frameModifier = frameModifier;
        this.env = env;
    }

    public static Let initLetClause(Environment env, BFunctionPointer frameModifier) {
        return new Let(env, frameModifier);
    }

    @Override
    public Stream<BMap<BString, Object>> process(Stream<BMap<BString, Object>> inputStream) {
        return inputStream.map(frame -> {
            Object result = this.frameModifier.call(this.env.getRuntime(), frame);
            if (result instanceof BMap) {
                BMap map2 = (BMap)result;
                return map2;
            }
            throw new QueryException((BError)result);
        });
    }
}

