/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.query.clauses;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.query.clauses.QueryClause;
import io.ballerina.runtime.internal.query.utils.QueryConstants;
import io.ballerina.runtime.internal.query.utils.QueryException;
import io.ballerina.runtime.internal.values.ErrorValue;
import java.util.stream.Stream;

public class Limit
implements QueryClause {
    private final BFunctionPointer limitFunction;
    private final Environment env;

    private Limit(Environment env, BFunctionPointer limitFunction) {
        this.limitFunction = limitFunction;
        this.env = env;
    }

    public static Limit initLimitClause(Environment env, BFunctionPointer limitFunction) {
        return new Limit(env, limitFunction);
    }

    @Override
    public Stream<BMap<BString, Object>> process(Stream<BMap<BString, Object>> inputStream) {
        BMap<BString, Object> record = ValueCreator.createRecordValue(RuntimeConstants.BALLERINA_QUERY_PKG_ID, "_Frame");
        Object limitResult = this.limitFunction.call(this.env.getRuntime(), record);
        if (limitResult instanceof BError) {
            BError error2 = (BError)limitResult;
            return Stream.generate(() -> {
                throw new QueryException(error2);
            });
        }
        Long limit = (Long)limitResult;
        if (limit < 1L) {
            throw new ErrorValue(QueryConstants.LIMIT_NEGATIVE_ERROR);
        }
        return inputStream.limit(limit);
    }
}

