/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.query.clauses;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.query.clauses.QueryClause;
import io.ballerina.runtime.internal.query.utils.IteratorUtils;
import io.ballerina.runtime.internal.query.utils.QueryConstants;
import io.ballerina.runtime.internal.query.utils.QueryException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Stream;

public class NestedFrom
implements QueryClause {
    private final BFunctionPointer collectionFunc;
    private final Environment env;

    private NestedFrom(Environment env, BFunctionPointer collectionFunc) {
        this.collectionFunc = collectionFunc;
        this.env = env;
    }

    public static NestedFrom initNestedFromClause(Environment env, BFunctionPointer collectionFunc) {
        return new NestedFrom(env, collectionFunc);
    }

    @Override
    public Stream<BMap<BString, Object>> process(Stream<BMap<BString, Object>> inputStream) {
        return inputStream.flatMap(frame -> {
            Object collection2 = this.collectionFunc.call(this.env.getRuntime(), frame);
            if (collection2 instanceof BError) {
                BError error2 = (BError)collection2;
                throw new QueryException(error2);
            }
            if (collection2 == null) {
                return Stream.empty();
            }
            Iterator<?> itr = IteratorUtils.getIterator(this.env, collection2);
            ArrayList<BMap<BString, Object>> results = new ArrayList<BMap<BString, Object>>();
            try {
                while (itr.hasNext()) {
                    Object item = itr.next();
                    BMap<BString, Object> newRecord = ValueCreator.createRecordValue(RuntimeConstants.BALLERINA_QUERY_PKG_ID, "_Frame");
                    frame.entrySet().forEach(entry -> {
                        BString key = (BString)entry.getKey();
                        Object value2 = entry.getValue();
                        newRecord.put(key, value2);
                    });
                    newRecord.put(QueryConstants.VALUE_FIELD, item);
                    results.add(newRecord);
                }
            }
            catch (BError e2) {
                throw new QueryException(e2, true);
            }
            return results.stream();
        });
    }
}

