/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.query.clauses;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.query.clauses.QueryClause;
import io.ballerina.runtime.internal.query.pipeline.StreamPipeline;
import io.ballerina.runtime.internal.query.utils.QueryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class OuterJoin
implements QueryClause {
    private final StreamPipeline pipelineToJoin;
    private final BFunctionPointer lhsKeyFunction;
    private final BFunctionPointer rhsKeyFunction;
    private final Map<String, List<BMap<BString, Object>>> rhsFramesMap = new HashMap<String, List<BMap<BString, Object>>>();
    private final BMap<BString, Object> nilFrame;
    private BError failureAtJoin = null;
    private final Environment env;

    private OuterJoin(Environment env, StreamPipeline pipelineToJoin, BFunctionPointer lhsKeyFunction, BFunctionPointer rhsKeyFunction) {
        this.pipelineToJoin = pipelineToJoin;
        this.lhsKeyFunction = lhsKeyFunction;
        this.rhsKeyFunction = rhsKeyFunction;
        this.nilFrame = ValueCreator.createRecordValue(RuntimeConstants.BALLERINA_QUERY_PKG_ID, "_Frame");
        this.env = env;
        this.initializeRhsFrames();
    }

    public static OuterJoin initOuterJoinClause(Environment env, StreamPipeline pipelineToJoin, BFunctionPointer lhsKeyFunction, BFunctionPointer rhsKeyFunction) {
        return new OuterJoin(env, pipelineToJoin, lhsKeyFunction, rhsKeyFunction);
    }

    private void initializeRhsFrames() {
        try {
            Stream<BMap<BString, Object>> strm = ((StreamPipeline)StreamPipeline.getStreamFromPipeline(this.pipelineToJoin)).getStream();
            strm.forEach(frame -> {
                Object key = this.rhsKeyFunction.call(this.env.getRuntime(), frame);
                if (key instanceof BError) {
                    BError error2;
                    this.failureAtJoin = error2 = (BError)key;
                    return;
                }
                this.rhsFramesMap.computeIfAbsent(key.toString(), k -> new ArrayList()).add(frame);
            });
        }
        catch (QueryException e2) {
            this.failureAtJoin = e2.getError();
        }
    }

    @Override
    public Stream<BMap<BString, Object>> process(Stream<BMap<BString, Object>> inputStream) {
        return inputStream.flatMap(lhsFrame -> {
            try {
                if (this.failureAtJoin != null) {
                    throw new QueryException(this.failureAtJoin);
                }
                Object lhsKey = this.lhsKeyFunction.call(this.env.getRuntime(), lhsFrame);
                if (lhsKey instanceof BError) {
                    BError error2 = (BError)lhsKey;
                    throw new QueryException(error2);
                }
                List rhsCandidates = this.rhsFramesMap.getOrDefault(lhsKey.toString(), Collections.emptyList());
                if (rhsCandidates.isEmpty()) {
                    BMap<BString, Object> joinedFrame = ValueCreator.createMapValue();
                    lhsFrame.entrySet().forEach(entry -> joinedFrame.put((BString)entry.getKey(), entry.getValue()));
                    this.nilFrame.entrySet().forEach(entry -> joinedFrame.put((BString)entry.getKey(), entry.getValue()));
                    return Stream.of(joinedFrame);
                }
                return rhsCandidates.stream().map(rhsFrame -> this.mergeFrames((BMap<BString, Object>)lhsFrame, (BMap<BString, Object>)rhsFrame));
            }
            catch (BError e2) {
                throw new QueryException(e2);
            }
        });
    }

    private BMap<BString, Object> mergeFrames(BMap<BString, Object> lhs, BMap<BString, Object> rhs) {
        BMap<BString, Object> result = ValueCreator.createRecordValue(RuntimeConstants.BALLERINA_QUERY_PKG_ID, "_Frame");
        lhs.entrySet().forEach(entry -> result.put((BString)entry.getKey(), entry.getValue()));
        rhs.entrySet().forEach(entry -> result.put((BString)entry.getKey(), entry.getValue()));
        return result;
    }
}

