/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.query.clauses;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.query.clauses.QueryClause;
import io.ballerina.runtime.internal.query.utils.QueryException;
import java.util.stream.Stream;

public class Select
implements QueryClause {
    private final BFunctionPointer selector;
    private final Environment env;

    private Select(Environment env, BFunctionPointer selector) {
        this.selector = selector;
        this.env = env;
    }

    public static Select initSelectClause(Environment env, BFunctionPointer selector) {
        return new Select(env, selector);
    }

    @Override
    public Stream<BMap<BString, Object>> process(Stream<BMap<BString, Object>> inputStream) throws BError {
        return inputStream.map(frame -> {
            Object result = this.selector.call(this.env.getRuntime(), frame);
            if (result instanceof BMap) {
                BMap map2 = (BMap)result;
                return map2;
            }
            if (result instanceof BError) {
                BError error2 = (BError)result;
                throw new QueryException(error2);
            }
            return frame;
        });
    }
}

