/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.query.utils;

import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTable;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.api.values.BXmlSequence;
import io.ballerina.runtime.internal.query.pipeline.StreamPipeline;
import io.ballerina.runtime.internal.query.utils.QueryConstants;
import io.ballerina.runtime.internal.query.utils.QueryException;
import io.ballerina.runtime.internal.values.HandleValue;
import io.ballerina.runtime.internal.values.XmlValue;
import io.ballerina.runtime.internal.xml.XmlFactory;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class CollectionUtils {
    public static Object createArray(StreamPipeline pipeline, BArray array2) {
        Stream<BMap<BString, Object>> strm = pipeline.getStream();
        try {
            Iterator it = strm.iterator();
            while (it.hasNext()) {
                BMap frame = (BMap)it.next();
                array2.append(frame.get(QueryConstants.VALUE_ACCESS_FIELD));
            }
            return array2;
        }
        catch (QueryException e2) {
            return e2.getError();
        }
    }

    public static Object collectQuery(Object pipeline) {
        if (pipeline instanceof StreamPipeline) {
            StreamPipeline streamPipeline = (StreamPipeline)pipeline;
            Stream<BMap<BString, Object>> strm = streamPipeline.getStream();
            Optional<Object> result = strm.map(frame -> frame.get(QueryConstants.VALUE_ACCESS_FIELD)).filter(Objects::nonNull).findFirst();
            return result.orElse(null);
        }
        return pipeline;
    }

    public static Object toString(StreamPipeline pipeline) {
        Stream<BMap<BString, Object>> strm = pipeline.getStream();
        try {
            return strm.map(frame -> frame.get(QueryConstants.VALUE_ACCESS_FIELD)).map(string2 -> (BString)string2).reduce(QueryConstants.EMPTY_BSTRING, BString::concat);
        }
        catch (QueryException e2) {
            return e2.getError();
        }
    }

    public static Object createTable(StreamPipeline pipeline, BTable table2) {
        Stream<BMap<BString, Object>> strm = pipeline.getStream();
        try {
            strm.forEach(frame -> {
                BMap record = (BMap)frame.get(QueryConstants.VALUE_ACCESS_FIELD);
                table2.put(record);
            });
            return table2;
        }
        catch (QueryException e2) {
            return e2.getError();
        }
    }

    public static Object createTableForOnConflict(StreamPipeline pipeline, BTable table2) {
        Stream<BMap<BString, Object>> strm = pipeline.getStream();
        try {
            Optional<BError> error2 = strm.map(frame -> {
                BMap record = (BMap)frame.get(QueryConstants.VALUE_ACCESS_FIELD);
                try {
                    table2.add(record);
                }
                catch (Exception e2) {
                    Object patt0$temp = frame.get(QueryConstants.ERROR_FIELD);
                    if (patt0$temp instanceof BError) {
                        BError errorValue = (BError)patt0$temp;
                        return errorValue;
                    }
                    table2.put(record);
                }
                return null;
            }).filter(Objects::nonNull).findFirst();
            return error2.orElse(null) != null ? error2.get() : table2;
        }
        catch (QueryException e2) {
            return e2.getError();
        }
    }

    public static Object createMap(StreamPipeline pipeline, BMap<BString, Object> map2) {
        Stream<BMap<BString, Object>> strm = pipeline.getStream();
        try {
            strm.forEach(frame -> {
                BArray record = (BArray)frame.get(QueryConstants.VALUE_ACCESS_FIELD);
                BString key = (BString)record.get(0L);
                Object value2 = record.get(1L);
                map2.put(key, value2);
            });
            return map2;
        }
        catch (QueryException e2) {
            return e2.getError();
        }
    }

    public static Object createMapForOnConflict(StreamPipeline pipeline, BMap<BString, Object> map2) {
        Stream<BMap<BString, Object>> strm = pipeline.getStream();
        try {
            Optional<BError> error2 = strm.map(frame -> {
                Object patt0$temp;
                BArray recordArray = (BArray)frame.get(QueryConstants.VALUE_ACCESS_FIELD);
                BString key = (BString)recordArray.get(0L);
                if (map2.containsKey(key) && (patt0$temp = frame.get(QueryConstants.ERROR_FIELD)) instanceof BError) {
                    BError errorValue = (BError)patt0$temp;
                    return errorValue;
                }
                Object value2 = recordArray.get(1L);
                map2.put(key, value2);
                return null;
            }).filter(Objects::nonNull).findFirst();
            return error2.orElse(null) != null ? error2.get() : map2;
        }
        catch (QueryException e2) {
            return e2.getError();
        }
    }

    public static Object toStream(StreamPipeline pipeline) {
        Iterator pipelineObj;
        StreamType streamType = TypeCreator.createStreamType(pipeline.getConstraintType().getDescribingType(), pipeline.getCompletionType().getDescribingType());
        try {
            pipelineObj = pipeline.getStream().iterator();
        }
        catch (QueryException e2) {
            return e2.getError();
        }
        HandleValue handleValue = new HandleValue(pipelineObj);
        BObject iteratorObj = ValueCreator.createObjectValue(RuntimeConstants.BALLERINA_QUERY_PKG_ID, "_IteratorObject", handleValue);
        return ValueCreator.createStreamValue(streamType, iteratorObj);
    }

    public static Object createXML(StreamPipeline pipeline) {
        Stream<BMap<BString, Object>> strm = pipeline.getStream();
        try {
            Object[] xmlArray = strm.map(frame -> frame.get(QueryConstants.VALUE_ACCESS_FIELD)).filter(Objects::nonNull).toArray();
            return CollectionUtils.concatXML(xmlArray);
        }
        catch (QueryException e2) {
            return e2.getError();
        }
    }

    public static BXml concatXML(Object ... arrayValue) {
        ArrayList<BXml> backingArray = new ArrayList<BXml>();
        BXml lastItem = null;
        Object[] objectArray = arrayValue;
        int n = objectArray.length;
        block4: for (int i = 0; i < n; ++i) {
            Object refValue;
            Object object = refValue = objectArray[i];
            int n2 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BString.class, BXmlSequence.class}, (Object)object, n2)) {
                case 0: {
                    BString bString = (BString)object;
                    if (lastItem != null && lastItem.getNodeType() == XmlNodeType.TEXT) {
                        BString concat2 = StringUtils.fromString(lastItem.getTextValue()).concat(bString);
                        XmlValue xmlText = XmlFactory.createXMLText(concat2);
                        backingArray.set(backingArray.size() - 1, xmlText);
                        lastItem = xmlText;
                        continue block4;
                    }
                    XmlValue xmlText = XmlFactory.createXMLText(bString);
                    backingArray.add(xmlText);
                    lastItem = xmlText;
                    continue block4;
                }
                case 1: {
                    BXmlSequence bXmlSequence = (BXmlSequence)object;
                    backingArray.addAll(bXmlSequence.getChildrenList());
                    lastItem = (BXml)refValue;
                    continue block4;
                }
                default: {
                    backingArray.add((BXml)refValue);
                    lastItem = (BXml)refValue;
                }
            }
        }
        return ValueCreator.createXmlSequence(backingArray);
    }

    public static Object consumeStream(StreamPipeline pipeline) {
        Stream<BMap<BString, Object>> strm = pipeline.getStream();
        try {
            Iterator it = strm.iterator();
            while (it.hasNext()) {
                BMap frame = (BMap)it.next();
                if (!frame.containsKey(QueryConstants.VALUE_ACCESS_FIELD) || frame.get(QueryConstants.VALUE_ACCESS_FIELD) == null) continue;
                return frame.get(QueryConstants.VALUE_ACCESS_FIELD);
            }
        }
        catch (QueryException e2) {
            return e2.getError();
        }
        return null;
    }
}

