/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.query.utils;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.query.utils.QueryConstants;
import io.ballerina.runtime.internal.query.utils.QueryException;
import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.internal.values.JIteratorValue;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class IteratorUtils {
    public static <T> Stream<BMap<BString, Object>> toStream(Iterator<T> javaIterator) throws ErrorValue {
        return StreamSupport.stream(((Iterable)() -> javaIterator).spliterator(), false).map(element -> {
            BMap<BString, Object> record = ValueCreator.createRecordValue(RuntimeConstants.BALLERINA_QUERY_PKG_ID, "_Frame");
            record.put(QueryConstants.VALUE_FIELD, element);
            return record;
        });
    }

    public static Iterator<?> getIterator(Environment env, Object collection2) {
        try {
            Object object = collection2;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JIteratorValue.class, BStream.class, BObject.class}, (Object)object2, n)) {
                case 0: {
                    JIteratorValue iterable = (JIteratorValue)object2;
                    return iterable.getJavaIterator();
                }
                case 1: {
                    BStream bStream = (BStream)object2;
                    BObject iteratorObj = bStream.getIteratorObj();
                    return new BStreamIterator(env, iteratorObj);
                }
                case 2: {
                    BObject bObject = (BObject)object2;
                    Object iteratorObj = env.getRuntime().callMethod(bObject, "iterator", null, new Object[0]);
                    if (iteratorObj instanceof BObject) {
                        BObject iteratorInstance = (BObject)iteratorObj;
                        return new BStreamIterator(env, iteratorInstance);
                    }
                    throw new QueryException("Unsupported collection type");
                }
            }
            throw new QueryException("Unsupported collection type");
        }
        catch (BError e2) {
            throw new QueryException(e2);
        }
    }

    private static class BStreamIterator<T>
    implements Iterator<T> {
        private final Environment env;
        private final BObject iteratorObj;
        private Object nextValue = null;
        private boolean hasMore = true;

        public BStreamIterator(Environment env, BObject iteratorObj) {
            this.env = env;
            this.iteratorObj = iteratorObj;
        }

        @Override
        public boolean hasNext() {
            if (!this.hasMore) {
                return false;
            }
            Object result = this.env.getRuntime().callMethod(this.iteratorObj, "next", null, new Object[0]);
            if (result instanceof BError) {
                BError error2 = (BError)result;
                this.hasMore = false;
                throw new QueryException(error2, true);
            }
            if (result instanceof BMap) {
                BMap record = (BMap)result;
                this.nextValue = record.get(QueryConstants.VALUE_FIELD);
                if (this.nextValue == null) {
                    this.hasMore = false;
                    return false;
                }
                return true;
            }
            this.hasMore = false;
            return false;
        }

        @Override
        public T next() {
            Object returnValue = this.nextValue;
            this.nextValue = null;
            return (T)returnValue;
        }
    }
}

