/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.query.utils;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.internal.values.MapValueImpl;

public class QueryException
extends RuntimeException {
    private final BError error;

    public QueryException(BError error2) {
        this.error = this.createDistinctError("Error", RuntimeConstants.BALLERINA_QUERY_PKG_ID, error2);
    }

    public QueryException(BError error2, boolean isCompleteEarlyError) {
        this.error = this.createDistinctError("CompleteEarlyError", RuntimeConstants.BALLERINA_QUERY_PKG_ID, error2);
    }

    public QueryException(String message2) {
        this.error = ErrorCreator.createError(StringUtils.fromString(message2));
    }

    public BError getError() {
        return this.error;
    }

    public BError createDistinctError(String typeIdName, Module typeIdPkg, BError error2) {
        MapValueImpl details = (MapValueImpl)error2.getDetails();
        return new ErrorValue(error2.getType(), error2.getErrorMessage(), error2.getCause(), details, typeIdName, typeIdPkg);
    }
}

