/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.regexp;

import io.ballerina.identifier.Utils;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.regexp.CharReader;
import io.ballerina.runtime.internal.regexp.TokenReader;
import io.ballerina.runtime.internal.regexp.TreeBuilder;
import io.ballerina.runtime.internal.regexp.TreeTraverser;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.RegExpAssertion;
import io.ballerina.runtime.internal.values.RegExpAtom;
import io.ballerina.runtime.internal.values.RegExpAtomQuantifier;
import io.ballerina.runtime.internal.values.RegExpCapturingGroup;
import io.ballerina.runtime.internal.values.RegExpCharSet;
import io.ballerina.runtime.internal.values.RegExpCharSetRange;
import io.ballerina.runtime.internal.values.RegExpCharacterClass;
import io.ballerina.runtime.internal.values.RegExpDisjunction;
import io.ballerina.runtime.internal.values.RegExpFlagExpression;
import io.ballerina.runtime.internal.values.RegExpFlagOnOff;
import io.ballerina.runtime.internal.values.RegExpLiteralCharOrEscape;
import io.ballerina.runtime.internal.values.RegExpQuantifier;
import io.ballerina.runtime.internal.values.RegExpSequence;
import io.ballerina.runtime.internal.values.RegExpTerm;
import io.ballerina.runtime.internal.values.RegExpValue;

public final class RegExpFactory {
    private RegExpFactory() {
    }

    public static RegExpValue createRegExpValue(RegExpDisjunction regExpDisjunction) {
        return new RegExpValue(regExpDisjunction);
    }

    public static RegExpDisjunction createReDisjunction(ArrayValue termsList) {
        return new RegExpDisjunction(termsList);
    }

    public static RegExpSequence createReSequence(ArrayValue seqList) {
        return new RegExpSequence(seqList);
    }

    public static RegExpAssertion createReAssertion(BString assertion) {
        return new RegExpAssertion(assertion.getValue());
    }

    public static RegExpAtomQuantifier createReAtomQuantifier(Object reAtom, RegExpQuantifier quantifier) {
        return new RegExpAtomQuantifier(reAtom, quantifier);
    }

    public static RegExpLiteralCharOrEscape createReLiteralCharOrEscape(BString charOrEscape) {
        return new RegExpLiteralCharOrEscape(charOrEscape.getValue());
    }

    public static RegExpCharacterClass createReCharacterClass(BString characterClassStart, BString negation, RegExpCharSet reCharSet, BString characterClassEnd) {
        return new RegExpCharacterClass(characterClassStart.getValue(), negation.getValue(), reCharSet, characterClassEnd.getValue());
    }

    public static RegExpCharSet createReCharSet(ArrayValue charSet) {
        return new RegExpCharSet(charSet);
    }

    public static RegExpCharSetRange createReCharSetRange(BString lhsCharSetAtom, BString dash, BString rhsCharSetAtom) {
        return new RegExpCharSetRange(lhsCharSetAtom.getValue(), dash.getValue(), rhsCharSetAtom.getValue());
    }

    public static RegExpCapturingGroup createReCapturingGroup(BString openParen, Object flagExpr, RegExpDisjunction reDisjunction, BString closeParen) {
        return new RegExpCapturingGroup(openParen.getValue(), (RegExpFlagExpression)flagExpr, reDisjunction, closeParen.getValue());
    }

    public static RegExpFlagExpression createReFlagExpression(BString questionMark, RegExpFlagOnOff flagsOnOff, BString colon) {
        return new RegExpFlagExpression(questionMark.getValue(), flagsOnOff, colon.getValue());
    }

    public static RegExpFlagOnOff createReFlagOnOff(BString flags) {
        return new RegExpFlagOnOff(flags.getValue());
    }

    public static RegExpQuantifier createReQuantifier(BString quantifier, BString nonGreedyChar) {
        return new RegExpQuantifier(quantifier.getValue(), nonGreedyChar.getValue());
    }

    public static RegExpValue parse(String regExpStr) {
        try {
            CharReader charReader = CharReader.from(regExpStr);
            TokenReader tokenReader = new TokenReader(new TreeTraverser(charReader));
            TreeBuilder treeBuilder = new TreeBuilder(tokenReader);
            return treeBuilder.parse();
        }
        catch (BError e2) {
            throw ErrorCreator.createError(StringUtils.fromString("Failed to parse regular expression: " + e2.getMessage() + " in '" + regExpStr + "'"));
        }
    }

    public static void parseInsertion(String regExpStr) {
        try {
            CharReader charReader = CharReader.from(regExpStr);
            TokenReader tokenReader = new TokenReader(new TreeTraverser(charReader));
            TreeBuilder treeBuilder = new TreeBuilder(tokenReader);
            treeBuilder.parseInsertion();
        }
        catch (BError e2) {
            throw ErrorCreator.createError(ErrorReasons.REG_EXP_PARSING_ERROR, StringUtils.fromString(e2.getMessage() + " in insertion substring '" + regExpStr.substring(3, regExpStr.length() - 1) + "'"));
        }
    }

    public static RegExpValue translateRegExpConstructs(RegExpValue regExpValue) {
        RegExpDisjunction disjunction = regExpValue.getRegExpDisjunction();
        if (disjunction.stringValue(null).isEmpty()) {
            disjunction = RegExpFactory.getNonCapturingGroupDisjunction();
        }
        for (Object s : disjunction.getRegExpSeqList()) {
            if (!(s instanceof RegExpSequence)) continue;
            RegExpSequence seq = (RegExpSequence)s;
            RegExpFactory.translateRegExpTerms(seq.getRegExpTermsList());
        }
        return new RegExpValue(disjunction);
    }

    private static RegExpDisjunction getNonCapturingGroupDisjunction() {
        RegExpFlagOnOff flagsOnOff = new RegExpFlagOnOff("");
        RegExpFlagExpression flagExpr = new RegExpFlagExpression("?", flagsOnOff, ":");
        RegExpDisjunction reDisjunction = new RegExpDisjunction(new Object[0]);
        RegExpCapturingGroup reAtom = new RegExpCapturingGroup("(", flagExpr, reDisjunction, ")");
        RegExpQuantifier reQuantifier = new RegExpQuantifier("", "");
        RegExpTerm[] termList = new RegExpTerm[]{new RegExpAtomQuantifier(reAtom, reQuantifier)};
        return new RegExpDisjunction(new Object[]{new RegExpSequence(termList)});
    }

    private static void translateRegExpTerms(RegExpTerm[] terms) {
        for (RegExpTerm t : terms) {
            if (!(t instanceof RegExpAtomQuantifier)) continue;
            RegExpAtomQuantifier atomQuantifier = (RegExpAtomQuantifier)t;
            Object reAtom = atomQuantifier.getReAtom();
            if (reAtom instanceof RegExpLiteralCharOrEscape) {
                RegExpLiteralCharOrEscape regExpLiteralCharOrEscape = (RegExpLiteralCharOrEscape)reAtom;
                atomQuantifier.setReAtom(RegExpFactory.translateLiteralCharOrEscape(regExpLiteralCharOrEscape));
                continue;
            }
            if (!(reAtom instanceof RegExpCharacterClass)) continue;
            RegExpCharacterClass regExpCharacterClass = (RegExpCharacterClass)reAtom;
            atomQuantifier.setReAtom(RegExpFactory.translateCharacterClass(regExpCharacterClass));
        }
    }

    private static RegExpAtom translateLiteralCharOrEscape(RegExpLiteralCharOrEscape charOrEscape) {
        String value2 = charOrEscape.getCharOrEscape();
        if (".".equals(value2)) {
            return RegExpFactory.createCharacterClass("^", new String[]{"\\r", "\\n"});
        }
        if ("\\s".equals(value2)) {
            return RegExpFactory.createCharacterClass("", new String[]{"\\t", "\\s", "\\n", "\\r"});
        }
        if ("\\S".equals(value2)) {
            return RegExpFactory.createCharacterClass("^", new String[]{"\\t", "\\s", "\\n", "\\r"});
        }
        if ("&".equals(value2)) {
            return RegExpFactory.createLiteralCharOrEscape("\\&");
        }
        if (value2.startsWith("\\u{") && value2.endsWith("}")) {
            return RegExpFactory.createLiteralCharOrEscape(Utils.unescapeBallerina(value2));
        }
        return charOrEscape;
    }

    private static RegExpLiteralCharOrEscape createLiteralCharOrEscape(String charOrEscape) {
        return new RegExpLiteralCharOrEscape(charOrEscape);
    }

    private static RegExpCharacterClass createCharacterClass(String negation, Object[] charSet) {
        return new RegExpCharacterClass("[", negation, new RegExpCharSet(charSet), "]");
    }

    private static RegExpAtom translateCharacterClass(RegExpCharacterClass charClass) {
        RegExpCharSet charSet = charClass.getReCharSet();
        for (Object charAtom : charSet.getCharSetAtoms()) {
            if (charAtom instanceof RegExpCharSetRange) {
                RegExpCharSetRange range2 = (RegExpCharSetRange)charAtom;
                range2.setLhsCharSetAtom(RegExpFactory.translateCharInCharacterClass(range2.getLhsCharSetAtom()));
                range2.setRhsCharSetAom(RegExpFactory.translateCharInCharacterClass(range2.getRhsCharSetAtom()));
                continue;
            }
            if (charAtom == null) continue;
            charAtoms[i] = RegExpFactory.translateVisitor(charAtom);
        }
        return charClass;
    }

    private static Object translateVisitor(Object node) {
        if (node instanceof RegExpLiteralCharOrEscape) {
            RegExpLiteralCharOrEscape regExpLiteralCharOrEscape = (RegExpLiteralCharOrEscape)node;
            return RegExpFactory.translateLiteralCharOrEscape(regExpLiteralCharOrEscape);
        }
        if (node instanceof String) {
            String s = (String)node;
            return RegExpFactory.translateCharInCharacterClass(s);
        }
        return node;
    }

    private static String translateCharInCharacterClass(String originalValue) {
        if ("&".equals(originalValue)) {
            return "\\&";
        }
        if (originalValue.startsWith("\\u{") && originalValue.endsWith("}")) {
            return Utils.unescapeBallerina(originalValue);
        }
        return originalValue;
    }
}

