/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.regexp;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.regexp.Token;
import io.ballerina.runtime.internal.regexp.TokenKind;
import io.ballerina.runtime.internal.regexp.TokenReader;
import io.ballerina.runtime.internal.values.RegExpAssertion;
import io.ballerina.runtime.internal.values.RegExpAtom;
import io.ballerina.runtime.internal.values.RegExpAtomQuantifier;
import io.ballerina.runtime.internal.values.RegExpCapturingGroup;
import io.ballerina.runtime.internal.values.RegExpCharSet;
import io.ballerina.runtime.internal.values.RegExpCharSetRange;
import io.ballerina.runtime.internal.values.RegExpCharacterClass;
import io.ballerina.runtime.internal.values.RegExpDisjunction;
import io.ballerina.runtime.internal.values.RegExpFlagExpression;
import io.ballerina.runtime.internal.values.RegExpFlagOnOff;
import io.ballerina.runtime.internal.values.RegExpLiteralCharOrEscape;
import io.ballerina.runtime.internal.values.RegExpQuantifier;
import io.ballerina.runtime.internal.values.RegExpSequence;
import io.ballerina.runtime.internal.values.RegExpTerm;
import io.ballerina.runtime.internal.values.RegExpValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class TreeBuilder {
    private final TokenReader tokenReader;

    public TreeBuilder(TokenReader tokenReader) {
        this.tokenReader = tokenReader;
    }

    public RegExpValue parse() {
        RegExpDisjunction disjunction = this.readRegDisjunction();
        return new RegExpValue(disjunction);
    }

    public void parseInsertion() {
        this.readRegTerm();
    }

    private RegExpDisjunction readRegDisjunction() {
        ArrayList<Object> reSequenceList = new ArrayList<Object>();
        Token nextToken = this.peek();
        while (!this.isEndOfReDisjunction(nextToken.kind)) {
            RegExpSequence reSequence = this.readRegSequence();
            reSequenceList.add(reSequence);
            nextToken = this.peek();
            if (nextToken.kind != TokenKind.PIPE_TOKEN) continue;
            Token pipe = this.consume();
            reSequenceList.add(pipe.value);
            nextToken = this.peek();
        }
        return new RegExpDisjunction(reSequenceList.toArray());
    }

    private RegExpSequence readRegSequence() {
        ArrayList<RegExpTerm> termsList = new ArrayList<RegExpTerm>();
        Token nextToken = this.peek();
        while (!this.isEndOfReSequence(nextToken.kind)) {
            RegExpTerm reTerm = this.readRegTerm();
            termsList.add(reTerm);
            nextToken = this.peek();
        }
        return new RegExpSequence(termsList.toArray(new RegExpTerm[0]));
    }

    private RegExpTerm readRegTerm() {
        Token nextToken = this.peek();
        if (nextToken.kind == TokenKind.BITWISE_XOR_TOKEN || nextToken.kind == TokenKind.DOLLAR_TOKEN) {
            return this.readRegAssertion();
        }
        RegExpAtom reAtom = switch (nextToken.kind) {
            case TokenKind.RE_LITERAL_CHAR, TokenKind.RE_NUMERIC_ESCAPE, TokenKind.RE_CONTROL_ESCAPE, TokenKind.COMMA_TOKEN, TokenKind.DOT_TOKEN, TokenKind.DIGIT, TokenKind.MINUS_TOKEN, TokenKind.COLON_TOKEN -> this.readRegChars();
            case TokenKind.BACK_SLASH_TOKEN -> this.readRegEscapeChar();
            case TokenKind.OPEN_BRACKET_TOKEN -> this.readRegCharacterClass();
            case TokenKind.OPEN_PAREN_TOKEN -> this.readRegCapturingGroups();
            default -> throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_MISSING_BACKSLASH.messageKey(), nextToken.value));
        };
        RegExpQuantifier quantifier = this.readOptionalQuantifier();
        if (quantifier == null) {
            quantifier = new RegExpQuantifier("", "");
        }
        return new RegExpAtomQuantifier(reAtom, quantifier);
    }

    private RegExpAssertion readRegAssertion() {
        return new RegExpAssertion(this.consume().value);
    }

    private RegExpAtom readRegChars() {
        return new RegExpLiteralCharOrEscape(this.consume().value);
    }

    private RegExpLiteralCharOrEscape readRegEscapeChar() {
        Token backSlash = this.consume();
        return new RegExpLiteralCharOrEscape(this.readRegEscape(backSlash));
    }

    private String readRegEscape(Token backSlash) {
        Token nextToken = this.peek();
        return switch (nextToken.kind) {
            case TokenKind.RE_PROPERTY -> this.readRegUnicodePropertyEscape(backSlash.value);
            case TokenKind.DOT_TOKEN, TokenKind.BACK_SLASH_TOKEN, TokenKind.OPEN_BRACKET_TOKEN, TokenKind.OPEN_PAREN_TOKEN, TokenKind.BITWISE_XOR_TOKEN, TokenKind.DOLLAR_TOKEN, TokenKind.ASTERISK_TOKEN, TokenKind.PLUS_TOKEN, TokenKind.QUESTION_MARK_TOKEN, TokenKind.CLOSE_PAREN_TOKEN, TokenKind.CLOSE_BRACKET_TOKEN, TokenKind.OPEN_BRACE_TOKEN, TokenKind.CLOSE_BRACE_TOKEN, TokenKind.PIPE_TOKEN -> this.readRegQuoteEscape(backSlash.value);
            default -> {
                if (TreeBuilder.isReSimpleCharClassCode(nextToken)) {
                    yield this.readRegSimpleCharClassEscape(backSlash.value);
                }
                throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_INVALID_CHAR_AFTER_BACKSLASH.messageKey(), nextToken.value));
            }
        };
    }

    private String readRegUnicodePropertyEscape(String backSlash) {
        String property = this.consume().value;
        String openBrace = this.readOpenBrace();
        String unicodeProperty = this.readUnicodeProperty();
        String closeBrace = this.readCloseBrace();
        return backSlash + property + openBrace + unicodeProperty + closeBrace;
    }

    private String readOpenBrace() {
        try {
            Token nextToken = this.peek();
            if (nextToken.kind == TokenKind.OPEN_BRACE_TOKEN) {
                return this.consume().value;
            }
        }
        catch (BError bError) {
            // empty catch block
        }
        throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_MISSING_OPEN_BRACE.messageKey(), new Object[0]));
    }

    private String readUnicodeProperty() {
        Token nextToken = this.peek();
        if (nextToken.kind == TokenKind.RE_UNICODE_SCRIPT_START) {
            return this.readRegUnicodeScript();
        }
        return this.readRegUnicodeGeneralCategory();
    }

    private String readRegUnicodeScript() {
        Token scriptStart = this.consume();
        Token nextToken = this.peek();
        if (nextToken.kind == TokenKind.RE_UNICODE_PROPERTY_VALUE) {
            Token unicodePropertyValue = this.consume();
            return scriptStart.value + unicodePropertyValue.value;
        }
        throw ErrorCreator.createError(this.getErrorMsg(nextToken));
    }

    private String readRegUnicodeGeneralCategory() {
        Token nextToken = this.peek();
        Token scriptStart = null;
        if (nextToken.kind == TokenKind.RE_UNICODE_GENERAL_CATEGORY_START) {
            scriptStart = this.consume();
        }
        nextToken = this.peek();
        if (nextToken.kind == TokenKind.RE_UNICODE_GENERAL_CATEGORY_NAME) {
            Token generalCategory = this.consume();
            return scriptStart != null ? scriptStart.value + generalCategory.value : generalCategory.value;
        }
        throw ErrorCreator.createError(this.getErrorMsg(nextToken));
    }

    private String readCloseBrace() {
        try {
            Token nextToken = this.peek();
            if (nextToken.kind == TokenKind.CLOSE_BRACE_TOKEN) {
                return this.consume().value;
            }
        }
        catch (BError bError) {
            // empty catch block
        }
        throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_MISSING_CLOSE_BRACE.messageKey(), new Object[0]));
    }

    private String readRegQuoteEscape(String backSlash) {
        Token syntaxChar = this.consume();
        return backSlash + syntaxChar.value;
    }

    private String readRegSimpleCharClassEscape(String backSlash) {
        Token simpleCharClassCode = this.consume();
        return backSlash + simpleCharClassCode.value;
    }

    private RegExpCharacterClass readRegCharacterClass() {
        String characterClassStart = this.consume().value;
        String negation = this.readNegation();
        RegExpCharSet characterSet = this.readRegCharSet();
        String characterClassEnd = this.readCharacterClassEnd();
        if (negation.isEmpty() && characterSet.getCharSetAtoms().length == 0) {
            throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_EMPTY_CHARACTER_CLASS_DISALLOWED.messageKey(), new Object[0]));
        }
        return new RegExpCharacterClass(characterClassStart, negation, characterSet, characterClassEnd);
    }

    private String readNegation() {
        Token nextToken = this.peek();
        if (nextToken.kind == TokenKind.BITWISE_XOR_TOKEN) {
            return this.consume().value;
        }
        return "";
    }

    private RegExpCharSet readRegCharSet() {
        Token nextToken = this.peek();
        if (this.isCharacterClassEnd(nextToken.kind)) {
            return new RegExpCharSet(new Object[0]);
        }
        String startReCharSetAtom = this.readCharSetAtom(nextToken);
        nextToken = this.peek();
        if (this.isCharacterClassEnd(nextToken.kind)) {
            return new RegExpCharSet(new Object[]{startReCharSetAtom});
        }
        ArrayList<Object> charSetAtoms = new ArrayList<Object>();
        if (nextToken.kind == TokenKind.MINUS_TOKEN) {
            Token minus = this.consume();
            nextToken = this.peek();
            if (this.isCharacterClassEnd(nextToken.kind)) {
                return new RegExpCharSet(new Object[]{startReCharSetAtom, minus.value});
            }
            String rhsReCharSetAtom = this.readCharSetAtom(nextToken);
            if (TreeBuilder.isIncorrectCharRange(startReCharSetAtom, rhsReCharSetAtom)) {
                throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_INVALID_CHAR_CLASS_RANGE.messageKey(), startReCharSetAtom, rhsReCharSetAtom));
            }
            RegExpCharSetRange reCharSetRange = new RegExpCharSetRange(startReCharSetAtom, minus.value, rhsReCharSetAtom);
            RegExpCharSet reCharSet = this.readRegCharSet();
            charSetAtoms.add(reCharSetRange);
            if (reCharSet.getCharSetAtoms().length > 0) {
                charSetAtoms.addAll(Arrays.asList(reCharSet.getCharSetAtoms()));
            }
            return new RegExpCharSet(charSetAtoms.toArray());
        }
        charSetAtoms.add(startReCharSetAtom);
        RegExpCharSet reCharSetNoDash = this.readCharSetNoDash(nextToken);
        if (reCharSetNoDash.getCharSetAtoms().length > 0) {
            charSetAtoms.addAll(Arrays.asList(reCharSetNoDash.getCharSetAtoms()));
        }
        return new RegExpCharSet(charSetAtoms.toArray());
    }

    private RegExpCharSet readCharSetNoDash(Token nextToken) {
        String startReCharSetAtomNoDash = this.readCharSetAtom(nextToken);
        nextToken = this.peek();
        if (this.isCharacterClassEnd(nextToken.kind)) {
            return new RegExpCharSet(new Object[]{startReCharSetAtomNoDash});
        }
        ArrayList<Object> charSetAtoms = new ArrayList<Object>();
        if (nextToken.kind == TokenKind.MINUS_TOKEN) {
            Token minus = this.consume();
            nextToken = this.peek();
            if (this.isCharacterClassEnd(nextToken.kind)) {
                return new RegExpCharSet(new Object[]{startReCharSetAtomNoDash, minus.value});
            }
            String rhsReCharSetAtom = this.readCharSetAtom(nextToken);
            if (TreeBuilder.isIncorrectCharRange(startReCharSetAtomNoDash, rhsReCharSetAtom)) {
                throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_INVALID_CHAR_CLASS_RANGE.messageKey(), startReCharSetAtomNoDash, rhsReCharSetAtom));
            }
            RegExpCharSetRange reCharSetRange = new RegExpCharSetRange(startReCharSetAtomNoDash, minus.value, rhsReCharSetAtom);
            RegExpCharSet reCharSet = this.readRegCharSet();
            charSetAtoms.add(reCharSetRange);
            if (reCharSet.getCharSetAtoms().length > 0) {
                charSetAtoms.addAll(Arrays.asList(reCharSet.getCharSetAtoms()));
            }
            return new RegExpCharSet(charSetAtoms.toArray());
        }
        RegExpCharSet reCharSetNoDash = this.readCharSetNoDash(nextToken);
        charSetAtoms.add(startReCharSetAtomNoDash);
        if (reCharSetNoDash.getCharSetAtoms().length > 0) {
            charSetAtoms.addAll(Arrays.asList(reCharSetNoDash.getCharSetAtoms()));
        }
        return new RegExpCharSet(charSetAtoms.toArray());
    }

    private String readCharSetAtom(Token nextToken) {
        switch (nextToken.kind) {
            case RE_NUMERIC_ESCAPE: 
            case RE_CONTROL_ESCAPE: 
            case MINUS_TOKEN: {
                return this.consume().value;
            }
            case BACK_SLASH_TOKEN: {
                Token token = this.peek(2);
                if (token.kind == TokenKind.MINUS_TOKEN) {
                    return this.consume().value + this.consume().value;
                }
                return this.readRegEscape(this.consume());
            }
        }
        Token next2 = this.peek();
        if (this.isReCharSetLiteralChar(next2.value)) {
            return this.consume().value;
        }
        throw ErrorCreator.createError(this.getErrorMsg(next2));
    }

    private String readCharacterClassEnd() {
        Token nextToken = this.peek();
        if (nextToken.kind == TokenKind.CLOSE_BRACKET_TOKEN) {
            Token consumedToken = this.consume();
            return consumedToken.value;
        }
        throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_MISSING_CLOSE_BRACKET.messageKey(), new Object[0]));
    }

    private RegExpQuantifier readOptionalQuantifier() {
        Token nextToken = this.peek();
        return switch (nextToken.kind) {
            case TokenKind.ASTERISK_TOKEN, TokenKind.PLUS_TOKEN, TokenKind.QUESTION_MARK_TOKEN, TokenKind.OPEN_BRACE_TOKEN -> this.readReQuantifier();
            default -> null;
        };
    }

    private RegExpQuantifier readReQuantifier() {
        String quantifier = this.readBaseQuantifier();
        String nonGreedyChar = this.readNonGreedyChar();
        return new RegExpQuantifier(quantifier, nonGreedyChar);
    }

    private String readBaseQuantifier() {
        Token nextToken = this.peek();
        if (nextToken.kind != TokenKind.OPEN_BRACE_TOKEN) {
            Token consumedToken = this.consume();
            return consumedToken.value;
        }
        String openBrace = this.readOpenBrace();
        String leastDigits = this.readDigits(true);
        String comma = "";
        String mostDigits = "";
        nextToken = this.peek();
        if (nextToken.kind == TokenKind.COMMA_TOKEN) {
            Token consumedToken = this.consume();
            comma = consumedToken.value;
            mostDigits = this.readDigits(false);
        }
        String closeBrace = this.readCloseBrace();
        return openBrace + leastDigits + comma + mostDigits + closeBrace;
    }

    private String readDigits(boolean isLeastDigits) {
        StringBuilder digits = new StringBuilder();
        Token nextToken = this.peek();
        while (!this.isEndOfDigits(nextToken.kind, isLeastDigits)) {
            Token digit = this.consume();
            digits.append(digit.value);
            nextToken = this.peek();
        }
        return digits.toString();
    }

    private String readNonGreedyChar() {
        Token nextToken = this.peek();
        if (nextToken.kind == TokenKind.QUESTION_MARK_TOKEN) {
            Token consumedToken = this.consume();
            return consumedToken.value;
        }
        return "";
    }

    private RegExpCapturingGroup readRegCapturingGroups() {
        String openParenthesis = this.consume().value;
        Token nextToken = this.peek();
        RegExpFlagExpression flagExpression = nextToken.kind == TokenKind.QUESTION_MARK_TOKEN ? this.readFlagExpression() : new RegExpFlagExpression("", new RegExpFlagOnOff(""), "");
        RegExpDisjunction reDisjunction = this.readRegDisjunction();
        String closeParenthesis = this.readCloseParenthesis();
        return new RegExpCapturingGroup(openParenthesis, flagExpression, reDisjunction, closeParenthesis);
    }

    private RegExpFlagExpression readFlagExpression() {
        Token questionMark = this.consume();
        Token nextToken = this.peek();
        RegExpFlagOnOff reFlagsOnOff = !this.isEndOfFlagExpression(nextToken.kind) ? this.readRegFlagsOnOff() : new RegExpFlagOnOff("");
        String colon = this.consume().value;
        return new RegExpFlagExpression(questionMark.value, reFlagsOnOff, colon);
    }

    private RegExpFlagOnOff readRegFlagsOnOff() {
        String lhsReFlags = this.readRegFlags();
        Token nextToken = this.peek();
        String dash = "";
        String rhsFlags = "";
        if (nextToken.kind == TokenKind.MINUS_TOKEN) {
            Token minus = this.consume();
            dash = minus.value;
            rhsFlags = this.readRegFlags();
        }
        this.validateDuplicateFlags(lhsReFlags + rhsFlags);
        return new RegExpFlagOnOff(lhsReFlags + dash + rhsFlags);
    }

    private String readRegFlags() {
        StringBuilder flags = new StringBuilder();
        Token nextToken = this.peek();
        while (!this.isEndOfReFlags(nextToken.kind)) {
            if (!TreeBuilder.isReFlag(nextToken)) {
                throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_INVALID_FLAG.messageKey(), nextToken.value));
            }
            Token reFlag = this.consume();
            flags.append(reFlag.value);
            nextToken = this.peek();
        }
        return flags.toString();
    }

    private String readCloseParenthesis() {
        Token nextToken = this.peek();
        if (nextToken.kind == TokenKind.CLOSE_PAREN_TOKEN) {
            Token consumedToken = this.consume();
            return consumedToken.value;
        }
        throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_MISSING_CLOSE_PAREN.messageKey(), new Object[0]));
    }

    private boolean isEndOfReDisjunction(TokenKind kind) {
        return switch (kind) {
            case TokenKind.CLOSE_PAREN_TOKEN, TokenKind.EOF_TOKEN -> true;
            default -> false;
        };
    }

    private boolean isEndOfReSequence(TokenKind kind) {
        return switch (kind) {
            case TokenKind.CLOSE_PAREN_TOKEN, TokenKind.PIPE_TOKEN, TokenKind.EOF_TOKEN -> true;
            default -> false;
        };
    }

    private boolean isCharacterClassEnd(TokenKind kind) {
        return switch (kind) {
            case TokenKind.CLOSE_BRACKET_TOKEN, TokenKind.EOF_TOKEN -> true;
            default -> false;
        };
    }

    private boolean isReCharSetLiteralChar(String tokenText) {
        return switch (tokenText) {
            case "\\", "-", "]" -> false;
            default -> true;
        };
    }

    private boolean isEndOfFlagExpression(TokenKind kind) {
        return kind == TokenKind.COLON_TOKEN || kind == TokenKind.EOF_TOKEN;
    }

    private boolean isEndOfReFlags(TokenKind kind) {
        return kind == TokenKind.MINUS_TOKEN || kind == TokenKind.COLON_TOKEN || kind == TokenKind.EOF_TOKEN;
    }

    private boolean isEndOfDigits(TokenKind kind, boolean isLeastDigits) {
        return switch (kind) {
            case TokenKind.CLOSE_BRACE_TOKEN, TokenKind.EOF_TOKEN -> true;
            case TokenKind.COMMA_TOKEN -> isLeastDigits;
            default -> false;
        };
    }

    static boolean isIncorrectCharRange(String lhsValue, String rhsValue) {
        if (lhsValue.charAt(0) != '\\' && rhsValue.charAt(0) != '\\') {
            return lhsValue.compareTo(rhsValue) > 0;
        }
        return false;
    }

    static boolean isReSimpleCharClassCode(Token token) {
        if (token.kind != TokenKind.RE_LITERAL_CHAR) {
            return false;
        }
        return switch (token.value) {
            case "d", "D", "s", "S", "w", "W" -> true;
            default -> false;
        };
    }

    static boolean isReFlag(Token nextToken) {
        if (nextToken.kind != TokenKind.RE_LITERAL_CHAR) {
            return false;
        }
        return switch (nextToken.value) {
            case "m", "s", "i", "x" -> true;
            default -> false;
        };
    }

    private BString getErrorMsg(Token nextToken) {
        if (nextToken.kind == TokenKind.EOF_TOKEN) {
            return ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_INVALID_END_CHARACTER.messageKey(), new Object[0]);
        }
        return ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_INVALID_CHARACTER.messageKey(), nextToken.value);
    }

    private Token peek() {
        return this.tokenReader.peek();
    }

    private Token peek(int n) {
        return this.tokenReader.peek(n);
    }

    private Token consume() {
        return this.tokenReader.read();
    }

    private void validateDuplicateFlags(String flags) {
        HashSet<Character> charList = new HashSet<Character>();
        for (int i = 0; i < flags.length(); ++i) {
            char flag = flags.charAt(i);
            if (charList.contains(Character.valueOf(flag))) {
                throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_DUPLICATE_FLAG.messageKey(), Character.valueOf(flag)));
            }
            charList.add(Character.valueOf(flag));
        }
    }
}

