/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.scheduling;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.concurrent.StrandMetadata;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.FunctionType;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.api.types.RemoteMethodType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BNever;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.internal.BalRuntime;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.scheduling.StrandHolder;
import io.ballerina.runtime.internal.scheduling.WorkerChannelMap;
import io.ballerina.runtime.internal.types.BServiceType;
import io.ballerina.runtime.internal.utils.ErrorUtils;
import io.ballerina.runtime.internal.values.FPValue;
import io.ballerina.runtime.internal.values.FutureValue;
import io.ballerina.runtime.internal.values.ObjectValue;
import io.ballerina.runtime.internal.values.ValueCreator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;

public class Scheduler {
    public final ReentrantLock globalNonIsolatedLock = new ReentrantLock();
    private static final ThreadLocal<StrandHolder> strandHolder = ThreadLocal.withInitial(StrandHolder::new);
    public final BalRuntime runtime;

    public Scheduler(BalRuntime runtime2) {
        this.runtime = runtime2;
    }

    public static Strand getStrand() {
        return Scheduler.strandHolder.get().strand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callFunction(Module module, String functionName, StrandMetadata metadata, Object ... args2) {
        Strand strand = this.getStrand(functionName, metadata);
        if (strand.isRunnable()) {
            return this.callFunction(module, functionName, args2, strand);
        }
        try {
            strand.resume();
            Object object = this.callFunction(module, functionName, args2, strand);
            return object;
        }
        finally {
            strand.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callMethod(BObject object, String methodName, StrandMetadata metadata, Object ... args2) {
        Strand strand = this.getStrand(Scheduler.getStrandName(object, methodName), metadata);
        if (strand.isRunnable()) {
            return this.callMethod(object, methodName, args2, strand);
        }
        try {
            strand.resume();
            Object object2 = this.callMethod(object, methodName, args2, strand);
            return object2;
        }
        finally {
            strand.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callFP(FPValue fp, StrandMetadata metadata, Object ... args2) {
        Strand strand = this.getStrand(Scheduler.getStrandName(fp.getName()), metadata);
        if (strand.isRunnable()) {
            return this.callFp(fp, args2, strand);
        }
        try {
            strand.resume();
            Object object = this.callFp(fp, args2, strand);
            return object;
        }
        finally {
            strand.done();
        }
    }

    public FutureValue startIsolatedWorker(FPValue fp, Strand parentStrand, Type returnType, String strandName, WorkerChannelMap workerChannelMap, Object[] args2) {
        FutureValue future2 = this.createFuture(parentStrand, strandName, true, returnType, null, workerChannelMap);
        args2[0] = future2.strand;
        Thread.startVirtualThread(() -> {
            try {
                Scheduler.strandHolder.get().strand = future2.strand;
                Object result = fp.function.apply(args2);
                future2.completableFuture.complete(result);
            }
            catch (Throwable t) {
                future2.completableFuture.completeExceptionally(ErrorUtils.createErrorFromThrowable(t));
            }
        }).setName(future2.strand.name);
        return future2;
    }

    public FutureValue startNonIsolatedWorker(FPValue fp, Strand parentStrand, Type returnType, String strandName, WorkerChannelMap workerChannelMap, Object[] args2) {
        FutureValue future2 = this.createFuture(parentStrand, strandName, false, returnType, null, workerChannelMap);
        args2[0] = future2.strand;
        Thread.startVirtualThread(() -> {
            try {
                future2.strand.resume();
                Scheduler.strandHolder.get().strand = future2.strand;
                Object result = fp.function.apply(args2);
                future2.completableFuture.complete(result);
            }
            catch (Throwable t) {
                future2.completableFuture.completeExceptionally(ErrorUtils.createErrorFromThrowable(t));
            }
            finally {
                future2.strand.done();
            }
        }).setName(future2.strand.name);
        return future2;
    }

    private Strand getStrand(String strandName, StrandMetadata metadata) {
        Strand strand = Scheduler.getStrand();
        Map<String, Object> properties = null;
        boolean isIsolated = false;
        if (metadata != null) {
            properties = metadata.properties();
            isIsolated = metadata.isConcurrentSafe();
        }
        if (strand == null) {
            Scheduler.strandHolder.get().strand = strand = this.createStrand(null, strandName, isIsolated, properties, null);
        }
        return strand;
    }

    private Object callFunction(Module module, String functionName, Object[] args2, Strand parentStrand) {
        ValueCreatorAndFunctionType functionType = this.getGetValueCreatorAndFunctionType(module, functionName);
        Object[] argsWithDefaultValues = this.getArgsWithDefaultValues(functionType.valueCreator(), functionType.functionType(), parentStrand, args2);
        return functionType.valueCreator().call(parentStrand, functionName, argsWithDefaultValues);
    }

    private Object callMethod(BObject object, String methodName, Object[] args2, Strand parentStrand) {
        ObjectType objectType = (ObjectType)TypeUtils.getImpliedType(object.getOriginalType());
        MethodType methodType = this.getObjectMethodType(methodName, objectType);
        Object[] argsWithDefaultValues = this.getArgsWithDefaultValues(objectType, methodType, parentStrand, args2);
        return ((ObjectValue)object).call(parentStrand, methodName, argsWithDefaultValues);
    }

    private Object callFp(FPValue fp, Object[] args2, Strand parentStrand) {
        FunctionType functionType = (FunctionType)TypeUtils.getImpliedType(TypeUtils.getType(fp));
        Object[] argsWithDefaultValues = this.getArgsWithDefaultValues(parentStrand, args2, functionType);
        Object[] argsWithStrand = Scheduler.getArgsWithStrand(parentStrand, argsWithDefaultValues);
        return fp.function.apply(argsWithStrand);
    }

    private Object[] getArgsWithDefaultValues(Strand parentStrand, Object[] args2, FunctionType functionType) {
        Module module = functionType.getPackage();
        if (module == null) {
            return args2;
        }
        ValueCreator valueCreator = ValueCreator.getValueCreator(ValueCreator.getLookupKey(module));
        return this.getArgsWithDefaultValues(valueCreator, functionType, parentStrand, args2);
    }

    public FutureValue startNonIsolatedWorker(Function<Object[], Object> function2, Strand parentStrand, Type returnType, String strandName, StrandMetadata metadata, Object[] args2) {
        FutureValue future2 = this.createFutureWithMetadata(parentStrand, strandName, false, returnType, metadata, null);
        Object[] argsWithStrand = Scheduler.getArgsWithStrand(future2.strand, args2);
        Thread.startVirtualThread(() -> {
            try {
                future2.strand.resume();
                Scheduler.strandHolder.get().strand = future2.strand;
                Object result = function2.apply(argsWithStrand);
                future2.completableFuture.complete(result);
            }
            catch (Throwable t) {
                future2.completableFuture.completeExceptionally(ErrorUtils.createErrorFromThrowable(t));
            }
            finally {
                future2.strand.done();
            }
        }).setName(strandName);
        return future2;
    }

    private ValueCreatorAndFunctionType getGetValueCreatorAndFunctionType(Module module, String functionName) {
        FunctionType functionType;
        ValueCreator valueCreator;
        try {
            valueCreator = ValueCreator.getValueCreator(ValueCreator.getLookupKey(module.getOrg(), module.getName(), module.getMajorVersion(), false));
            functionType = valueCreator.getFunctionType(functionName);
        }
        catch (BError error2) {
            valueCreator = ValueCreator.getValueCreator(ValueCreator.getLookupKey(module.getOrg(), module.getName(), module.getMajorVersion(), true));
            functionType = valueCreator.getFunctionType(functionName);
        }
        return new ValueCreatorAndFunctionType(valueCreator, functionType);
    }

    private Object[] getArgsWithDefaultValues(ObjectType objectType, MethodType methodType, Strand strand, Object ... args2) {
        Module module = objectType.getPackage();
        ValueCreator valueCreator = ValueCreator.getValueCreator(ValueCreator.getLookupKey(module));
        return this.getArgsWithDefaultValues(valueCreator, (FunctionType)methodType, strand, args2);
    }

    private Object[] getArgsWithDefaultValues(ValueCreator valueCreator, FunctionType functionType, Strand strand, Object ... args2) {
        int length2;
        Parameter[] parameters = functionType.getParameters();
        if (args2.length == 0 && parameters.length == 0) {
            return new Object[0];
        }
        int n = length2 = functionType.getRestType() == null ? parameters.length : parameters.length + 1;
        if (length2 < args2.length) {
            length2 = args2.length;
        }
        Object[] argsWithDefaultValues = new Object[length2];
        System.arraycopy(args2, 0, argsWithDefaultValues, 0, args2.length);
        for (int i = 0; i < parameters.length; ++i) {
            Object defaultValue;
            Parameter parameter = parameters[i];
            if (!parameter.isDefault || args2.length > i && args2[i] != BNever.getValue()) continue;
            argsWithDefaultValues[i] = defaultValue = valueCreator.call(strand, parameter.defaultFunctionName, argsWithDefaultValues);
        }
        return argsWithDefaultValues;
    }

    public MethodType getObjectMethodType(String methodName, ObjectType objectType) {
        MethodType[] objectTypeMethods;
        HashMap<String, MethodType> methodTypesMap = new HashMap<String, MethodType>();
        if (objectType.getTag() == 31) {
            RemoteMethodType[] remoteMethodTypes;
            MethodType[] resourceMethods;
            BServiceType serviceType = (BServiceType)objectType;
            for (MethodType resourceMethodType : resourceMethods = serviceType.getResourceMethods()) {
                methodTypesMap.put(resourceMethodType.getName(), resourceMethodType);
            }
            for (RemoteMethodType remoteMethodType : remoteMethodTypes = serviceType.getRemoteMethods()) {
                methodTypesMap.put(remoteMethodType.getName(), remoteMethodType);
            }
        }
        for (MethodType methodType : objectTypeMethods = objectType.getMethods()) {
            methodTypesMap.put(methodType.getName(), methodType);
        }
        MethodType methodType = (MethodType)methodTypesMap.get(methodName);
        if (methodType != null) {
            return methodType;
        }
        throw ErrorCreator.createError(StringUtils.fromString("No such method: " + methodName));
    }

    public FutureValue createFutureWithMetadata(Strand parentStrand, String strandName, boolean isIsolated, Type constraint, StrandMetadata metadata, WorkerChannelMap workerChannelMap) {
        if (metadata != null) {
            return this.createFuture(parentStrand, strandName, isIsolated, constraint, metadata.properties(), workerChannelMap);
        }
        return this.createFuture(parentStrand, strandName, isIsolated, constraint, null, workerChannelMap);
    }

    public FutureValue createFuture(Strand parentStrand, String strandName, boolean isIsolated, Type constraint, Map<String, Object> properties, WorkerChannelMap workerChannelMap) {
        return this.createFuture(constraint, this.createStrand(parentStrand, strandName, isIsolated, properties, workerChannelMap));
    }

    private Strand createStrand(Strand parentStrand, String strandName, boolean isIsolated, Map<String, Object> properties, WorkerChannelMap workerChannelMap) {
        return new Strand(this, strandName, parentStrand, isIsolated, properties, workerChannelMap, parentStrand != null ? parentStrand.currentTrxContext : null);
    }

    private FutureValue createFuture(Type constraint, Strand newStrand) {
        return new FutureValue(newStrand, constraint);
    }

    private static String getStrandName(String strandName) {
        if (strandName == null) {
            strandName = "$anon";
        }
        return strandName;
    }

    private static String getStrandName(BObject bObject, String methodName) {
        return bObject.getOriginalType().getName() + ":" + methodName;
    }

    private static Object[] getArgsWithStrand(Strand parentStrand, Object[] args2) {
        Object[] argsWithStrand = new Object[args2.length + 1];
        System.arraycopy(args2, 0, argsWithStrand, 1, args2.length);
        argsWithStrand[0] = parentStrand;
        return argsWithStrand;
    }

    private record ValueCreatorAndFunctionType(ValueCreator valueCreator, FunctionType functionType) {
    }
}

