/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.scheduling;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BMapInitialValueEntry;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.scheduling.AsyncUtils;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.scheduling.WorkerChannel;
import io.ballerina.runtime.internal.scheduling.WorkerChannelMap;
import io.ballerina.runtime.internal.values.ErrorValue;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class WorkerUtils {
    public static void asyncSend(WorkerChannelMap workerChannelMap, String channelKey, Object result) {
        WorkerChannel channel = workerChannelMap.get(channelKey);
        channel.write(result);
    }

    public static Object syncSend(Strand strand, WorkerChannelMap workerChannelMap, String channelKey, Object result) {
        WorkerChannel channel = workerChannelMap.get(channelKey);
        channel.write(result);
        Object waitResult = AsyncUtils.handleWait(strand, channel.getReceiveFuture());
        if (waitResult instanceof BError) {
            BError error2 = (BError)waitResult;
            return error2;
        }
        return null;
    }

    public static Object flush(Strand strand, WorkerChannelMap workerChannelMap, String[] workerChannelKeys) {
        CompletableFuture[] futures = new CompletableFuture[workerChannelKeys.length];
        WorkerChannel[] channels = new WorkerChannel[workerChannelKeys.length];
        for (int i = 0; i < workerChannelKeys.length; ++i) {
            WorkerChannel channel = workerChannelMap.get(workerChannelKeys[i]);
            futures[i] = channel.getReceiveFuture();
            channels[i] = channel;
        }
        if (strand.isIsolated) {
            AsyncUtils.waitForAllFutureResult(futures);
        } else {
            AsyncUtils.handleNonIsolatedStrand(strand, () -> {
                AsyncUtils.waitForAllFutureResult(futures);
                return null;
            });
        }
        for (WorkerChannel channel : channels) {
            Object result = channel.getReceiveFuture().resultNow();
            if (!(result instanceof ErrorValue)) continue;
            ErrorValue errorValue = (ErrorValue)result;
            return errorValue;
        }
        return null;
    }

    public static Object receive(Strand strand, WorkerChannelMap workerChannelMap, String channelKey) {
        WorkerChannel channel = workerChannelMap.get(channelKey);
        if (strand.isIsolated) {
            return channel.read();
        }
        return AsyncUtils.handleNonIsolatedStrand(strand, channel::read);
    }

    public static Object alternateReceive(Strand strand, WorkerChannelMap workerChannelMap, String[] workerChannelKeys) {
        WorkerChannel[] channels = new WorkerChannel[workerChannelKeys.length];
        int count2 = 0;
        for (String workerChanelKey : workerChannelKeys) {
            channels[count2++] = workerChannelMap.get(workerChanelKey);
        }
        CompletableFuture[] futures = new CompletableFuture[channels.length];
        for (int i = 0; i < channels.length; ++i) {
            futures[i] = channels[i].getResultFuture();
        }
        return WorkerUtils.getAlternativeReceiveResult(strand, futures, channels);
    }

    public static BMap<BString, Object> multipleReceive(Strand strand, WorkerChannelMap workerChannelMap, Map<String, String> channelFieldNameMap, Type targetType) {
        WorkerChannel[] channels = new WorkerChannel[channelFieldNameMap.size()];
        int count2 = 0;
        for (Map.Entry<String, String> entry : channelFieldNameMap.entrySet()) {
            channels[count2++] = workerChannelMap.get(entry.getValue());
        }
        CompletableFuture[] futures = new CompletableFuture[channels.length];
        for (int i = 0; i < channels.length; ++i) {
            futures[i] = channels[i].getResultFuture();
        }
        if (strand.isIsolated) {
            AsyncUtils.waitForAllFutureResult(futures);
            return WorkerUtils.getMultipleReceiveResult(workerChannelMap, channelFieldNameMap, targetType, channels);
        }
        return (BMap)AsyncUtils.handleNonIsolatedStrand(strand, () -> {
            AsyncUtils.waitForAllFutureResult(futures);
            return WorkerUtils.getMultipleReceiveResult(workerChannelMap, channelFieldNameMap, targetType, channels);
        });
    }

    public static void addWorkerChannels(WorkerChannelMap workerChannelMap, String[] workerChannelKeys) {
        workerChannelMap.addChannelKeys(workerChannelKeys);
    }

    public static void completedWorkerChannels(WorkerChannelMap workerChannelMap, Object returnValue, String[] sendWorkerChannelKeys, String[] receiveWorkerChannelKeys) {
        if (sendWorkerChannelKeys == null && receiveWorkerChannelKeys == null) {
            return;
        }
        if (sendWorkerChannelKeys != null) {
            for (String channelKey : sendWorkerChannelKeys) {
                workerChannelMap.completeSendWorkerChannels(channelKey, returnValue);
            }
        }
        if (receiveWorkerChannelKeys != null) {
            for (String channelKey : receiveWorkerChannelKeys) {
                workerChannelMap.completeReceiveWorkerChannels(channelKey, returnValue);
            }
        }
    }

    public static void completeWorkerChannelsWithPanic(WorkerChannelMap workerChannelMap, Throwable throwable, String[] sendWorkerChannelKeys, String[] receiveWorkerChannelKeys) {
        BError bError;
        if (sendWorkerChannelKeys == null && receiveWorkerChannelKeys == null) {
            return;
        }
        BError error2 = throwable instanceof BError ? (bError = (BError)throwable) : ErrorCreator.createError(throwable);
        if (sendWorkerChannelKeys != null) {
            for (String channelKey : sendWorkerChannelKeys) {
                workerChannelMap.panicSendWorkerChannels(channelKey, error2);
            }
        }
        if (receiveWorkerChannelKeys != null) {
            for (String channelKey : receiveWorkerChannelKeys) {
                workerChannelMap.panicReceiveWorkerChannels(channelKey, error2);
            }
        }
    }

    private static Object getAlternativeReceiveResult(Strand strand, CompletableFuture<?>[] completableFutures, WorkerChannel[] channels) {
        Object result = AsyncUtils.handleWaitAny(strand, completableFutures);
        for (WorkerChannel channel : channels) {
            channel.read();
        }
        return result;
    }

    private static BMap<BString, Object> getMultipleReceiveResult(WorkerChannelMap workerChannelMap, Map<String, String> channelFieldNameMap, Type targetType, WorkerChannel[] channels) {
        int count2 = 0;
        BMapInitialValueEntry[] initialValueEntries = new BMapInitialValueEntry[channels.length];
        for (Map.Entry<String, String> entry : channelFieldNameMap.entrySet()) {
            WorkerChannel channel = workerChannelMap.get(entry.getValue());
            initialValueEntries[count2++] = ValueCreator.createKeyFieldEntry(StringUtils.fromString(entry.getKey()), channel.read());
        }
        if (targetType.getTag() == 24) {
            return ValueCreator.createMapValue((RecordType)targetType, initialValueEntries);
        }
        return ValueCreator.createMapValue((MapType)targetType, initialValueEntries);
    }

    private WorkerUtils() {
    }
}

