/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.flags.TypeFlags;
import io.ballerina.runtime.api.types.AnydataType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.TypeCheckCache;
import io.ballerina.runtime.api.types.semtype.TypeCheckCacheFactory;
import io.ballerina.runtime.internal.types.BIntersectionType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.types.TypeIdSupplier;
import io.ballerina.runtime.internal.values.RefValue;

public class BAnydataType
extends BUnionType
implements AnydataType {
    private static final BasicTypeBitSet BASIC_TYPE;
    private static final int TYPE_ID_RW;
    private static final int TYPE_ID_RO;
    private static final TypeCheckCache TYPE_CHECK_CACHE_RW;
    private static final TypeCheckCache TYPE_CHECK_CACHE_RO;

    public BAnydataType(String typeName, Module pkg, boolean readonly) {
        super(typeName, pkg, readonly, RefValue.class, false);
        if (!readonly) {
            BAnydataType immutableAnydataType = new BAnydataType("anydata & readonly", pkg, true);
            this.immutableType = new BIntersectionType(pkg, new Type[]{this, PredefinedTypes.TYPE_READONLY}, immutableAnydataType, TypeFlags.asMask(1, 2, 4), true);
            this.typeId = TYPE_ID_RW;
            this.typeCheckCache = TYPE_CHECK_CACHE_RW;
        } else {
            this.typeId = TYPE_ID_RO;
            this.typeCheckCache = TYPE_CHECK_CACHE_RO;
        }
        this.mergeUnionType((BUnionType)((Object)PredefinedTypes.TYPE_ANYDATA));
    }

    public BAnydataType(BUnionType unionType, String typeName, boolean readonly) {
        super(unionType, typeName, readonly, false);
        if (!readonly) {
            BAnydataType immutableAnydataType = new BAnydataType(unionType, "anydata & readonly", true);
            this.immutableType = new BIntersectionType(this.pkg, new Type[]{this, PredefinedTypes.TYPE_READONLY}, immutableAnydataType, TypeFlags.asMask(1, 2, 4), true);
            this.typeId = TYPE_ID_RW;
            this.typeCheckCache = TYPE_CHECK_CACHE_RW;
        } else {
            this.typeId = TYPE_ID_RO;
            this.typeCheckCache = TYPE_CHECK_CACHE_RO;
        }
    }

    @Override
    public <V> V getZeroValue() {
        return null;
    }

    @Override
    public <V> V getEmptyValue() {
        return null;
    }

    @Override
    public int getTag() {
        return 23;
    }

    @Override
    public boolean isNilable() {
        return true;
    }

    @Override
    public String toString() {
        if (this.typeName != null) {
            return this.typeName;
        }
        return super.toString();
    }

    @Override
    public SemType createSemType(Context cx) {
        SemType semType = Builder.getAnyDataType();
        if (this.isReadOnly()) {
            semType = Core.intersect(semType, Builder.getReadonlyType());
        }
        return semType;
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    static {
        TYPE_ID_RW = TypeIdSupplier.getReservedId();
        TYPE_ID_RO = TypeIdSupplier.getReservedId();
        TYPE_CHECK_CACHE_RW = TypeCheckCacheFactory.create();
        TYPE_CHECK_CACHE_RO = TypeCheckCacheFactory.create();
        SemType anydata2 = Builder.getAnyDataType();
        BASIC_TYPE = new BasicTypeBitSet(anydata2.all() | anydata2.some());
    }
}

