/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.BooleanType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.ConcurrentLazySupplier;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.types.BSemTypeWrapper;
import io.ballerina.runtime.internal.types.BType;
import java.util.function.Supplier;

public final class BBooleanType
extends BSemTypeWrapper<BBooleanTypeImpl>
implements BooleanType {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getBooleanType();
    private static final BBooleanType TRUE = new BBooleanType(() -> new BBooleanTypeImpl("boolean", PredefinedTypes.EMPTY_MODULE), "boolean", PredefinedTypes.EMPTY_MODULE, Builder.getBooleanConst(true));
    private static final BBooleanType FALSE = new BBooleanType(() -> new BBooleanTypeImpl("boolean", PredefinedTypes.EMPTY_MODULE), "boolean", PredefinedTypes.EMPTY_MODULE, Builder.getBooleanConst(false));

    public BBooleanType(String typeName, Module pkg) {
        this(() -> new BBooleanTypeImpl(typeName, pkg), typeName, pkg, Builder.getBooleanType());
    }

    public static BBooleanType singletonType(boolean value2) {
        return value2 ? TRUE : FALSE;
    }

    private BBooleanType(Supplier<BBooleanTypeImpl> bTypeSupplier, String typeName, Module pkg, SemType semType) {
        super(new ConcurrentLazySupplier<BBooleanTypeImpl>(bTypeSupplier), typeName, pkg, 6, semType);
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    protected static final class BBooleanTypeImpl
    extends BType
    implements BooleanType {
        private BBooleanTypeImpl(String typeName, Module pkg) {
            super(typeName, pkg, Boolean.class, false);
        }

        @Override
        public <V> V getZeroValue() {
            return (V)Boolean.FALSE;
        }

        @Override
        public <V> V getEmptyValue() {
            return (V)Boolean.FALSE;
        }

        @Override
        public int getTag() {
            return 6;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public BasicTypeBitSet getBasicType() {
            return BASIC_TYPE;
        }
    }
}

