/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.types.ByteType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.ConcurrentLazySupplier;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.types.BSemTypeWrapper;
import io.ballerina.runtime.internal.types.BType;
import java.util.function.Supplier;

public final class BByteType
extends BSemTypeWrapper<BByteTypeImpl>
implements ByteType {
    private static final BByteTypeImpl DEFAULT_B_TYPE = new BByteTypeImpl("byte", PredefinedTypes.EMPTY_MODULE);
    private static final BasicTypeBitSet BASIC_TYPE_BIT_SET = Builder.getIntType();

    public BByteType(String typeName, Module pkg) {
        this(() -> new BByteTypeImpl(typeName, pkg), typeName, PredefinedTypes.EMPTY_MODULE, Builder.createIntRange(0L, RuntimeConstants.UNSIGNED8_MAX_VALUE.intValue()));
    }

    private BByteType(Supplier<BByteTypeImpl> bTypeSupplier, String typeName, Module pkg, SemType semType) {
        super(new ConcurrentLazySupplier<BByteTypeImpl>(bTypeSupplier), typeName, pkg, 2, semType);
    }

    public static BByteType singletonType(long value2) {
        return new BByteType(() -> (BByteTypeImpl)DEFAULT_B_TYPE.clone(), "byte", PredefinedTypes.EMPTY_MODULE, Builder.getIntConst(value2));
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE_BIT_SET;
    }

    protected static final class BByteTypeImpl
    extends BType
    implements ByteType,
    Cloneable {
        private BByteTypeImpl(String typeName, Module pkg) {
            super(typeName, pkg, Integer.class, false);
        }

        @Override
        public <V> V getZeroValue() {
            return (V)new Integer(0);
        }

        @Override
        public <V> V getEmptyValue() {
            return (V)new Integer(0);
        }

        @Override
        public int getTag() {
            return 2;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public BasicTypeBitSet getBasicType() {
            return BASIC_TYPE_BIT_SET;
        }

        @Override
        public BType clone() {
            return super.clone();
        }
    }
}

