/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.flags.TypeFlags;
import io.ballerina.runtime.api.types.FiniteType;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.ShapeAnalyzer;
import io.ballerina.runtime.api.types.semtype.TypeCheckCache;
import io.ballerina.runtime.api.types.semtype.TypeCheckCacheFactory;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.types.TypeIdSupplier;
import io.ballerina.runtime.internal.types.semtype.CacheFactory;
import io.ballerina.runtime.internal.values.RefValue;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;

public class BFiniteType
extends BType
implements FiniteType {
    public Set<Object> valueSpace;
    private int typeFlags;
    private String originalName;
    private BasicTypeBitSet basicType;

    public BFiniteType(String typeName) {
        this(typeName, new LinkedHashSet<Object>(), 0);
    }

    public BFiniteType(String typeName, Set<Object> values, int typeFlags) {
        this(typeName, typeName, values, typeFlags);
    }

    public BFiniteType(String typeName, String originalName, Set<Object> values, int typeFlags) {
        super(typeName, null, RefValue.class, false);
        this.valueSpace = values;
        this.typeFlags = typeFlags;
        this.originalName = originalName;
        if (this.originalName != null && !originalName.isEmpty()) {
            TypeCheckCacheData.TypeCheckFlyweight flyweight = TypeCheckCacheData.get(originalName);
            this.typeId = flyweight.typeId;
            this.typeCheckCache = flyweight.typeCheckCache;
        } else {
            this.initializeCache();
        }
    }

    @Override
    public <V> V getZeroValue() {
        if (this.valueSpace.stream().anyMatch(val2 -> val2 == null || TypeChecker.getType(val2).isNilable())) {
            return null;
        }
        Iterator<Object> valueIterator = this.valueSpace.iterator();
        Object firstVal = valueIterator.next();
        if (this.isSingletonType()) {
            return (V)firstVal;
        }
        Object implicitInitValOfType = TypeChecker.getType(firstVal).getZeroValue();
        if (implicitInitValOfType.equals(firstVal)) {
            return implicitInitValOfType;
        }
        while (valueIterator.hasNext()) {
            Object value2 = valueIterator.next();
            if (!implicitInitValOfType.equals(value2)) continue;
            return implicitInitValOfType;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.originalName;
    }

    @Override
    public <V> V getEmptyValue() {
        if (this.valueSpace.stream().anyMatch(val2 -> val2 == null || TypeChecker.getType(val2).isNilable())) {
            return null;
        }
        Iterator<Object> valueIterator = this.valueSpace.iterator();
        Object firstVal = valueIterator.next();
        if (this.isSingletonType()) {
            return (V)firstVal;
        }
        Object implicitInitValOfType = TypeChecker.getType(firstVal).getEmptyValue();
        if (implicitInitValOfType.equals(firstVal)) {
            return implicitInitValOfType;
        }
        while (valueIterator.hasNext()) {
            Object value2 = valueIterator.next();
            if (!implicitInitValOfType.equals(value2)) continue;
            return implicitInitValOfType;
        }
        return null;
    }

    @Override
    public int getTag() {
        return 46;
    }

    private boolean isSingletonType() {
        return this.valueSpace.size() == 1;
    }

    @Override
    public boolean isAnydata() {
        return TypeFlags.isFlagOn(this.typeFlags, 2);
    }

    @Override
    public boolean isPureType() {
        return TypeFlags.isFlagOn(this.typeFlags, 4);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        if (this.basicType == null) {
            this.basicType = this.valueSpace.stream().map(TypeChecker::getBasicType).reduce(Builder.getNeverType(), BasicTypeBitSet::union);
        }
        return this.basicType;
    }

    @Override
    public Set<Object> getValueSpace() {
        return this.valueSpace;
    }

    @Override
    public int getTypeFlags() {
        return this.typeFlags;
    }

    @Override
    public String toString() {
        if (this.typeName != null && !this.typeName.isEmpty() && !this.typeName.startsWith("$anonType$")) {
            return this.typeName;
        }
        StringJoiner joiner = new StringJoiner("|");
        block6: for (Object value2 : this.valueSpace) {
            switch (TypeUtils.getType(value2).getTag()) {
                case 3: {
                    joiner.add(String.valueOf(value2) + "f");
                    continue block6;
                }
                case 4: {
                    joiner.add(String.valueOf(value2) + "d");
                    continue block6;
                }
                case 5: 
                case 13: {
                    joiner.add("\"" + String.valueOf(value2) + "\"");
                    continue block6;
                }
                case 14: {
                    joiner.add("()");
                    continue block6;
                }
            }
            joiner.add(value2.toString());
        }
        return this.valueSpace.size() == 1 ? joiner.toString() : "(" + String.valueOf(joiner) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BFiniteType)) {
            return false;
        }
        BFiniteType that = (BFiniteType)o;
        if (this.valueSpace.size() != that.valueSpace.size()) {
            return false;
        }
        for (Object each : this.valueSpace) {
            try {
                if (that.valueSpace.contains(each)) continue;
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }
        return true;
    }

    @Override
    public SemType createSemType(Context cx) {
        return this.valueSpace.stream().map(each -> ShapeAnalyzer.inherentTypeOf(cx, each)).map(Optional::orElseThrow).reduce(Builder.getNeverType(), Core::union);
    }

    private static class TypeCheckCacheData {
        private static final Map<String, TypeCheckFlyweight> cache = CacheFactory.createCachingHashMap();

        private TypeCheckCacheData() {
        }

        private static TypeCheckFlyweight get(String originalName) {
            return cache.computeIfAbsent(originalName, TypeCheckCacheData::create);
        }

        private static TypeCheckFlyweight create(String originalName) {
            return new TypeCheckFlyweight(TypeIdSupplier.getAnonId(), TypeCheckCacheFactory.create());
        }

        private record TypeCheckFlyweight(int typeId, TypeCheckCache typeCheckCache) {
        }
    }
}

