/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.flags.TypeFlags;
import io.ballerina.runtime.api.types.IntersectableReferenceType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.ShapeAnalyzer;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.internal.types.BErrorType;
import io.ballerina.runtime.internal.types.BObjectType;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.types.DistinctIdSupplier;
import io.ballerina.runtime.internal.types.MayBeDependentType;
import io.ballerina.runtime.internal.types.ShapeSupplier;
import io.ballerina.runtime.internal.types.TypeWithShape;
import io.ballerina.runtime.internal.types.semtype.ErrorUtils;
import io.ballerina.runtime.internal.types.semtype.ObjectDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;

public class BIntersectionType
extends BType
implements IntersectionType,
TypeWithShape {
    private static final String PADDED_AMPERSAND = " & ";
    private static final String OPENING_PARENTHESIS = "(";
    private static final String CLOSING_PARENTHESIS = ")";
    public final List<Type> constituentTypes;
    private Type effectiveType;
    private final int typeFlags;
    private final boolean readonly;
    private IntersectionType immutableType;
    private IntersectionType intersectionType = null;
    private String cachedToString;
    private boolean resolving;
    private Boolean shouldCache = null;
    private BasicTypeBitSet basicType;

    public BIntersectionType(Module pkg, Type[] constituentTypes, Type effectiveType, int typeFlags, boolean readonly) {
        this("intersection", pkg, constituentTypes, typeFlags, readonly);
        this.effectiveType = effectiveType;
    }

    public BIntersectionType(Module pkg, Type[] constituentTypes, IntersectableReferenceType effectiveType, int typeFlags, boolean readonly) {
        this("intersection", pkg, constituentTypes, typeFlags, readonly);
        this.effectiveType = effectiveType;
        effectiveType.setIntersectionType(this);
    }

    public BIntersectionType(String typeName, Module pkg, Type[] constituentTypes, Type effectiveType, int typeFlags, boolean readonly) {
        this(typeName, pkg, constituentTypes, typeFlags, readonly);
        this.effectiveType = effectiveType;
    }

    public BIntersectionType(String typeName, Module pkg, Type[] constituentTypes, IntersectableReferenceType effectiveType, int typeFlags, boolean readonly) {
        this(typeName, pkg, constituentTypes, typeFlags, readonly);
        this.effectiveType = effectiveType;
        effectiveType.setIntersectionType(this);
    }

    private BIntersectionType(String typeName, Module pkg, Type[] constituentTypes, int typeFlags, boolean readonly) {
        super(typeName, pkg, Object.class, true);
        this.constituentTypes = Arrays.asList(constituentTypes);
        this.typeFlags = typeFlags;
        this.readonly = readonly;
        if (readonly) {
            this.immutableType = this;
        }
    }

    @Override
    public List<Type> getConstituentTypes() {
        return new ArrayList<Type>(this.constituentTypes);
    }

    @Override
    public <V> V getZeroValue() {
        return this.effectiveType.getZeroValue();
    }

    @Override
    public <V> V getEmptyValue() {
        return this.effectiveType.getEmptyValue();
    }

    @Override
    public int getTag() {
        return 34;
    }

    @Override
    public String toString() {
        if (this.resolving) {
            return "";
        }
        this.resolving = true;
        this.computeStringRepresentation();
        this.resolving = false;
        return this.cachedToString;
    }

    private void computeStringRepresentation() {
        if (this.cachedToString != null) {
            return;
        }
        StringJoiner joiner = new StringJoiner(PADDED_AMPERSAND, OPENING_PARENTHESIS, CLOSING_PARENTHESIS);
        for (Type constituentType : this.constituentTypes) {
            if (constituentType.getTag() == 14) {
                joiner.add("()");
                continue;
            }
            joiner.add(constituentType.toString());
        }
        this.cachedToString = joiner.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BIntersectionType)) {
            return false;
        }
        BIntersectionType that = (BIntersectionType)o;
        if (this.constituentTypes.size() != that.constituentTypes.size()) {
            return false;
        }
        for (int i = 0; i < this.constituentTypes.size(); ++i) {
            if (this.constituentTypes.get(i).equals(that.constituentTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.constituentTypes);
    }

    @Override
    public boolean isNilable() {
        return TypeFlags.isFlagOn(this.typeFlags, 1);
    }

    @Override
    public boolean isAnydata() {
        return TypeFlags.isFlagOn(this.typeFlags, 2);
    }

    @Override
    public boolean isPureType() {
        return TypeFlags.isFlagOn(this.typeFlags, 4);
    }

    public int getTypeFlags() {
        return this.typeFlags;
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public IntersectionType getImmutableType() {
        return this.immutableType;
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
        this.immutableType = immutableType;
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        if (this.basicType == null) {
            this.basicType = this.constituentTypes.stream().map(Type::getBasicType).reduce(BasicTypeBitSet::intersection).orElseThrow();
        }
        return this.basicType;
    }

    @Override
    public Type getEffectiveType() {
        return this.effectiveType;
    }

    @Override
    public Optional<IntersectionType> getIntersectionType() {
        return this.intersectionType == null ? Optional.empty() : Optional.of(this.intersectionType);
    }

    @Override
    public void setIntersectionType(IntersectionType intersectionType) {
        this.intersectionType = intersectionType;
    }

    @Override
    public SemType createSemType(Context cx) {
        return this.createSemTypeInner(cx, type -> SemType.tryInto(cx, type));
    }

    @Override
    protected boolean isDependentlyTypedInner(Set<MayBeDependentType> visited) {
        return this.constituentTypes.stream().filter(each -> each instanceof MayBeDependentType).anyMatch(type -> ((MayBeDependentType)((Object)type)).isDependentlyTyped(visited));
    }

    private SemType createSemTypeInner(Context cx, Function<Type, SemType> semTypeFunction) {
        if (this.constituentTypes.isEmpty()) {
            return Builder.getNeverType();
        }
        SemType result = this.constituentTypes.stream().map(semTypeFunction).reduce(Core::intersect).orElseThrow();
        Optional<SemType> distinctPart = this.distinctTypePart(cx, result);
        if (distinctPart.isPresent()) {
            result = Core.intersect(result, distinctPart.get());
        }
        return result;
    }

    private Optional<SemType> distinctTypePart(Context cx, SemType result) {
        if (Core.isSubtypeSimple(result, Builder.getErrorType())) {
            BErrorType effectiveErrorType = (BErrorType)TypeUtils.getImpliedType(this.effectiveType);
            DistinctIdSupplier distinctIdSupplier = new DistinctIdSupplier(cx.env, effectiveErrorType.getTypeIdSet());
            return distinctIdSupplier.get().stream().map(ErrorUtils::errorDistinct).reduce(Core::intersect);
        }
        if (Core.isSubtypeSimple(result, Builder.getObjectType())) {
            BObjectType effectiveObjectType = (BObjectType)TypeUtils.getImpliedType(this.effectiveType);
            DistinctIdSupplier distinctIdSupplier = new DistinctIdSupplier(cx.env, effectiveObjectType.getTypeIdSet());
            return distinctIdSupplier.get().stream().map(ObjectDefinition::distinct).reduce(Core::intersect);
        }
        return Optional.empty();
    }

    @Override
    public Optional<SemType> shapeOf(Context cx, ShapeSupplier shapeSupplierFn, Object object) {
        Type effectiveType = this.getEffectiveType();
        if (effectiveType instanceof TypeWithShape) {
            TypeWithShape typeWithShape = (TypeWithShape)((Object)effectiveType);
            return typeWithShape.shapeOf(cx, shapeSupplierFn, object);
        }
        return Optional.empty();
    }

    @Override
    public SemType acceptedTypeOf(Context cx) {
        return this.createSemTypeInner(cx, type -> ShapeAnalyzer.acceptedTypeOf(cx, type));
    }

    @Override
    public Optional<SemType> inherentTypeOf(Context cx, ShapeSupplier shapeSupplier, Object object) {
        Type effectiveType = this.getEffectiveType();
        if (effectiveType instanceof TypeWithShape) {
            TypeWithShape typeWithShape = (TypeWithShape)((Object)effectiveType);
            return typeWithShape.inherentTypeOf(cx, shapeSupplier, object);
        }
        return Optional.empty();
    }

    @Override
    public boolean couldInherentTypeBeDifferent() {
        return true;
    }
}

