/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.identifier.Utils;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.FunctionType;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.internal.types.BFunctionType;
import io.ballerina.runtime.internal.types.BObjectType;
import java.util.StringJoiner;

public class BMethodType
extends BFunctionType
implements MethodType {
    public String funcName;
    public BObjectType parentObjectType;

    public BMethodType(String funcName, Module pkg, BObjectType parent, BFunctionType type, long flags) {
        super(pkg, type.getParameters(), type.getRestType(), type.getReturnType(), flags, type.getName());
        this.funcName = funcName;
        this.parentObjectType = parent;
    }

    @Override
    public String toString() {
        StringJoiner sj = new StringJoiner(",", "function " + this.funcName + "(", ") returns (" + String.valueOf(this.retType) + ")");
        for (Parameter parameter : this.parameters) {
            sj.add(parameter.type.getName());
        }
        return sj.toString();
    }

    @Override
    public String getName() {
        return this.funcName;
    }

    @Override
    public String getAnnotationKey() {
        return Utils.decodeIdentifier(this.parentObjectType.getAnnotationKey()) + "." + Utils.decodeIdentifier(this.funcName);
    }

    @Override
    public ObjectType getParentObjectType() {
        return this.parentObjectType;
    }

    @Override
    public FunctionType getType() {
        return this;
    }

    public <T extends MethodType> MethodType duplicate() {
        return new BMethodType(this.funcName, this.pkg, this.parentObjectType, this, this.flags);
    }

    @Override
    public boolean isIsolated() {
        return SymbolFlags.isFlagOn(this.flags, 0x20000000L);
    }

    public String name() {
        return this.funcName;
    }
}

