/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import com.github.benmanes.caffeine.cache.LoadingCache;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.CacheableTypeDescriptor;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.TypeCheckCache;
import io.ballerina.runtime.api.types.semtype.TypeCheckCacheFactory;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.types.MayBeDependentType;
import io.ballerina.runtime.internal.types.TypeIdSupplier;
import io.ballerina.runtime.internal.types.semtype.CacheFactory;
import io.ballerina.runtime.internal.types.semtype.DefinitionContainer;
import io.ballerina.runtime.internal.types.semtype.StreamDefinition;
import io.ballerina.runtime.internal.values.StreamValue;
import java.util.Objects;
import java.util.Set;

public class BStreamType
extends BType
implements StreamType {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getStreamType();
    private final Type constraint;
    private final Type completionType;
    private final DefinitionContainer<StreamDefinition> definition = new DefinitionContainer();

    public BStreamType(String typeName, Type constraint, Type completionType, Module pkgPath) {
        super(typeName, pkgPath, StreamValue.class, false);
        this.constraint = constraint;
        this.completionType = completionType;
        BStreamTypeCache.Value val2 = BStreamTypeCache.get(constraint, completionType);
        this.typeCheckCache = val2.cache;
        this.typeId = val2.typeId;
    }

    public BStreamType(Type constraint, Type completionType) {
        this("stream", constraint, completionType, null);
    }

    @Deprecated
    public BStreamType(String typeName, Type constraint, Module pkgPath) {
        this(typeName, constraint, PredefinedTypes.TYPE_NULL, pkgPath);
    }

    @Deprecated
    public BStreamType(Type constraint) {
        this("stream", constraint, null);
    }

    @Override
    public Type getConstrainedType() {
        return this.constraint;
    }

    @Override
    public Type getCompletionType() {
        return this.completionType;
    }

    @Override
    public <V> V getZeroValue() {
        return (V)new StreamValue(this);
    }

    @Override
    public <V> V getEmptyValue() {
        return null;
    }

    @Override
    public int getTag() {
        return 26;
    }

    @Override
    public String toString() {
        return super.toString() + "<" + this.constraint.toString() + (String)(this.completionType != null && this.completionType.getTag() != 14 ? "," + this.completionType.toString() : "") + ">";
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof BStreamType)) {
            return false;
        }
        BStreamType other = (BStreamType)obj;
        if (this.constraint == other.constraint && this.completionType == other.completionType) {
            return true;
        }
        if (this.constraint == null || other.constraint == null) {
            return false;
        }
        return Objects.equals(this.constraint, other.constraint) && Objects.equals(this.completionType, other.completionType);
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    @Override
    public SemType createSemType(Context cx) {
        if (this.constraint == null) {
            return Builder.getStreamType();
        }
        Env env = cx.env;
        if (this.definition.isDefinitionReady()) {
            return this.definition.getSemType(env);
        }
        DefinitionContainer.DefinitionUpdateResult<StreamDefinition> result = this.definition.trySetDefinition(StreamDefinition::new);
        if (!result.updated()) {
            return this.definition.getSemType(env);
        }
        StreamDefinition sd = result.definition();
        return sd.define(env, BStreamType.tryInto(cx, this.constraint), BStreamType.tryInto(cx, this.completionType));
    }

    @Override
    protected boolean isDependentlyTypedInner(Set<MayBeDependentType> visited) {
        MayBeDependentType completionType;
        MayBeDependentType constrainedType;
        Type type = this.constraint;
        return type instanceof MayBeDependentType && (constrainedType = (MayBeDependentType)((Object)type)).isDependentlyTyped(visited) || (type = this.completionType) instanceof MayBeDependentType && (completionType = (MayBeDependentType)((Object)type)).isDependentlyTyped(visited);
    }

    private static final class BStreamTypeCache {
        private static final LoadingCache<Key, Value> CACHE = CacheFactory.createCache(BStreamTypeCache::createNewValue);

        private BStreamTypeCache() {
        }

        public static Value get(Type constraint, Type completion) {
            return CACHE.get(new Key(((CacheableTypeDescriptor)constraint).typeId(), ((CacheableTypeDescriptor)completion).typeId()));
        }

        private static Value createNewValue(Key key) {
            return new Value(TypeIdSupplier.getAnonId(), TypeCheckCacheFactory.create());
        }

        record Key(int constrainId, int completionId) {
        }

        record Value(int typeId, TypeCheckCache cache) {
        }
    }
}

