/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SubType;
import io.ballerina.runtime.internal.types.semtype.AllOrNothing;
import io.ballerina.runtime.internal.types.semtype.EnumerableSubtypeData;
import io.ballerina.runtime.internal.types.semtype.SubTypeData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;

public final class BDecimalSubType
extends SubType {
    final SubTypeData data;
    private static final BDecimalSubType ALL = new BDecimalSubType(AllOrNothing.ALL);
    private static final BDecimalSubType NOTHING = new BDecimalSubType(AllOrNothing.NOTHING);

    private BDecimalSubType(SubTypeData data2) {
        super(data2 == AllOrNothing.ALL, data2 == AllOrNothing.NOTHING);
        this.data = data2;
    }

    public static BDecimalSubType createDecimalSubType(boolean allowed, BigDecimal[] values) {
        if (values.length == 0) {
            if (!allowed) {
                return ALL;
            }
            return NOTHING;
        }
        Arrays.sort(values);
        return new BDecimalSubType(new DecimalSubTypeData(allowed, values));
    }

    @Override
    public SubType union(SubType otherSubtype) {
        BDecimalSubType other = (BDecimalSubType)otherSubtype;
        if (this.data instanceof AllOrNothing) {
            if (this.data == AllOrNothing.ALL) {
                return this;
            }
            return other;
        }
        if (other.data instanceof AllOrNothing) {
            if (other.data == AllOrNothing.ALL) {
                return other;
            }
            return this;
        }
        ArrayList values = new ArrayList();
        DecimalSubTypeData data2 = (DecimalSubTypeData)this.data;
        DecimalSubTypeData otherData = (DecimalSubTypeData)other.data;
        boolean allowed = data2.union(otherData, values);
        return BDecimalSubType.createDecimalSubType(allowed, (BigDecimal[])values.toArray(BigDecimal[]::new));
    }

    @Override
    public SubType intersect(SubType otherSubtype) {
        BDecimalSubType other = (BDecimalSubType)otherSubtype;
        if (this.data instanceof AllOrNothing) {
            if (this.data == AllOrNothing.ALL) {
                return other;
            }
            return NOTHING;
        }
        if (other.data instanceof AllOrNothing) {
            if (other.data == AllOrNothing.ALL) {
                return this;
            }
            return NOTHING;
        }
        ArrayList values = new ArrayList();
        DecimalSubTypeData data2 = (DecimalSubTypeData)this.data;
        DecimalSubTypeData otherData = (DecimalSubTypeData)other.data;
        boolean allowed = data2.intersect(otherData, values);
        return BDecimalSubType.createDecimalSubType(allowed, (BigDecimal[])values.toArray(BigDecimal[]::new));
    }

    @Override
    public SubType complement() {
        if (this.data == AllOrNothing.ALL) {
            return NOTHING;
        }
        if (this.data == AllOrNothing.NOTHING) {
            return ALL;
        }
        DecimalSubTypeData data2 = (DecimalSubTypeData)this.data;
        return BDecimalSubType.createDecimalSubType(!data2.allowed, data2.values);
    }

    @Override
    public boolean isEmpty(Context cx) {
        return this.data == AllOrNothing.NOTHING;
    }

    @Override
    public SubTypeData data() {
        return this.data;
    }

    public BigDecimal defaultValue() {
        SubTypeData subTypeData = this.data;
        if (subTypeData instanceof DecimalSubTypeData) {
            DecimalSubTypeData subTypeData2 = (DecimalSubTypeData)subTypeData;
            if (subTypeData2.allowed && subTypeData2.values.length == 1) {
                return subTypeData2.values[0];
            }
        }
        return null;
    }

    public String toString() {
        SubTypeData subTypeData = this.data;
        if (subTypeData instanceof DecimalSubTypeData) {
            DecimalSubTypeData subTypeData2 = (DecimalSubTypeData)subTypeData;
            if (subTypeData2.allowed) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < subTypeData2.values.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(subTypeData2.values[i]);
                }
                return sb.toString();
            }
        }
        return "decimal";
    }

    private static final class DecimalSubTypeData
    extends EnumerableSubtypeData<BigDecimal>
    implements SubTypeData {
        private final boolean allowed;
        private final BigDecimal[] values;

        private DecimalSubTypeData(boolean allowed, BigDecimal[] values) {
            this.allowed = allowed;
            this.values = values;
        }

        @Override
        public boolean allowed() {
            return this.allowed;
        }

        public BigDecimal[] values() {
            return this.values;
        }
    }
}

