/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SubType;
import io.ballerina.runtime.internal.types.semtype.AllOrNothing;
import io.ballerina.runtime.internal.types.semtype.EnumerableSubtypeData;
import io.ballerina.runtime.internal.types.semtype.SubTypeData;
import java.util.ArrayList;
import java.util.Arrays;

public final class BFloatSubType
extends SubType {
    final SubTypeData data;
    private static final BFloatSubType ALL = new BFloatSubType(AllOrNothing.ALL);
    private static final BFloatSubType NOTHING = new BFloatSubType(AllOrNothing.NOTHING);

    private BFloatSubType(SubTypeData data2) {
        super(data2 == AllOrNothing.ALL, data2 == AllOrNothing.NOTHING);
        this.data = data2;
    }

    public static BFloatSubType createFloatSubType(boolean allowed, Double[] values) {
        if (values.length == 0) {
            if (!allowed) {
                return ALL;
            }
            return NOTHING;
        }
        return new BFloatSubType(new FloatSubTypeData(allowed, values));
    }

    @Override
    public SubType union(SubType otherSubtype) {
        BFloatSubType other = (BFloatSubType)otherSubtype;
        if (this.data instanceof AllOrNothing) {
            if (this.data == AllOrNothing.ALL) {
                return this;
            }
            return other;
        }
        if (other.data instanceof AllOrNothing) {
            if (other.data == AllOrNothing.ALL) {
                return other;
            }
            return this;
        }
        ArrayList values = new ArrayList();
        FloatSubTypeData data2 = (FloatSubTypeData)this.data;
        FloatSubTypeData otherData = (FloatSubTypeData)other.data;
        boolean allowed = data2.union(otherData, values);
        return BFloatSubType.createFloatSubType(allowed, (Double[])values.toArray(Double[]::new));
    }

    @Override
    public SubType intersect(SubType otherSubtype) {
        BFloatSubType other = (BFloatSubType)otherSubtype;
        if (this.data instanceof AllOrNothing) {
            if (this.data == AllOrNothing.ALL) {
                return other;
            }
            return NOTHING;
        }
        if (other.data instanceof AllOrNothing) {
            if (other.data == AllOrNothing.ALL) {
                return this;
            }
            return NOTHING;
        }
        ArrayList values = new ArrayList();
        FloatSubTypeData data2 = (FloatSubTypeData)this.data;
        FloatSubTypeData otherData = (FloatSubTypeData)other.data;
        boolean allowed = data2.intersect(otherData, values);
        return BFloatSubType.createFloatSubType(allowed, (Double[])values.toArray(Double[]::new));
    }

    @Override
    public SubType complement() {
        if (this.data == AllOrNothing.ALL) {
            return NOTHING;
        }
        if (this.data == AllOrNothing.NOTHING) {
            return ALL;
        }
        FloatSubTypeData data2 = (FloatSubTypeData)this.data;
        return BFloatSubType.createFloatSubType(!data2.allowed, data2.values);
    }

    @Override
    public boolean isEmpty(Context cx) {
        return this.data == AllOrNothing.NOTHING;
    }

    @Override
    public SubTypeData data() {
        return this.data;
    }

    static final class FloatSubTypeData
    extends EnumerableSubtypeData<Double>
    implements SubTypeData {
        private final boolean allowed;
        private final Double[] values;

        private FloatSubTypeData(boolean allowed, Double[] values) {
            this.allowed = allowed;
            this.values = FloatSubTypeData.filteredValues(values);
        }

        private static Double[] filteredValues(Double[] values) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = FloatSubTypeData.canon(values[i]);
            }
            if (values.length < 2) {
                return values;
            }
            Arrays.sort((Object[])values);
            Double[] buffer = new Double[values.length];
            buffer[0] = values[0];
            int bufferLen = 1;
            for (int i = 1; i < values.length; ++i) {
                Double value2 = values[i];
                Double prevValue = values[i - 1];
                if (FloatSubTypeData.isSame(value2, prevValue)) continue;
                buffer[bufferLen++] = value2;
            }
            return Arrays.copyOf(buffer, bufferLen);
        }

        private static Double canon(Double d) {
            if (d.equals(0.0) || d.equals(-0.0)) {
                return 0.0;
            }
            return d;
        }

        private static boolean isSame(double f1, double f2) {
            if (Double.isNaN(f1)) {
                return Double.isNaN(f2);
            }
            return f1 == f2;
        }

        @Override
        public boolean allowed() {
            return this.allowed;
        }

        public Double[] values() {
            return this.values;
        }
    }
}

