/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.Bdd;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Conjunction;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.SubType;
import io.ballerina.runtime.internal.types.semtype.BMappingSubType;
import io.ballerina.runtime.internal.types.semtype.DelegatedSubType;
import io.ballerina.runtime.internal.types.semtype.FunctionAtomicType;
import io.ballerina.runtime.internal.types.semtype.SubTypeData;
import java.util.Objects;

public class BFunctionSubType
extends SubType
implements DelegatedSubType {
    public final Bdd inner;

    private BFunctionSubType(Bdd inner) {
        super(inner.isAll(), inner.isNothing());
        this.inner = inner;
    }

    public static BFunctionSubType createDelegate(SubType inner) {
        if (inner instanceof Bdd) {
            Bdd bdd = (Bdd)inner;
            return new BFunctionSubType(bdd);
        }
        if (inner.isAll() || inner.isNothing()) {
            throw new IllegalStateException("unimplemented");
        }
        if (inner instanceof BFunctionSubType) {
            BFunctionSubType bFunction = (BFunctionSubType)inner;
            return new BFunctionSubType(bFunction.inner);
        }
        throw new IllegalArgumentException("Unexpected inner type");
    }

    @Override
    public SubType union(SubType other) {
        if (!(other instanceof BFunctionSubType)) {
            throw new IllegalArgumentException("union of different subtypes");
        }
        BFunctionSubType otherFn = (BFunctionSubType)other;
        return BFunctionSubType.createDelegate(this.inner.union(otherFn.inner));
    }

    @Override
    public SubType intersect(SubType other) {
        if (!(other instanceof BFunctionSubType)) {
            throw new IllegalArgumentException("intersect of different subtypes");
        }
        BFunctionSubType otherList = (BFunctionSubType)other;
        return BFunctionSubType.createDelegate(this.inner.intersect(otherList.inner));
    }

    @Override
    public SubType complement() {
        return BFunctionSubType.createDelegate(this.inner.complement());
    }

    @Override
    public boolean isEmpty(Context cx) {
        return cx.memoSubtypeIsEmpty(cx.functionMemo, (context, bdd) -> Bdd.bddEvery(context, bdd, BFunctionSubType::functionFormulaIsEmpty), this.inner);
    }

    private static boolean functionFormulaIsEmpty(Context cx, Conjunction pos, Conjunction neg) {
        return BFunctionSubType.functionPathIsEmpty(cx, BFunctionSubType.functionUnionParams(cx, pos), BFunctionSubType.functionUnionQualifiers(cx, pos), pos, neg);
    }

    private static boolean functionPathIsEmpty(Context cx, SemType params, SemType qualifier, Conjunction pos, Conjunction neg) {
        if (neg == null) {
            return false;
        }
        FunctionAtomicType t = cx.functionAtomicType(neg.atom());
        SemType t02 = t.paramType();
        SemType t110 = t.retType();
        SemType t22 = t.qualifiers();
        return Core.isSubType(cx, qualifier, t22) && Core.isSubType(cx, t02, params) && BFunctionSubType.functionPhi(cx, t02, Core.complement(t110), pos) || BFunctionSubType.functionPathIsEmpty(cx, params, qualifier, pos, neg.next());
    }

    private static boolean functionPhi(Context cx, SemType t02, SemType t110, Conjunction pos) {
        if (pos == null) {
            return !Core.isNever(t02) && (Core.isEmpty(cx, t02) || Core.isEmpty(cx, t110));
        }
        return BFunctionSubType.functionPhiInner(cx, t02, t110, pos);
    }

    private static boolean functionPhiInner(Context cx, SemType t02, SemType t110, Conjunction pos) {
        if (pos == null) {
            return Core.isEmpty(cx, t02) || Core.isEmpty(cx, t110);
        }
        FunctionAtomicType s = cx.functionAtomicType(pos.atom());
        SemType s02 = s.paramType();
        SemType s110 = s.retType();
        return (Core.isSubType(cx, t02, s02) || Core.isSubType(cx, BFunctionSubType.functionIntersectRet(cx, pos.next()), Core.complement(t110))) && BFunctionSubType.functionPhiInner(cx, t02, Core.intersect(t110, s110), pos.next()) && BFunctionSubType.functionPhiInner(cx, Core.diff(t02, s02), t110, pos.next());
    }

    private static SemType functionIntersectRet(Context cx, Conjunction pos) {
        if (pos == null) {
            return Builder.getValType();
        }
        return Core.intersect(cx.functionAtomicType(pos.atom()).retType(), BFunctionSubType.functionIntersectRet(cx, pos.next()));
    }

    private static SemType functionUnionParams(Context cx, Conjunction pos) {
        if (pos == null) {
            return Builder.getNeverType();
        }
        return Core.union(cx.functionAtomicType(pos.atom()).paramType(), BFunctionSubType.functionUnionParams(cx, pos.next()));
    }

    private static SemType functionUnionQualifiers(Context cx, Conjunction pos) {
        if (pos == null) {
            return Builder.getNeverType();
        }
        return Core.union(cx.functionAtomicType(pos.atom()).qualifiers(), BFunctionSubType.functionUnionQualifiers(cx, pos.next()));
    }

    @Override
    public SubTypeData data() {
        throw new IllegalStateException("unimplemented");
    }

    @Override
    public Bdd inner() {
        return this.inner;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BMappingSubType)) {
            return false;
        }
        BMappingSubType that = (BMappingSubType)o;
        return Objects.equals(this.inner, that.inner);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.inner);
    }
}

