/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.Bdd;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Conjunction;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.FieldPair;
import io.ballerina.runtime.api.types.semtype.FieldPairs;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.SubType;
import io.ballerina.runtime.internal.types.semtype.Common;
import io.ballerina.runtime.internal.types.semtype.DelegatedSubType;
import io.ballerina.runtime.internal.types.semtype.MappingAtomicType;
import io.ballerina.runtime.internal.types.semtype.SubTypeData;
import java.util.Arrays;
import java.util.Objects;

public class BMappingSubType
extends SubType
implements DelegatedSubType {
    public final Bdd inner;

    private BMappingSubType(Bdd inner) {
        super(inner.isAll(), inner.isNothing());
        this.inner = inner;
    }

    public static BMappingSubType createDelegate(SubType inner) {
        if (inner instanceof Bdd) {
            Bdd bdd = (Bdd)inner;
            return new BMappingSubType(bdd);
        }
        if (inner.isAll() || inner.isNothing()) {
            throw new IllegalStateException("unimplemented");
        }
        if (inner instanceof BMappingSubType) {
            BMappingSubType bMapping = (BMappingSubType)inner;
            return new BMappingSubType(bMapping.inner);
        }
        throw new IllegalArgumentException("Unexpected inner type");
    }

    @Override
    public Bdd inner() {
        return this.inner;
    }

    @Override
    public SubType union(SubType other) {
        if (!(other instanceof BMappingSubType)) {
            throw new IllegalArgumentException("union of different subtypes");
        }
        BMappingSubType otherMapping = (BMappingSubType)other;
        return BMappingSubType.createDelegate(this.inner.union(otherMapping.inner));
    }

    @Override
    public SubType intersect(SubType other) {
        if (!(other instanceof BMappingSubType)) {
            throw new IllegalArgumentException("intersect of different subtypes");
        }
        BMappingSubType otherMapping = (BMappingSubType)other;
        return BMappingSubType.createDelegate(this.inner.intersect(otherMapping.inner));
    }

    @Override
    public SubType complement() {
        return BMappingSubType.createDelegate(this.inner.complement());
    }

    @Override
    public boolean isEmpty(Context cx) {
        return cx.memoSubtypeIsEmpty(cx.mappingMemo, (context, bdd) -> Bdd.bddEvery(context, bdd, BMappingSubType::mappingFormulaIsEmpty), this.inner);
    }

    static boolean mappingFormulaIsEmpty(Context cx, Conjunction posList, Conjunction negList) {
        MappingAtomicType combined;
        if (posList == null) {
            combined = Builder.getMappingAtomicInner();
        } else {
            combined = cx.mappingAtomType(posList.atom());
            for (Conjunction p = posList.next(); p != null; p = p.next()) {
                MappingAtomicType m = combined.intersectMapping(cx.env, cx.mappingAtomType(p.atom()));
                if (m == null) {
                    return true;
                }
                combined = m;
            }
            for (SemType t : combined.types()) {
                if (!Core.isEmpty(cx, t)) continue;
                return true;
            }
        }
        if (!BMappingSubType.mappingInhabitedFast(cx, combined, negList)) {
            assert (!BMappingSubType.mappingInhabited(cx, combined, negList));
            return true;
        }
        return !BMappingSubType.mappingInhabited(cx, combined, negList);
    }

    private static boolean mappingInhabitedFast(Context cx, MappingAtomicType pos, Conjunction negList) {
        if (negList == null) {
            return true;
        }
        MappingAtomicType neg = cx.mappingAtomType(negList.atom());
        if (!Core.isEmpty(cx, Core.diff(pos.rest(), neg.rest()))) {
            return BMappingSubType.mappingInhabitedFast(cx, pos, negList.next());
        }
        for (FieldPair fieldPair : new FieldPairs(pos, neg)) {
            SemType intersect = Core.intersect(fieldPair.type1(), fieldPair.type2());
            if (Core.isEmpty(cx, intersect)) {
                return BMappingSubType.mappingInhabitedFast(cx, pos, negList.next());
            }
            SemType d = Core.diff(fieldPair.type1(), fieldPair.type2());
            if (Core.isEmpty(cx, d)) continue;
            return BMappingSubType.mappingInhabitedFast(cx, pos, negList.next());
        }
        return false;
    }

    private static boolean mappingInhabited(Context cx, MappingAtomicType pos, Conjunction negList) {
        if (negList == null) {
            return true;
        }
        MappingAtomicType neg = cx.mappingAtomType(negList.atom());
        if (!Core.isEmpty(cx, Core.diff(pos.rest(), neg.rest()))) {
            return BMappingSubType.mappingInhabited(cx, pos, negList.next());
        }
        for (FieldPair fieldPair : new FieldPairs(pos, neg)) {
            MappingAtomicType mt;
            SemType intersect = Core.intersect(fieldPair.type1(), fieldPair.type2());
            if (Core.isEmpty(cx, intersect)) {
                return BMappingSubType.mappingInhabited(cx, pos, negList.next());
            }
            SemType d = Core.diff(fieldPair.type1(), fieldPair.type2());
            if (Core.isEmpty(cx, d)) continue;
            if (fieldPair.index1() == null) {
                mt = BMappingSubType.insertField(pos, fieldPair.name(), d);
            } else {
                SemType[] posTypes = (SemType[])pos.types().clone();
                posTypes[fieldPair.index1().intValue()] = d;
                mt = new MappingAtomicType(pos.names(), posTypes, pos.rest());
            }
            if (!BMappingSubType.mappingInhabited(cx, mt, negList.next())) continue;
            return true;
        }
        return false;
    }

    private static MappingAtomicType insertField(MappingAtomicType m, String name, SemType t) {
        String[] orgNames = m.names();
        String[] names = BMappingSubType.shallowCopyStrings(orgNames, orgNames.length + 1);
        SemType[] orgTypes = m.types();
        SemType[] types2 = BMappingSubType.shallowCopySemTypes(orgTypes, orgTypes.length + 1);
        int i = orgNames.length;
        while (true) {
            if (i == 0 || Common.codePointCompare(names[i - 1], name)) break;
            names[i] = names[i - 1];
            types2[i] = types2[i - 1];
            --i;
        }
        names[i] = name;
        types2[i] = t;
        return new MappingAtomicType(names, types2, m.rest());
    }

    static SemType[] shallowCopySemTypes(SemType[] v, int newLength) {
        return Arrays.copyOf(v, newLength);
    }

    private static String[] shallowCopyStrings(String[] v, int newLength) {
        return Arrays.copyOf(v, newLength);
    }

    @Override
    public SubTypeData data() {
        return this.inner();
    }

    @Override
    public SubType diff(SubType other) {
        if (!(other instanceof BMappingSubType)) {
            throw new IllegalArgumentException("diff of different subtypes");
        }
        BMappingSubType otherList = (BMappingSubType)other;
        return BMappingSubType.createDelegate(this.inner.diff(otherList.inner));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BMappingSubType)) {
            return false;
        }
        BMappingSubType that = (BMappingSubType)o;
        return Objects.equals(this.inner, that.inner);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.inner);
    }
}

