/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SubType;
import io.ballerina.runtime.internal.types.semtype.AllOrNothing;
import io.ballerina.runtime.internal.types.semtype.Common;
import io.ballerina.runtime.internal.types.semtype.EnumerableSubtypeData;
import io.ballerina.runtime.internal.types.semtype.SubTypeData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class BStringSubType
extends SubType {
    final SubTypeData data;
    private static final BStringSubType ALL = new BStringSubType(AllOrNothing.ALL);
    private static final BStringSubType NOTHING = new BStringSubType(AllOrNothing.NOTHING);

    private BStringSubType(SubTypeData data2) {
        super(data2 == AllOrNothing.ALL, data2 == AllOrNothing.NOTHING);
        this.data = data2;
    }

    public static BStringSubType createStringSubType(boolean charsAllowed, String[] chars, boolean nonCharsAllowed, String[] nonChars) {
        if (chars.length == 0 && nonChars.length == 0) {
            if (!charsAllowed && !nonCharsAllowed) {
                return ALL;
            }
            if (charsAllowed && nonCharsAllowed) {
                return NOTHING;
            }
        }
        Arrays.sort(chars);
        Arrays.sort(nonChars);
        ValueData charValues = new ValueData(charsAllowed, chars);
        ValueData nonCharValues = new ValueData(nonCharsAllowed, nonChars);
        StringSubTypeData data2 = new StringSubTypeData(charValues, nonCharValues);
        return new BStringSubType(data2);
    }

    public String toString() {
        SubTypeData subTypeData = this.data;
        if (subTypeData instanceof StringSubTypeData) {
            StringSubTypeData stringSubTypeData = (StringSubTypeData)subTypeData;
            ValueData chars = stringSubTypeData.chars;
            ValueData nonChars = stringSubTypeData.nonChars;
            if (chars.allowed && chars.values.length > 0 && nonChars.allowed && nonChars.values.length == 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < chars.values.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(chars.values[i]);
                }
                return sb.toString();
            }
            if (nonChars.allowed && nonChars.values.length > 0 && chars.allowed && chars.values.length == 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < nonChars.values.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(nonChars.values[i]);
                }
                return sb.toString();
            }
        }
        return "string";
    }

    @Override
    public SubType union(SubType otherSubType) {
        BStringSubType other = (BStringSubType)otherSubType;
        if (this.data instanceof AllOrNothing || other.data instanceof AllOrNothing) {
            if (this.data == AllOrNothing.ALL) {
                return this;
            }
            if (other.data == AllOrNothing.ALL) {
                return other;
            }
            if (this.data == AllOrNothing.NOTHING) {
                return other;
            }
            if (other.data == AllOrNothing.NOTHING) {
                return this;
            }
            throw new IllegalStateException("unreachable");
        }
        StringSubTypeData data2 = (StringSubTypeData)this.data;
        StringSubTypeData otherData = (StringSubTypeData)other.data;
        ArrayList chars = new ArrayList();
        boolean charsAllowed = data2.chars.union(otherData.chars, chars);
        ArrayList nonChars = new ArrayList();
        boolean nonCharsAllowed = data2.nonChars.union(otherData.nonChars, nonChars);
        return BStringSubType.createStringSubType(charsAllowed, (String[])chars.toArray(String[]::new), nonCharsAllowed, (String[])nonChars.toArray(String[]::new));
    }

    @Override
    public SubType intersect(SubType otherSubtype) {
        BStringSubType other = (BStringSubType)otherSubtype;
        if (this.data instanceof AllOrNothing) {
            if (this.data == AllOrNothing.ALL) {
                return other;
            }
            return NOTHING;
        }
        if (other.data instanceof AllOrNothing) {
            if (other.data == AllOrNothing.ALL) {
                return this;
            }
            return NOTHING;
        }
        StringSubTypeData data2 = (StringSubTypeData)this.data;
        StringSubTypeData otherData = (StringSubTypeData)other.data;
        ArrayList chars = new ArrayList();
        boolean charsAllowed = data2.chars.intersect(otherData.chars, chars);
        ArrayList nonChars = new ArrayList();
        boolean nonCharsAllowed = data2.nonChars.intersect(otherData.nonChars, nonChars);
        return BStringSubType.createStringSubType(charsAllowed, (String[])chars.toArray(String[]::new), nonCharsAllowed, (String[])nonChars.toArray(String[]::new));
    }

    @Override
    public SubType complement() {
        if (this.data instanceof AllOrNothing) {
            if (this.data == AllOrNothing.ALL) {
                return NOTHING;
            }
            return ALL;
        }
        StringSubTypeData stringData = (StringSubTypeData)this.data;
        ValueData chars = stringData.chars;
        ValueData nonChars = stringData.nonChars;
        return BStringSubType.createStringSubType(!chars.allowed, chars.values, !nonChars.allowed, nonChars.values);
    }

    @Override
    public boolean isEmpty(Context cx) {
        return this.data == AllOrNothing.NOTHING;
    }

    @Override
    public SubTypeData data() {
        return this.data;
    }

    static void stringListIntersect(String[] values, String[] target, List<Integer> indices) {
        int i1 = 0;
        int i2 = 0;
        int len1 = values.length;
        int len2 = target.length;
        block5: while (i1 < len1 && i2 < len2) {
            switch (BStringSubType.compareStrings(values[i1], target[i2]).ordinal()) {
                case 0: {
                    indices.add(i1);
                    ++i1;
                    ++i2;
                    continue block5;
                }
                case 1: {
                    ++i1;
                    continue block5;
                }
                case 2: {
                    ++i2;
                    continue block5;
                }
            }
            throw new AssertionError((Object)"Invalid comparison value!");
        }
    }

    private static ComparisonResult compareStrings(String s110, String s210) {
        return Objects.equals(s110, s210) ? ComparisonResult.EQ : (Common.codePointCompare(s110, s210) ? ComparisonResult.LT : ComparisonResult.GT);
    }

    static final class ValueData
    extends EnumerableSubtypeData<String> {
        private final boolean allowed;
        private final String[] values;

        private ValueData(boolean allowed, String[] values) {
            this.allowed = allowed;
            this.values = values;
        }

        @Override
        public boolean allowed() {
            return this.allowed;
        }

        public String[] values() {
            return this.values;
        }
    }

    record StringSubTypeData(ValueData chars, ValueData nonChars) implements SubTypeData
    {
        StringSubtypeListCoverage stringSubtypeListCoverage(String[] values) {
            int i2;
            ArrayList<Integer> indices = new ArrayList<Integer>();
            ValueData ch = this.chars();
            ValueData nonChar = this.nonChars();
            int stringConsts = 0;
            if (ch.allowed) {
                BStringSubType.stringListIntersect(values, ch.values, indices);
                stringConsts = ch.values.length;
            } else if (ch.values.length == 0) {
                for (i2 = 0; i2 < values.length; ++i2) {
                    if (values[i2].length() != 1) continue;
                    indices.add(i2);
                }
            }
            if (nonChar.allowed) {
                BStringSubType.stringListIntersect(values, nonChar.values, indices);
                stringConsts += nonChar.values.length;
            } else if (nonChar.values.length == 0) {
                for (i2 = 0; i2 < values.length; ++i2) {
                    if (values[i2].length() == 1) continue;
                    indices.add(i2);
                }
            }
            int[] inds = indices.stream().mapToInt(i -> i).toArray();
            return new StringSubtypeListCoverage(stringConsts == indices.size(), inds);
        }
    }

    private static enum ComparisonResult {
        EQ,
        LT,
        GT;

    }

    record StringSubtypeListCoverage(boolean isSubType, int[] indices) {
    }
}

