/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import com.github.benmanes.caffeine.cache.LoadingCache;
import io.ballerina.runtime.api.types.semtype.Definition;
import io.ballerina.runtime.internal.types.TypeIdSupplier;
import io.ballerina.runtime.internal.types.semtype.CacheFactory;
import io.ballerina.runtime.internal.types.semtype.TypeCheckCacheFlyweight;
import java.util.Map;
import java.util.function.IntFunction;

public class FlyweightLookupTable<E extends Definition> {
    private final IntFunction<TypeCheckCacheFlyweight<E>> createFn;
    private final LoadingCache<Integer, TypeCheckCacheFlyweight<E>> unnamedTypeCache;
    private final Map<Integer, TypeCheckCacheFlyweight<E>> namedTypeCache = CacheFactory.createCachingHashMap();
    private final TypeCheckCacheFlyweight[] reservedLAT;

    public FlyweightLookupTable(IntFunction<TypeCheckCacheFlyweight<E>> createFn) {
        this.createFn = createFn;
        this.unnamedTypeCache = CacheFactory.createCache(createFn::apply);
        this.reservedLAT = new TypeCheckCacheFlyweight[128];
    }

    public TypeCheckCacheFlyweight<E> get(int typeId) {
        return switch (TypeIdSupplier.kind(typeId)) {
            default -> throw new MatchException(null, null);
            case TypeIdSupplier.IdKind.RESERVED -> this.getReserved(typeId);
            case TypeIdSupplier.IdKind.NAMED -> this.getNamed(typeId);
            case TypeIdSupplier.IdKind.UNNAMED -> this.getUnnamed(typeId);
        };
    }

    private TypeCheckCacheFlyweight<E> getReserved(int typeId) {
        TypeCheckCacheFlyweight<E> o = this.reservedLAT[typeId];
        if (o == null) {
            this.reservedLAT[typeId] = o = this.createFn.apply(typeId);
        }
        return o;
    }

    private TypeCheckCacheFlyweight<E> getUnnamed(int typeId) {
        return this.unnamedTypeCache.get(typeId);
    }

    private TypeCheckCacheFlyweight<E> getNamed(int typeId) {
        TypeCheckCacheFlyweight<E> cached = this.namedTypeCache.get(typeId);
        if (cached != null) {
            return cached;
        }
        cached = this.createFn.apply(typeId);
        this.namedTypeCache.put(typeId, cached);
        return cached;
    }
}

