/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.utils;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.TypeConverter;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.types.BTableType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.utils.CycleUtils;
import io.ballerina.runtime.internal.utils.StringUtils;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.TableValueImpl;
import io.ballerina.runtime.internal.xml.XmlFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class BalStringUtils {
    private static boolean hasCycles = false;

    private BalStringUtils() {
    }

    public static Object parseArrayExpressionStringValue(String exprValue, BLink parent) {
        Type type;
        List<String> list = BalStringUtils.getElements(exprValue);
        ArrayValueImpl arr = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_ANYDATA));
        if (list.isEmpty()) {
            return arr;
        }
        CycleUtils.Node node = new CycleUtils.Node(arr, parent);
        HashSet<Type> typeSet = new HashSet<Type>();
        for (int i = 0; i < list.size(); ++i) {
            String e2 = list.get(i);
            Object val2 = StringUtils.parseExpressionStringVal(e2, node);
            Type type2 = TypeChecker.getType(val2);
            typeSet.add(type2);
            arr.add((long)i, val2);
        }
        int size = arr.size();
        if (hasCycles) {
            return arr;
        }
        if (typeSet.size() > 1) {
            type = new BUnionType(new ArrayList<Type>(typeSet));
            Object[] refValues = new Object[size];
            for (int i = 0; i < size; ++i) {
                refValues[i] = arr.get(i);
            }
            return ValueCreator.createArrayValue(refValues, new BArrayType(type));
        }
        type = (Type)typeSet.iterator().next();
        int tag = type.getTag();
        switch (tag) {
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                long[] intValues = new long[size];
                for (int i = 0; i < size; ++i) {
                    intValues[i] = Long.parseLong(arr.get(i).toString());
                }
                return ValueCreator.createArrayValue(intValues);
            }
            case 2: {
                byte[] byteValues = new byte[size];
                for (int i = 0; i < size; ++i) {
                    byteValues[i] = Byte.parseByte(arr.get(i).toString());
                }
                return ValueCreator.createArrayValue(byteValues);
            }
            case 3: {
                double[] floatValues = new double[size];
                for (int i = 0; i < size; ++i) {
                    floatValues[i] = Double.parseDouble(arr.get(i).toString());
                }
                return ValueCreator.createArrayValue(floatValues);
            }
            case 5: 
            case 13: {
                BString[] bStringValues = new BString[size];
                for (int i = 0; i < size; ++i) {
                    bStringValues[i] = io.ballerina.runtime.api.utils.StringUtils.fromString(arr.get(i).toString());
                }
                return ValueCreator.createArrayValue(bStringValues);
            }
            case 6: {
                boolean[] booleanValues = new boolean[size];
                for (int i = 0; i < size; ++i) {
                    booleanValues[i] = Boolean.parseBoolean(arr.get(i).toString());
                }
                return ValueCreator.createArrayValue(booleanValues);
            }
        }
        Object[] refValues = new Object[size];
        for (int i = 0; i < size; ++i) {
            refValues[i] = arr.get(i);
        }
        return ValueCreator.createArrayValue(refValues, new BArrayType(type));
    }

    public static Object parseMapExpressionStringValue(String exprValue, BLink parent) {
        MapValueImpl<BString, Object> result;
        Type type;
        List<String> list = BalStringUtils.getElements(exprValue);
        MapValueImpl<BString, Object> eleMap = new MapValueImpl<BString, Object>(new BMapType(PredefinedTypes.TYPE_ANYDATA));
        if (list.isEmpty()) {
            return eleMap;
        }
        CycleUtils.Node node = new CycleUtils.Node(eleMap, parent);
        HashSet<Type> typeSet = new HashSet<Type>();
        for (String e2 : list) {
            int colonIndex = e2.indexOf(58);
            int quotesCount = 0;
            for (int j = 0; j < e2.length(); ++j) {
                if (e2.charAt(j) == '\"') {
                    ++quotesCount;
                    continue;
                }
                if (e2.charAt(j) != ':' || quotesCount % 2 != 0) continue;
                colonIndex = j;
                break;
            }
            String key = BalStringUtils.getMapKey(e2, colonIndex);
            String value2 = e2.substring(colonIndex + 1);
            Object val2 = StringUtils.parseExpressionStringVal(value2, node);
            eleMap.put(io.ballerina.runtime.api.utils.StringUtils.fromString(key), val2);
            Type type2 = TypeChecker.getType(val2);
            typeSet.add(type2);
        }
        if (hasCycles) {
            return eleMap;
        }
        if (typeSet.size() > 1) {
            type = new BUnionType(new ArrayList<Type>(typeSet));
            result = new MapValueImpl(new BMapType(type));
            result.putAll(eleMap);
            return result;
        }
        type = (Type)typeSet.iterator().next();
        result = new MapValueImpl<BString, Object>(new BMapType(type));
        result.putAll(eleMap);
        return result;
    }

    private static String getMapKey(String e2, int colonIndex) {
        String key = e2.substring(0, colonIndex).trim();
        if (!key.startsWith("\"") || !key.endsWith("\"")) {
            throw ErrorCreator.createError(io.ballerina.runtime.api.utils.StringUtils.fromString("invalid expression style string value: the map keys are not enclosed with '\"'."));
        }
        key = key.substring(1, key.length() - 1);
        return key;
    }

    public static Object parseTableExpressionStringValue(String exprValue, BLink parent) {
        String[] keys2 = exprValue.substring(exprValue.indexOf(40) + 1, exprValue.indexOf(41)).split(",");
        ArrayValue keyFieldNames = keys2[0].isEmpty() ? (ArrayValue)ValueCreator.createArrayValue(new BString[0]) : (ArrayValue)io.ballerina.runtime.api.utils.StringUtils.fromStringArray(keys2);
        ArrayValueImpl data2 = (ArrayValueImpl)StringUtils.parseExpressionStringVal(exprValue.substring(exprValue.indexOf(41) + 2), parent);
        MapType mapType = TypeCreator.createMapType(PredefinedTypes.TYPE_ANYDATA, false);
        BTableType tableType = keyFieldNames.isEmpty() ? (BTableType)TypeCreator.createTableType(mapType, false) : (BTableType)TypeCreator.createTableType((Type)mapType, keys2, false);
        return new TableValueImpl(tableType, (ArrayValue)data2, keyFieldNames);
    }

    public static Object parseXmlExpressionStringValue(String exprValue) {
        if (exprValue.matches("^<!--[\\s\\S]*?-->$")) {
            String comment = exprValue.substring(exprValue.indexOf("<!--") + 4, exprValue.lastIndexOf("-->"));
            return XmlFactory.createXMLComment(io.ballerina.runtime.api.utils.StringUtils.fromString(comment));
        }
        if (exprValue.matches("^<\\?[\\w-]+ ([\\s\\S]*?)\\?>$")) {
            String pi = exprValue.substring(exprValue.indexOf("<?") + 2, exprValue.lastIndexOf("?>"));
            String[] piArgs = pi.split(" ", 2);
            return XmlFactory.createXMLProcessingInstruction(io.ballerina.runtime.api.utils.StringUtils.fromString(piArgs[0]), io.ballerina.runtime.api.utils.StringUtils.fromString(piArgs[1]));
        }
        if (!exprValue.startsWith("<")) {
            return XmlFactory.createXMLText(io.ballerina.runtime.api.utils.StringUtils.fromString(exprValue));
        }
        return TypeConverter.stringToXml(exprValue);
    }

    public static Object parseCycleDetectedExpressionStringValue(String exprValue, BLink parent) {
        hasCycles = true;
        int index = Integer.parseInt(exprValue.substring(4, exprValue.length() - 1));
        CycleUtils.Node mapParent = (CycleUtils.Node)parent;
        Object value2 = mapParent.obj;
        if (index == 0) {
            return value2;
        }
        for (int j = 0; j < index; ++j) {
            value2 = mapParent.obj;
            if (mapParent.parent == null) continue;
            mapParent = (CycleUtils.Node)mapParent.parent;
        }
        return value2;
    }

    public static List<String> getElements(String exprValue) {
        char[] strChars;
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder part = new StringBuilder();
        int balance = 0;
        int quotesCount = 0;
        for (char strChar : strChars = exprValue.substring(1, exprValue.length() - 1).toCharArray()) {
            part.append(strChar);
            if (strChar == '\"') {
                ++quotesCount;
                continue;
            }
            if (strChar == '[' && quotesCount % 2 == 0) {
                ++balance;
                continue;
            }
            if (strChar == '{' && quotesCount % 2 == 0) {
                ++balance;
                continue;
            }
            if (strChar == '(' && quotesCount % 2 == 0) {
                ++balance;
                continue;
            }
            if (strChar == ']' && quotesCount % 2 == 0) {
                --balance;
                continue;
            }
            if (strChar == '}' && quotesCount % 2 == 0) {
                --balance;
                continue;
            }
            if (strChar == ')' && quotesCount % 2 == 0) {
                --balance;
                continue;
            }
            if (strChar != ',' || balance != 0 || quotesCount % 2 != 0) continue;
            list.add(part.substring(0, part.length() - 1));
            part = new StringBuilder();
        }
        if (!part.isEmpty()) {
            list.add(part.toString());
        }
        return list;
    }
}

