/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.utils;

import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BRefValue;
import io.ballerina.runtime.internal.utils.ErrorUtils;
import java.util.HashMap;
import java.util.List;

public final class CloneUtils {
    static final String NEWLINE_WITH_TABS = "\n\t\t";
    static final String TWO_SPACES = "  ";

    private CloneUtils() {
    }

    public static Object cloneValue(Object value2) {
        if (value2 == null) {
            return null;
        }
        if (!(value2 instanceof BRefValue)) {
            return value2;
        }
        BRefValue refValue = (BRefValue)value2;
        return refValue.copy(new HashMap<Object, Object>());
    }

    public static Object cloneReadOnly(Object value2) {
        if (value2 == null) {
            return null;
        }
        if (!(value2 instanceof BRefValue)) {
            return value2;
        }
        BRefValue refValue = (BRefValue)value2;
        return refValue.frozenCopy(new HashMap<Object, Object>());
    }

    public static BError createConversionError(Object value2, Type targetType, List<String> errors2) {
        if (errors2.isEmpty()) {
            return ErrorUtils.createConversionError(value2, targetType);
        }
        return ErrorUtils.createConversionError(value2, targetType, CloneUtils.getErrorMessage(errors2, 20));
    }

    public static String getErrorMessage(List<String> errors2, int maxErrorCount) {
        StringBuilder errorMsg = new StringBuilder();
        int totalErrorCount = errors2.size();
        int tabs = 0;
        for (int i = 0; i < Math.min(totalErrorCount, maxErrorCount); ++i) {
            String err = errors2.get(i);
            if (err == "{") {
                errorMsg.append(NEWLINE_WITH_TABS).append(TWO_SPACES.repeat(tabs++)).append("{");
                continue;
            }
            if (err == "}") {
                errorMsg.append(NEWLINE_WITH_TABS).append(TWO_SPACES.repeat(--tabs)).append("}");
                continue;
            }
            if (err == "or") {
                errorMsg.append(NEWLINE_WITH_TABS).append(TWO_SPACES.repeat(tabs - 1)).append("or");
                continue;
            }
            errorMsg.append(NEWLINE_WITH_TABS).append(TWO_SPACES.repeat(tabs)).append(err);
        }
        if (totalErrorCount > maxErrorCount) {
            errorMsg.append("\n\t\t...");
        }
        return errorMsg.toString();
    }
}

