/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.utils;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.types.BRecordType;
import io.ballerina.runtime.internal.types.BTypeReferenceType;
import io.ballerina.runtime.internal.values.MapValue;

public final class MapUtils {
    private MapUtils() {
    }

    public static void handleMapStore(MapValue<BString, Object> mapValue, BString fieldName, Object value2) {
        MapUtils.updateMapValue(mapValue.getType(), mapValue, fieldName, value2);
    }

    public static void handleInherentTypeViolatingMapUpdate(Object value2, MapType mapType) {
        if (TypeChecker.checkIsType(value2, mapType.getConstrainedType())) {
            return;
        }
        Type expType = mapType.getConstrainedType();
        Type valuesType = TypeChecker.getType(value2);
        throw ErrorCreator.createError(ErrorReasons.getModulePrefixedReason("lang.map", "InherentTypeViolation"), ErrorHelper.getErrorDetails(ErrorCodes.INVALID_MAP_INSERTION, expType, valuesType));
    }

    public static boolean handleInherentTypeViolatingRecordUpdate(MapValue<?, ?> mapValue, BString fieldName, Object value2, BRecordType recType, boolean initialValue) {
        Type recFieldType;
        Field recField = recType.getFields().get(fieldName.getValue());
        if (recField != null) {
            if (!initialValue && SymbolFlags.isFlagOn(recField.getFlags(), 32L)) {
                throw ErrorCreator.createError(ErrorReasons.getModulePrefixedReason("lang.map", "InherentTypeViolation"), ErrorHelper.getErrorDetails(ErrorCodes.RECORD_INVALID_READONLY_FIELD_UPDATE, fieldName, mapValue.getType()));
            }
            recFieldType = recField.getFieldType();
            if (value2 == null && SymbolFlags.isFlagOn(recField.getFlags(), 4096L) && !MapUtils.containsNilType(recFieldType)) {
                return false;
            }
        } else if (recType.restFieldType != null) {
            recFieldType = recType.restFieldType;
        } else {
            throw ErrorCreator.createError(ErrorReasons.MAP_KEY_NOT_FOUND_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.INVALID_RECORD_FIELD_ACCESS, fieldName, mapValue.getType()));
        }
        if (TypeChecker.checkIsType(value2, recFieldType)) {
            return true;
        }
        Type valuesType = TypeChecker.getType(value2);
        throw ErrorCreator.createError(ErrorReasons.getModulePrefixedReason("lang.map", "InherentTypeViolation"), ErrorHelper.getErrorDetails(ErrorCodes.INVALID_RECORD_FIELD_ADDITION, fieldName, recFieldType, valuesType));
    }

    private static boolean containsNilType(Type type) {
        return Core.containsBasicType(SemType.tryInto(TypeChecker.context(), type), Builder.getNilType());
    }

    public static BError createOpNotSupportedError(Type type, String op) {
        return ErrorCreator.createError(ErrorReasons.getModulePrefixedReason("lang.map", "OperationNotSupported"), ErrorHelper.getErrorDetails(ErrorCodes.OPERATION_NOT_SUPPORTED_ERROR, op, type));
    }

    public static void checkIsMapOnlyOperation(Type mapType, String op) {
        switch (TypeUtils.getImpliedType(mapType).getTag()) {
            case 15: 
            case 24: 
            case 27: {
                return;
            }
        }
        throw MapUtils.createOpNotSupportedError(mapType, op);
    }

    private static void updateMapValue(Type mapType, MapValue<BString, Object> mapValue, BString fieldName, Object value2) {
        mapType = TypeUtils.getImpliedType(mapType);
        switch (mapType.getTag()) {
            case 27: {
                MapUtils.handleInherentTypeViolatingMapUpdate(value2, (MapType)mapType);
                mapValue.put(fieldName, value2);
                return;
            }
            case 24: {
                if (MapUtils.handleInherentTypeViolatingRecordUpdate(mapValue, fieldName, value2, (BRecordType)mapType, false)) {
                    mapValue.put(fieldName, value2);
                    return;
                }
                mapValue.remove(fieldName);
                return;
            }
            case 53: {
                MapUtils.updateMapValue(((BTypeReferenceType)mapType).getReferredType(), mapValue, fieldName, value2);
            }
        }
    }
}

