/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.ShapeAnalyzer;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BIterator;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.json.JsonGenerator;
import io.ballerina.runtime.internal.types.BTupleType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.types.TypeWithShape;
import io.ballerina.runtime.internal.types.semtype.ListDefinition;
import io.ballerina.runtime.internal.utils.IteratorUtils;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.IteratorValue;
import io.ballerina.runtime.internal.values.RecursiveValue;
import io.ballerina.runtime.internal.values.ValuePair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractArrayValue
implements ArrayValue,
RecursiveValue<ListDefinition> {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getListType();
    static final int SYSTEM_ARRAY_MAX = 0x7FFFFFF7;
    private final ThreadLocal<ListDefinition> readonlyAttachedDefinition = new ThreadLocal();
    protected int maxSize = 0x7FFFFFF7;
    protected static final int DEFAULT_ARRAY_SIZE = 100;
    protected int size = 0;
    protected Type iteratorNextReturnType;

    @Override
    public void append(Object value2) {
        this.add((long)this.size, value2);
    }

    @Override
    public boolean equals(Object o, Set<ValuePair> visitedValues) {
        if (!(o instanceof ArrayValue)) {
            return false;
        }
        ArrayValue arrayValue = (ArrayValue)o;
        ValuePair compValuePair = new ValuePair(this, o);
        for (ValuePair valuePair : visitedValues) {
            if (!valuePair.equals(compValuePair)) continue;
            return true;
        }
        visitedValues.add(compValuePair);
        if (arrayValue.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (TypeChecker.isEqual(this.get(i), arrayValue.get(i), visitedValues)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object reverse() {
        throw new UnsupportedOperationException("reverse for tuple types is not supported directly.");
    }

    @Override
    public Object shift() {
        return this.shift(0L);
    }

    @Override
    public void unshift(Object[] values) {
        this.unshift(0L, values);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        ArrayValue copy = (ArrayValue)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    public String toString() {
        return this.stringValue(null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getJSONString() {
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();){
            String string2;
            try (JsonGenerator gen2 = new JsonGenerator(byteOut);){
                gen2.serialize(this);
                gen2.flush();
                string2 = byteOut.toString();
            }
            return string2;
        }
        catch (IOException e2) {
            throw ErrorCreator.createError(StringUtils.fromString("Error in converting JSON to a string: " + e2.getMessage()), e2);
        }
    }

    @Override
    public IteratorValue<Object> getIterator() {
        return new ArrayIterator(this);
    }

    @Override
    public void setLength(long length2) {
        if (length2 == (long)this.size) {
            return;
        }
        this.handleImmutableArrayValue();
        int newLength = (int)length2;
        this.checkFixedLength(length2);
        this.rangeCheck(length2, this.size);
        this.fillerValueCheck(newLength, this.size, newLength);
        this.resizeInternalArray(newLength);
        this.fillValues(newLength);
        this.size = newLength;
    }

    @Override
    public long getLength() {
        return this.size;
    }

    protected void initializeIteratorNextReturnType() {
        Type type = TypeUtils.getImpliedType(this.getType());
        if (type.getTag() == 32) {
            type = this.getElementType();
        } else {
            BTupleType tupleType = (BTupleType)type;
            LinkedHashSet<Type> types2 = new LinkedHashSet<Type>(tupleType.getTupleTypes());
            if (tupleType.getRestType() != null) {
                types2.add(tupleType.getRestType());
            }
            type = types2.size() == 1 ? (Type)types2.iterator().next() : new BUnionType(new ArrayList<Type>(types2));
        }
        this.iteratorNextReturnType = IteratorUtils.createIteratorNextReturnType(type);
    }

    @Override
    public Type getIteratorNextReturnType() {
        if (this.iteratorNextReturnType == null) {
            this.initializeIteratorNextReturnType();
        }
        return this.iteratorNextReturnType;
    }

    protected abstract void fillValues(int var1);

    protected abstract void fillerValueCheck(int var1, int var2, int var3);

    protected abstract void resizeInternalArray(int var1);

    protected abstract void rangeCheckForGet(long var1, int var3);

    protected abstract void rangeCheck(long var1, int var3);

    protected void handleImmutableArrayValue() {
        if (!this.getType().isReadOnly()) {
            return;
        }
        throw ErrorCreator.createError(ErrorReasons.getModulePrefixedReason("lang.array", "InvalidUpdate"), ErrorHelper.getErrorDetails(ErrorCodes.INVALID_READONLY_VALUE_UPDATE, new Object[0]));
    }

    protected void prepareForConsecutiveMultiAdd(long index, int currentArraySize) {
        int intIndex = (int)index;
        this.rangeCheck(index, this.size);
        this.ensureCapacity(intIndex + 1, currentArraySize);
        this.resetSize(intIndex);
    }

    protected abstract void ensureCapacity(int var1, int var2);

    private void resetSize(int index) {
        if (index >= this.size) {
            this.size = index + 1;
        }
    }

    protected abstract void unshift(long var1, Object[] var3);

    protected abstract void checkFixedLength(long var1);

    protected void prepareForAddForcefully(int intIndex, int currentArraySize) {
        this.ensureCapacity(intIndex + 1, currentArraySize);
        this.fillValues(intIndex);
        this.resetSize(intIndex);
    }

    @Override
    public ListDefinition getReadonlyShapeDefinition() {
        return this.readonlyAttachedDefinition.get();
    }

    @Override
    public void setReadonlyShapeDefinition(ListDefinition definition) {
        this.readonlyAttachedDefinition.set(definition);
    }

    @Override
    public void resetReadonlyShapeDefinition() {
        this.readonlyAttachedDefinition.remove();
    }

    @Override
    public Optional<SemType> inherentTypeOf(Context cx) {
        TypeWithShape typeWithShape = (TypeWithShape)((Object)this.getType());
        return typeWithShape.inherentTypeOf(cx, ShapeAnalyzer::inherentTypeOf, this);
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    @Override
    public Iterator<?> getJavaIterator() {
        final BIterator iterator2 = this.getIterator();
        return new Iterator<Object>(this){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public Object next() {
                return iterator2.next();
            }
        };
    }

    static class ArrayIterator
    implements IteratorValue<Object> {
        ArrayValue array;
        long cursor = 0L;
        long length;

        ArrayIterator(ArrayValue value2) {
            this.array = value2;
            this.length = value2.size();
        }

        @Override
        public Object next() {
            long cursor;
            if ((cursor = this.cursor++) == this.length) {
                return null;
            }
            return this.array.get(cursor);
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.length;
        }
    }
}

