/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.values.NonBmpStringValue;
import io.ballerina.runtime.internal.values.StringValue;

public class BmpStringValue
extends StringValue {
    public BmpStringValue(String value2) {
        super(value2, false);
    }

    @Override
    public int getCodePoint(int index) {
        return this.value.charAt(index);
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public BString concat(BString str) {
        StringValue stringValue = (StringValue)str;
        if (stringValue.isNonBmp) {
            int[] otherSurrogates = ((NonBmpStringValue)str).getSurrogates();
            int[] newSurrogates = new int[otherSurrogates.length];
            int length2 = this.length();
            for (int i = 0; i < otherSurrogates.length; ++i) {
                newSurrogates[i] = otherSurrogates[i] + length2;
            }
            return new NonBmpStringValue(this.value + str.getValue(), newSurrogates);
        }
        return new BmpStringValue(this.value + str.getValue());
    }

    @Override
    public Long indexOf(BString str, int fromIndex) {
        long index = this.value.indexOf(str.getValue(), fromIndex);
        return index >= 0L ? Long.valueOf(index) : null;
    }

    @Override
    public Long lastIndexOf(BString str, int fromIndex) {
        long index = this.value.lastIndexOf(str.getValue(), fromIndex);
        return index >= 0L ? Long.valueOf(index) : null;
    }

    @Override
    public BString substring(int beginIndex, int endIndex) {
        return new BmpStringValue(this.value.substring(beginIndex, endIndex));
    }
}

