/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.types.BDecimalType;
import io.ballerina.runtime.internal.utils.ErrorUtils;
import io.ballerina.runtime.internal.values.DecimalValueKind;
import io.ballerina.runtime.internal.values.SimpleValue;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Map;
import java.util.Optional;

public class DecimalValue
implements SimpleValue,
BDecimal {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getDecimalType();
    private static final BDecimalType DECIMAL_TYPE = new BDecimalType("decimal", new Module(null, null, null));
    private static final String INF_STRING = "Infinity";
    private static final String NEG_INF_STRING = "-Infinity";
    private static final String NAN = "NaN";
    private static final BigDecimal DECIMAL_MAX = new BigDecimal("9.999999999999999999999999999999999e6144", MathContext.DECIMAL128);
    private static final BigDecimal DECIMAL_MIN = new BigDecimal("-9.999999999999999999999999999999999e6144", MathContext.DECIMAL128);
    private static final BigDecimal MIN_DECIMAL_MAGNITUDE = new BigDecimal("1.000000000000000000000000000000000e-6143", MathContext.DECIMAL128);
    @Deprecated
    public DecimalValueKind valueKind = DecimalValueKind.OTHER;
    private final BigDecimal value;
    private BDecimalType type;
    private final boolean shapeCalculated = false;

    public DecimalValue(BigDecimal value2) {
        this.type = DECIMAL_TYPE;
        this.value = DecimalValue.getValidDecimalValue(value2);
        if (!this.booleanValue()) {
            this.valueKind = DecimalValueKind.ZERO;
        }
    }

    public DecimalValue(String value2) {
        BigDecimal bd;
        try {
            bd = new BigDecimal(value2, MathContext.DECIMAL128);
        }
        catch (NumberFormatException exception) {
            String message2 = exception.getMessage();
            if (message2 != null && (message2.equals("Too many nonzero exponent digits.") || message2.equals("Exponent overflow."))) {
                throw ErrorCreator.createError(ErrorReasons.LARGE_EXPONENT_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.LARGE_EXPONENTS_IN_DECIMAL, value2));
            }
            throw exception;
        }
        this.value = DecimalValue.getValidDecimalValue(bd);
        this.type = DECIMAL_TYPE;
        if (!this.booleanValue()) {
            this.valueKind = DecimalValueKind.ZERO;
        }
    }

    public DecimalValue(String value2, DecimalValueKind valueKind) {
        this(value2);
        this.valueKind = valueKind;
    }

    private static BigDecimal getValidDecimalValue(BigDecimal bd) {
        if (bd.compareTo(DECIMAL_MAX) > 0 || bd.compareTo(DECIMAL_MIN) < 0) {
            throw ErrorCreator.createError(ErrorReasons.NUMBER_OVERFLOW, ErrorHelper.getErrorDetails(ErrorCodes.DECIMAL_VALUE_OUT_OF_RANGE, new Object[0]));
        }
        if (bd.abs(MathContext.DECIMAL128).compareTo(MIN_DECIMAL_MAGNITUDE) < 0 && bd.abs(MathContext.DECIMAL128).compareTo(BigDecimal.ZERO) > 0) {
            return BigDecimal.ZERO;
        }
        return bd;
    }

    @Override
    public BigDecimal decimalValue() {
        return this.value;
    }

    @Override
    public long intValue() {
        if (!DecimalValue.isDecimalWithinIntRange(this)) {
            throw ErrorUtils.createNumericConversionError(this.stringValue(null), PredefinedTypes.TYPE_DECIMAL, PredefinedTypes.TYPE_INT);
        }
        return this.value.setScale(0, RoundingMode.HALF_EVEN).longValue();
    }

    public static boolean isDecimalWithinIntRange(DecimalValue decimalValue) {
        BigDecimal value2 = decimalValue.value;
        return value2.compareTo(RuntimeConstants.BINT_MAX_VALUE_BIG_DECIMAL_RANGE_MAX) < 0 && value2.compareTo(RuntimeConstants.BINT_MIN_VALUE_BIG_DECIMAL_RANGE_MIN) > 0;
    }

    @Override
    public int byteValue() {
        int intVal = (int)Math.rint(this.value.doubleValue());
        if (!DecimalValue.isByteLiteral(intVal)) {
            throw ErrorUtils.createNumericConversionError(this.value, PredefinedTypes.TYPE_DECIMAL, PredefinedTypes.TYPE_BYTE);
        }
        return intVal;
    }

    private static boolean isByteLiteral(long longValue) {
        return longValue >= (long)RuntimeConstants.BBYTE_MIN_VALUE.intValue() && longValue <= (long)RuntimeConstants.BBYTE_MAX_VALUE.intValue();
    }

    @Override
    public double floatValue() {
        return this.value.doubleValue();
    }

    @Override
    public boolean booleanValue() {
        return this.value.compareTo(BigDecimal.ZERO) != 0;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public String stringValue(BLink parent) {
        if (this.valueKind != DecimalValueKind.OTHER) {
            return this.valueKind.getValue();
        }
        return this.value.toString();
    }

    @Override
    public String expressionStringValue(BLink parent) {
        if (this.valueKind != DecimalValueKind.OTHER) {
            return this.valueKind.getValue() + "d";
        }
        return this.value.toString() + "d";
    }

    @Override
    public BigDecimal value() {
        return this.value;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public DecimalValue add(DecimalValue augend) {
        if (this.valueKind == DecimalValueKind.ZERO) {
            return augend;
        }
        if (augend.valueKind == DecimalValueKind.ZERO) {
            return this;
        }
        return new DecimalValue(this.decimalValue().add(augend.decimalValue(), MathContext.DECIMAL128));
    }

    public DecimalValue subtract(DecimalValue subtrahend) {
        if (this.valueKind == DecimalValueKind.ZERO) {
            if (subtrahend.valueKind == DecimalValueKind.ZERO) {
                return subtrahend;
            }
            return subtrahend.negate();
        }
        if (subtrahend.valueKind == DecimalValueKind.ZERO) {
            return this;
        }
        return new DecimalValue(this.decimalValue().subtract(subtrahend.decimalValue(), MathContext.DECIMAL128));
    }

    public DecimalValue multiply(DecimalValue multiplicand) {
        if (this.valueKind == DecimalValueKind.ZERO) {
            return this;
        }
        if (multiplicand.valueKind == DecimalValueKind.OTHER) {
            return new DecimalValue(this.decimalValue().multiply(multiplicand.decimalValue(), MathContext.DECIMAL128));
        }
        return multiplicand;
    }

    public DecimalValue divide(DecimalValue divisor) {
        if (this.valueKind == DecimalValueKind.ZERO) {
            if (divisor.valueKind == DecimalValueKind.ZERO) {
                throw ErrorUtils.createInvalidDecimalError(NAN);
            }
            return this;
        }
        if (divisor.valueKind == DecimalValueKind.OTHER) {
            return new DecimalValue(this.decimalValue().divide(divisor.decimalValue(), MathContext.DECIMAL128));
        }
        if (this.decimalValue().compareTo(BigDecimal.ZERO) > 0) {
            throw ErrorUtils.createInvalidDecimalError(INF_STRING);
        }
        throw ErrorUtils.createInvalidDecimalError(NEG_INF_STRING);
    }

    public DecimalValue remainder(DecimalValue divisor) {
        if (divisor.valueKind == DecimalValueKind.OTHER) {
            return new DecimalValue(this.decimalValue().remainder(divisor.decimalValue(), MathContext.DECIMAL128));
        }
        throw ErrorUtils.createInvalidDecimalError(NAN);
    }

    @Override
    public DecimalValue negate() {
        if (this.valueKind == DecimalValueKind.OTHER) {
            return new DecimalValue(this.decimalValue().negate());
        }
        return this;
    }

    @Override
    public BDecimal add(BDecimal augend) {
        return this.add((DecimalValue)augend);
    }

    @Override
    public BDecimal subtract(BDecimal subtrahend) {
        return this.subtract((DecimalValue)subtrahend);
    }

    @Override
    public BDecimal multiply(BDecimal multiplicand) {
        return this.multiply((DecimalValue)multiplicand);
    }

    @Override
    public BDecimal divide(BDecimal divisor) {
        return this.divide((DecimalValue)divisor);
    }

    @Override
    public BDecimal remainder(BDecimal divisor) {
        return this.remainder((DecimalValue)divisor);
    }

    @Override
    public DecimalValueKind getValueKind() {
        return this.valueKind;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DecimalValue bDecimal = (DecimalValue)obj;
        return this.value.compareTo(bDecimal.value) == 0 && this.valueKind == bDecimal.valueKind;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.stringValue(null);
    }

    public static DecimalValue valueOf(int value2) {
        return new DecimalValue(new BigDecimal(value2, MathContext.DECIMAL128).setScale(1, RoundingMode.HALF_EVEN));
    }

    public static DecimalValue valueOf(long value2) {
        return new DecimalValue(new BigDecimal(value2, MathContext.DECIMAL128).setScale(1, RoundingMode.HALF_EVEN));
    }

    public static DecimalValue valueOf(double value2) {
        if (Double.isNaN(value2)) {
            throw ErrorUtils.createInvalidDecimalError(NAN);
        }
        if (value2 == Double.POSITIVE_INFINITY) {
            throw ErrorUtils.createInvalidDecimalError(INF_STRING);
        }
        if (value2 == Double.NEGATIVE_INFINITY) {
            throw ErrorUtils.createInvalidDecimalError(NEG_INF_STRING);
        }
        return new DecimalValue(BigDecimal.valueOf(value2));
    }

    public static DecimalValue valueOf(boolean value2) {
        return new DecimalValue(value2 ? BigDecimal.ONE.setScale(1, 6) : BigDecimal.ZERO.setScale(1, 6));
    }

    public static DecimalValue valueOfJ(byte value2) {
        return new DecimalValue(new BigDecimal(value2, MathContext.DECIMAL128).setScale(1, 6));
    }

    public static DecimalValue valueOfJ(char value2) {
        return new DecimalValue(new BigDecimal(value2, MathContext.DECIMAL128).setScale(1, 6));
    }

    public static DecimalValue valueOfJ(short value2) {
        return new DecimalValue(new BigDecimal(value2, MathContext.DECIMAL128).setScale(1, 6));
    }

    public static DecimalValue valueOfJ(int value2) {
        return new DecimalValue(new BigDecimal(value2, MathContext.DECIMAL128).setScale(1, 6));
    }

    public static DecimalValue valueOfJ(long value2) {
        return new DecimalValue(new BigDecimal(value2, MathContext.DECIMAL128).setScale(1, 6));
    }

    public static DecimalValue valueOfJ(float value2) {
        return new DecimalValue(new BigDecimal(value2, MathContext.DECIMAL128).setScale(1, 6));
    }

    public static DecimalValue valueOfJ(double value2) {
        return new DecimalValue(new BigDecimal(value2, MathContext.DECIMAL128).setScale(1, 6));
    }

    public static DecimalValue valueOfJ(BigDecimal value2) {
        return new DecimalValue(new BigDecimal(value2.toString(), MathContext.DECIMAL128).setScale(1, 6));
    }

    @Override
    public Optional<SemType> inherentTypeOf(Context cx) {
        this.type = BDecimalType.singletonType(this.value);
        return Optional.of(this.type.shape());
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }
}

