/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.values.BHandle;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.internal.values.RefValue;
import io.ballerina.runtime.internal.values.TypedescValueImpl;
import java.util.Map;

public class HandleValue
implements BHandle,
RefValue {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getHandleType();
    private final Object value;
    private BTypedesc typedesc;

    public HandleValue(Object value2) {
        this.value = value2;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String stringValue(BLink parent) {
        return String.valueOf(this.value);
    }

    @Override
    public String expressionStringValue(BLink parent) {
        return this.stringValue(parent);
    }

    public String toString() {
        return this.value != null ? this.value.toString() : null;
    }

    @Override
    public Type getType() {
        return PredefinedTypes.TYPE_HANDLE;
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public void freezeDirect() {
    }

    @Override
    public BTypedesc getTypedesc() {
        if (this.typedesc == null) {
            this.typedesc = new TypedescValueImpl(PredefinedTypes.TYPE_HANDLE);
        }
        return this.typedesc;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        return this;
    }

    public static HandleValue valueOfJ(Object value2) {
        return new HandleValue(value2);
    }
}

