/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BRegexpValue;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.internal.types.semtype.RegexUtils;
import io.ballerina.runtime.internal.utils.ValueUtils;
import io.ballerina.runtime.internal.values.RefValue;
import io.ballerina.runtime.internal.values.RegExpDisjunction;
import io.ballerina.runtime.internal.values.ValuePair;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class RegExpValue
implements BRegexpValue,
RefValue {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getRegexType();
    private final RegExpDisjunction regExpDisjunction;
    private BTypedesc typedesc;
    private static final Type type = PredefinedTypes.TYPE_READONLY_ANYDATA;
    private final SemType shape;

    public RegExpValue(RegExpDisjunction regExpDisjunction) {
        this.regExpDisjunction = regExpDisjunction;
        this.shape = RegexUtils.regexShape(regExpDisjunction.stringValue(null));
    }

    @Override
    public RegExpDisjunction getRegExpDisjunction() {
        return this.regExpDisjunction;
    }

    @Override
    public String stringValue(BLink parent) {
        return this.regExpDisjunction.stringValue(parent);
    }

    @Override
    public String expressionStringValue(BLink parent) {
        return "re `" + this.stringValue(parent) + "`";
    }

    @Override
    public String informalStringValue(BLink parent) {
        return "`" + this.stringValue(parent) + "`";
    }

    @Override
    public Type getType() {
        return type;
    }

    public int hashCode() {
        return Objects.hash(this.regExpDisjunction);
    }

    @Override
    public BTypedesc getTypedesc() {
        if (this.typedesc == null) {
            this.typedesc = ValueUtils.getTypedescValue(type, this);
        }
        return this.typedesc;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public void freezeDirect() {
    }

    public String toString() {
        return this.stringValue(null);
    }

    @Override
    public boolean equals(Object o, Set<ValuePair> visitedValues) {
        if (!(o instanceof RegExpValue)) {
            return false;
        }
        RegExpValue rhsRegExpValue = (RegExpValue)o;
        return this.stringValue(null).equals(rhsRegExpValue.stringValue(null));
    }

    @Override
    public SemType widenedType(Context cx) {
        return Builder.getRegexType();
    }

    @Override
    public Optional<SemType> shapeOf() {
        return Optional.of(this.shape);
    }

    @Override
    public Optional<SemType> inherentTypeOf(Context cx) {
        return this.shapeOf();
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }
}

