/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.TableType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.ShapeAnalyzer;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BIterator;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BRefValue;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.types.BIntersectionType;
import io.ballerina.runtime.internal.types.BRecordType;
import io.ballerina.runtime.internal.types.BTableType;
import io.ballerina.runtime.internal.types.BTupleType;
import io.ballerina.runtime.internal.types.BTypeReferenceType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.types.TypeWithShape;
import io.ballerina.runtime.internal.utils.CycleUtils;
import io.ballerina.runtime.internal.utils.IteratorUtils;
import io.ballerina.runtime.internal.utils.StringUtils;
import io.ballerina.runtime.internal.utils.TableUtils;
import io.ballerina.runtime.internal.utils.ValueUtils;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.IteratorValue;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import io.ballerina.runtime.internal.values.TableValue;
import io.ballerina.runtime.internal.values.TableValueImpl;
import io.ballerina.runtime.internal.values.TupleValueImpl;
import io.ballerina.runtime.internal.values.ValuePair;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class TableValueImpl<K, V>
implements TableValue<K, V> {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getTableType();
    private Type type;
    private TableType tableType;
    private Type iteratorNextReturnType;
    private final ConcurrentHashMap<Long, List<Map.Entry<K, V>>> entries;
    private final LinkedHashMap<Long, List<V>> values;
    private String[] fieldNames;
    private ValueHolder valueHolder;
    private long maxIntKey = 0L;
    private final Map<Long, K> indexToKeyMap;
    private final Map<K, Long> keyToIndexMap;
    private final Map<K, V> keyValues;
    private long noOfAddedEntries = 0L;
    private boolean nextKeySupported;
    private final Map<String, Object> nativeData = new HashMap<String, Object>();
    private BTypedesc typedesc;

    public TableValueImpl(TableType tableType) {
        this.tableType = tableType;
        this.type = this.tableType;
        this.entries = new ConcurrentHashMap();
        this.values = new LinkedHashMap();
        this.keyToIndexMap = new LinkedHashMap<K, Long>();
        this.indexToKeyMap = new TreeMap<Long, K>();
        this.fieldNames = tableType.getFieldNames();
        this.keyValues = new LinkedHashMap();
        this.valueHolder = tableType.getFieldNames().length > 0 ? new KeyHashValueHolder() : new ValueHolder();
    }

    public TableValueImpl(Type type, ArrayValue data2, ArrayValue fieldNames) {
        this((TableType)TypeUtils.getImpliedType(type), data2, fieldNames);
        this.type = type;
    }

    public TableValueImpl(TableType tableType, ArrayValue data2, ArrayValue fieldNames) {
        this(tableType);
        if (this.fieldNames == null) {
            this.fieldNames = fieldNames.getStringArray();
        }
        this.addData(data2);
    }

    public TableValueImpl(TableType tableType, ArrayValue fieldNames) {
        this(tableType);
        this.fieldNames = fieldNames.getStringArray();
        this.valueHolder = this.fieldNames.length > 0 ? new KeyHashValueHolder() : new ValueHolder();
    }

    private void addData(ArrayValue data2) {
        BIterator itr = data2.getIterator();
        while (itr.hasNext()) {
            Object next2 = itr.next();
            this.valueHolder.addData(next2);
        }
    }

    @Override
    public IteratorValue<?> getIterator() {
        return new TableIterator();
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        if (refs.containsKey(this)) {
            return refs.get(this);
        }
        TableValueImpl<K, Object> clone2 = new TableValueImpl<K, Object>(this.tableType);
        clone2.type = this.type;
        if (this.fieldNames != null) {
            clone2.fieldNames = this.fieldNames;
        }
        BIterator itr = this.getIterator();
        while (itr.hasNext()) {
            TupleValueImpl tupleValue = (TupleValueImpl)itr.next();
            Object value2 = tupleValue.get(1L);
            value2 = value2 instanceof BRefValue ? ((BRefValue)value2).copy(refs) : value2;
            clone2.add(value2);
        }
        return clone2;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        TableValueImpl copy = (TableValueImpl)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    protected void handleFrozenTableValue() {
        if (this.tableType.isReadOnly()) {
            ReadOnlyUtils.handleInvalidUpdate("lang.table");
        }
    }

    @Override
    public BTypedesc getTypedesc() {
        if (this.typedesc == null) {
            this.typedesc = ValueUtils.getTypedescValue(this.type, this);
        }
        return this.typedesc;
    }

    @Override
    public V get(Object key) {
        return this.valueHolder.getData(key);
    }

    @Override
    public V put(V value2) {
        this.handleFrozenTableValue();
        return this.valueHolder.putData(value2);
    }

    @Override
    public V put(K key, V value2) {
        this.handleFrozenTableValue();
        return this.valueHolder.putData(key, value2);
    }

    @Override
    public void add(V data2) {
        this.handleFrozenTableValue();
        this.valueHolder.addData(data2);
    }

    @Override
    public V remove(Object key) {
        this.handleFrozenTableValue();
        return this.valueHolder.remove(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.valueHolder.containsKey(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> entrySet = new LinkedHashSet<Map.Entry<K, V>>();
        for (List<Map.Entry<K, V>> entry : this.entries.values()) {
            entrySet.addAll(entry);
        }
        return entrySet;
    }

    @Override
    public Collection<V> values() {
        ArrayList newValues = new ArrayList();
        Set<Long> keys2 = this.values.keySet();
        for (long key : keys2) {
            newValues.addAll(this.values.get(key));
        }
        return newValues;
    }

    @Override
    public void clear() {
        this.handleFrozenTableValue();
        this.entries.clear();
        this.values.clear();
        this.keyToIndexMap.clear();
        this.indexToKeyMap.clear();
        this.noOfAddedEntries = 0L;
    }

    @Override
    public V getOrThrow(Object key) {
        if (!this.containsKey(key)) {
            throw ErrorCreator.createError(ErrorReasons.TABLE_KEY_NOT_FOUND_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.KEY_NOT_FOUND_ERROR, key));
        }
        return this.get(key);
    }

    @Override
    public V removeOrThrow(Object key) {
        this.handleFrozenTableValue();
        if (!this.containsKey(key)) {
            throw ErrorCreator.createError(ErrorReasons.TABLE_KEY_NOT_FOUND_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.KEY_NOT_FOUND_ERROR, key));
        }
        return this.remove(key);
    }

    @Override
    public long getNextKey() {
        if (!this.nextKeySupported) {
            throw ErrorCreator.createError(ErrorReasons.OPERATION_NOT_SUPPORTED_ERROR, io.ballerina.runtime.api.utils.StringUtils.fromString("Defined key sequence is not supported with nextKey(). The key sequence should only have an Integer field."));
        }
        return this.indexToKeyMap.isEmpty() ? 0L : this.maxIntKey + 1L;
    }

    @Override
    public Type getKeyType() {
        return this.valueHolder.getKeyType();
    }

    @Override
    public V fillAndGet(Object key) {
        if (this.containsKey(key)) {
            return this.get(key);
        }
        Type expectedType = this.tableType.getConstrainedType();
        if (!TypeChecker.hasFillerValue(expectedType)) {
            throw ErrorCreator.createError(ErrorReasons.TABLE_KEY_NOT_FOUND_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.KEY_NOT_FOUND_ERROR, key));
        }
        Object value2 = expectedType.getZeroValue();
        this.put(key, value2);
        return value2;
    }

    @Override
    public K[] getKeys() {
        return this.indexToKeyMap.values().toArray();
    }

    @Override
    public int size() {
        return this.values().size();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public void addNativeData(String key, Object data2) {
        this.nativeData.put(key, data2);
    }

    @Override
    public Object getNativeData(String key) {
        return this.nativeData.get(key);
    }

    @Override
    public void freezeDirect() {
        if (this.isFrozen()) {
            return;
        }
        this.tableType = (BTableType)ReadOnlyUtils.setImmutableTypeAndGetEffectiveType(this.tableType);
        this.type = ReadOnlyUtils.setImmutableTypeAndGetEffectiveType(this.type);
        this.values().forEach(val2 -> ((BRefValue)val2).freezeDirect());
        this.typedesc = null;
    }

    @Override
    public String stringValue(BLink parent) {
        Iterator<Map.Entry<Long, List<V>>> itr = this.values.entrySet().iterator();
        return this.createStringValueDataEntry(itr, parent);
    }

    @Override
    public String informalStringValue(BLink parent) {
        return this.stringValue(parent);
    }

    @Override
    public String expressionStringValue(BLink parent) {
        Iterator<Map.Entry<Long, List<V>>> itr = this.values.entrySet().iterator();
        return this.createExpressionStringValueDataEntry(itr, parent);
    }

    private String createStringValueDataEntry(Iterator<Map.Entry<Long, List<V>>> itr, BLink parent) {
        StringJoiner sj = new StringJoiner(",");
        while (itr.hasNext()) {
            Map.Entry<Long, List<V>> struct = itr.next();
            if (struct.getValue().size() > 1) {
                for (V data2 : struct.getValue()) {
                    sj.add(StringUtils.getStringVal(data2, new CycleUtils.Node(this, parent)));
                }
                continue;
            }
            sj.add(StringUtils.getStringVal(struct.getValue().get(0), new CycleUtils.Node(this, parent)));
        }
        return "[" + String.valueOf(sj) + "]";
    }

    private String createExpressionStringValueDataEntry(Iterator<Map.Entry<Long, List<V>>> itr, BLink parent) {
        String[] keysList;
        StringJoiner sj = new StringJoiner(",");
        StringJoiner keyJoiner = new StringJoiner(",");
        for (String string2 : keysList = this.tableType.getFieldNames()) {
            keyJoiner.add(string2);
        }
        while (itr.hasNext()) {
            Map.Entry<Long, List<V>> struct = itr.next();
            if (struct.getValue().size() > 1) {
                for (V data2 : struct.getValue()) {
                    sj.add(StringUtils.getExpressionStringVal(data2, new CycleUtils.Node(this, parent)));
                }
                continue;
            }
            sj.add(StringUtils.getExpressionStringVal(struct.getValue().get(0), new CycleUtils.Node(this, parent)));
        }
        return "table key(" + String.valueOf(keyJoiner) + ") [" + String.valueOf(sj) + "]";
    }

    private Type getTableConstraintField(Type constraintType, String fieldName) {
        switch (constraintType.getTag()) {
            case 24: {
                Map<String, Field> fieldList = ((BRecordType)constraintType).getFields();
                return fieldList.get(fieldName).getFieldType();
            }
            case 27: {
                return ((MapType)constraintType).getConstrainedType();
            }
            case 34: {
                Type effectiveType = ((BIntersectionType)constraintType).getEffectiveType();
                return this.getTableConstraintField(effectiveType, fieldName);
            }
            case 53: {
                Type refType = ((BTypeReferenceType)constraintType).getReferredType();
                return this.getTableConstraintField(refType, fieldName);
            }
            case 33: {
                HashSet<Type> possibleTypes = new HashSet<Type>();
                for (Type memberType : ((BUnionType)constraintType).getMemberTypes()) {
                    possibleTypes.add(this.getTableConstraintField(memberType, fieldName));
                }
                if (possibleTypes.size() == 1) {
                    return (Type)possibleTypes.iterator().next();
                }
                if (possibleTypes.size() <= 1) break;
                return new BUnionType(new ArrayList<Type>(possibleTypes));
            }
        }
        return null;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Type getIteratorNextReturnType() {
        if (this.iteratorNextReturnType == null) {
            this.iteratorNextReturnType = IteratorUtils.createIteratorNextReturnType(this.tableType.getConstrainedType());
        }
        return this.iteratorNextReturnType;
    }

    @Override
    public boolean equals(Object o, Set<ValuePair> visitedValues) {
        ValuePair compValuePair = new ValuePair(this, o);
        for (ValuePair valuePair : visitedValues) {
            if (!valuePair.equals(compValuePair)) continue;
            return true;
        }
        visitedValues.add(compValuePair);
        if (!(o instanceof TableValueImpl)) {
            return false;
        }
        TableValueImpl table2 = (TableValueImpl)o;
        if (this.size() != table2.size()) {
            return false;
        }
        boolean isLhsKeyedTable = ((BTableType)TypeUtils.getImpliedType(this.getType())).getFieldNames().length > 0;
        boolean isRhsKeyedTable = ((BTableType)TypeUtils.getImpliedType(table2.getType())).getFieldNames().length > 0;
        Object[] lhsTableValues = this.values().toArray();
        Object[] rhsTableValues = table2.values().toArray();
        if (isLhsKeyedTable != isRhsKeyedTable) {
            return false;
        }
        for (int i = 0; i < lhsTableValues.length; ++i) {
            if (TypeChecker.isEqual(lhsTableValues[i], rhsTableValues[i], visitedValues)) continue;
            return false;
        }
        return true;
    }

    private void updateIndexKeyMappings(Long hash, K key, V value2) {
        if (this.entries.containsKey(hash)) {
            List<Map.Entry<K, V>> entryList = this.entries.get(hash);
            for (Map.Entry<K, V> entry : entryList) {
                if (!TypeChecker.isEqual(entry.getKey(), key)) continue;
                long index = this.keyToIndexMap.remove(entry.getKey());
                this.keyToIndexMap.put(key, index);
                this.indexToKeyMap.put(index, (Long)key);
                this.keyValues.remove(entry.getKey());
                this.keyValues.put(key, value2);
                return;
            }
        }
        this.keyToIndexMap.put(key, this.noOfAddedEntries);
        this.indexToKeyMap.put(this.noOfAddedEntries, (Long)key);
        this.keyValues.put(key, value2);
        ++this.noOfAddedEntries;
    }

    private void checkInherentTypeViolation(MapValue<?, ?> dataMap, TableType type) {
        if (!TypeChecker.checkIsType(dataMap.getType(), type.getConstrainedType())) {
            BString reason = ErrorReasons.getModulePrefixedReason("lang.table", "InherentTypeViolation");
            BString detail2 = io.ballerina.runtime.api.utils.StringUtils.fromString("value type '" + String.valueOf(dataMap.getType()) + "' inconsistent with the inherent table type '" + String.valueOf(type) + "'");
            throw ErrorCreator.createError(reason, detail2);
        }
    }

    public String toString() {
        return this.stringValue(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableValueImpl tableValue = (TableValueImpl)o;
        if (tableValue.tableType.getTag() != this.tableType.getTag()) {
            return false;
        }
        if (this.entrySet().size() != tableValue.entrySet().size()) {
            return false;
        }
        return this.entrySet().equals(tableValue.entrySet());
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public Long getIntValue(BString key) {
        return (Long)this.get(key);
    }

    @Override
    public Double getFloatValue(BString key) {
        return (Double)this.get(key);
    }

    @Override
    public BString getStringValue(BString key) {
        return (BString)this.get(key);
    }

    @Override
    public Boolean getBooleanValue(BString key) {
        return (Boolean)this.get(key);
    }

    @Override
    public BMap<?, ?> getMapValue(BString key) {
        return (BMap)this.get(key);
    }

    @Override
    public BObject getObjectValue(BString key) {
        return (BObject)this.get(key);
    }

    @Override
    public BArray getArrayValue(BString key) {
        return (BArray)this.get(key);
    }

    @Override
    public Optional<SemType> inherentTypeOf(Context cx) {
        TypeWithShape typeWithShape = (TypeWithShape)((Object)this.type);
        return typeWithShape.inherentTypeOf(cx, ShapeAnalyzer::inherentTypeOf, this);
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    @Override
    public Iterator<?> getJavaIterator() {
        final BIterator iterator2 = this.getIterator();
        return new Iterator<Object>(this){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public Object next() {
                BArray keyValueTuple = (BArray)iterator2.next();
                return keyValueTuple.get(1L);
            }
        };
    }

    private class KeyHashValueHolder
    extends ValueHolder {
        private final io.ballerina.runtime.internal.values.TableValueImpl$KeyHashValueHolder.DefaultKeyWrapper keyWrapper;
        private Type keyType;

        public KeyHashValueHolder() {
            this.keyWrapper = TableValueImpl.this.fieldNames.length > 1 ? new MultiKeyWrapper() : new DefaultKeyWrapper();
        }

        @Override
        public void addData(V data2) {
            MapValue dataMap = (MapValue)data2;
            TableValueImpl.this.checkInherentTypeViolation(dataMap, TableValueImpl.this.tableType);
            Object key = this.keyWrapper.wrapKey(dataMap);
            if (this.containsKey(key)) {
                throw ErrorCreator.createError(ErrorReasons.TABLE_HAS_A_VALUE_FOR_KEY_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.TABLE_HAS_A_VALUE_FOR_KEY, key));
            }
            if (TableValueImpl.this.nextKeySupported && (TableValueImpl.this.indexToKeyMap.isEmpty() || TableValueImpl.this.maxIntKey < TypeChecker.anyToInt(key))) {
                TableValueImpl.this.maxIntKey = Long.valueOf(TypeChecker.anyToInt(key)).intValue();
            }
            AbstractMap.SimpleEntry entry = new AbstractMap.SimpleEntry(key, data2);
            Long hash = TableUtils.hash(key, null);
            if (TableValueImpl.this.entries.containsKey(hash)) {
                TableValueImpl.this.updateIndexKeyMappings(hash, key, data2);
                List extEntries = TableValueImpl.this.entries.get(hash);
                extEntries.add(entry);
                List extValues = TableValueImpl.this.values.get(hash);
                extValues.add(data2);
                return;
            }
            this.putNewData(key, data2, entry, hash);
        }

        @Override
        public V getData(K key) {
            List entryList = TableValueImpl.this.entries.get(TableUtils.hash(key, null));
            if (entryList == null) {
                return null;
            }
            for (Map.Entry entry : entryList) {
                if (!TypeChecker.isEqual(key, entry.getKey())) continue;
                return entry.getValue();
            }
            return null;
        }

        @Override
        public V putData(K key, V data2) {
            AbstractMap.SimpleEntry entry = new AbstractMap.SimpleEntry(key, data2);
            Object actualKey = this.keyWrapper.wrapKey((MapValue)data2);
            Long actualHash = TableUtils.hash(actualKey, null);
            Long hash = TableUtils.hash(key, null);
            if (!hash.equals(actualHash)) {
                throw ErrorCreator.createError(ErrorReasons.TABLE_KEY_NOT_FOUND_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.KEY_NOT_FOUND_IN_VALUE, key, data2));
            }
            if (TableValueImpl.this.entries.containsKey(hash)) {
                return this.updateExistingEntry(key, data2, entry, hash);
            }
            return this.putNewData(key, data2, entry, hash);
        }

        private V putNewData(K key, V value2, Map.Entry<K, V> entry, Long hash) {
            ArrayList data2 = new ArrayList();
            data2.add(value2);
            TableValueImpl.this.updateIndexKeyMappings(hash, key, value2);
            ArrayList entryList = new ArrayList();
            entryList.add(entry);
            TableValueImpl.this.entries.put(hash, entryList);
            TableValueImpl.this.values.put(hash, data2);
            return data2.get(0);
        }

        @Override
        public V putData(V data2) {
            MapValue dataMap = (MapValue)data2;
            TableValueImpl.this.checkInherentTypeViolation(dataMap, TableValueImpl.this.tableType);
            Object key = this.keyWrapper.wrapKey(dataMap);
            AbstractMap.SimpleEntry entry = new AbstractMap.SimpleEntry(key, data2);
            Long hash = TableUtils.hash(key, null);
            if (TableValueImpl.this.entries.containsKey(hash)) {
                return this.updateExistingEntry(key, data2, entry, hash);
            }
            return this.putNewData(key, data2, entry, hash);
        }

        private V updateExistingEntry(K key, V data2, Map.Entry<K, V> entry, Long hash) {
            TableValueImpl.this.updateIndexKeyMappings(hash, key, data2);
            List valueList = TableValueImpl.this.values.get(hash);
            List entryList = TableValueImpl.this.entries.get(hash);
            for (Map.Entry extEntry : entryList) {
                if (!TypeChecker.isEqual(key, extEntry.getKey())) continue;
                entryList.remove(extEntry);
                valueList.remove(extEntry.getValue());
                break;
            }
            entryList.add(entry);
            TableValueImpl.this.values.get(hash).add(data2);
            return data2;
        }

        @Override
        public V remove(K key) {
            TableValueImpl.this.keyValues.remove(key);
            Long hash = TableUtils.hash(key, null);
            List entryList = TableValueImpl.this.entries.get(hash);
            if (entryList != null && entryList.size() > 1) {
                for (Map.Entry entry : entryList) {
                    if (!TypeChecker.isEqual(key, entry.getKey())) continue;
                    List valueList = TableValueImpl.this.values.get(hash);
                    valueList.remove(entry.getValue());
                    entryList.remove(entry);
                    Long index = TableValueImpl.this.keyToIndexMap.remove(key);
                    TableValueImpl.this.indexToKeyMap.remove(index);
                    if (index != null && index == TableValueImpl.this.noOfAddedEntries - 1L) {
                        --TableValueImpl.this.noOfAddedEntries;
                    }
                    return entry.getValue();
                }
            }
            if (entryList != null) {
                Long index = TableValueImpl.this.keyToIndexMap.remove(entryList.get(0).getKey());
                TableValueImpl.this.indexToKeyMap.remove(index);
                if (index != null && index == TableValueImpl.this.noOfAddedEntries - 1L) {
                    --TableValueImpl.this.noOfAddedEntries;
                }
            }
            TableValueImpl.this.entries.remove(hash);
            List removedValue = (List)TableValueImpl.this.values.remove(hash);
            if (removedValue == null) {
                return null;
            }
            return removedValue.get(0);
        }

        @Override
        public boolean containsKey(K key) {
            if (TableValueImpl.this.entries.containsKey(TableUtils.hash(key, null))) {
                List entryList = TableValueImpl.this.entries.get(TableUtils.hash(key, null));
                for (Map.Entry entry : entryList) {
                    if (!TypeChecker.isEqual(entry.getKey(), key)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Type getKeyType() {
            return this.keyType;
        }

        /*
         * Signature claims super is io.ballerina.runtime.internal.values.TableValueImpl$KeyHashValueHolder.DefaultKeyWrapper, not io.ballerina.runtime.internal.values.TableValueImpl$KeyHashValueHolder$DefaultKeyWrapper - discarding signature.
         */
        private class MultiKeyWrapper
        extends DefaultKeyWrapper {
            public MultiKeyWrapper() {
                ArrayList<Type> keyTypes = new ArrayList<Type>();
                Type constraintType = TypeUtils.getImpliedType(TableValueImpl.this.tableType.getConstrainedType());
                if (constraintType.getTag() == 24) {
                    BRecordType recordType = (BRecordType)constraintType;
                    Arrays.stream(TableValueImpl.this.fieldNames).forEach(field -> keyTypes.add(recordType.getFields().get(field).getFieldType()));
                } else if (constraintType.getTag() == 27) {
                    MapType mapType = (MapType)constraintType;
                    Arrays.stream(TableValueImpl.this.fieldNames).forEach(field -> keyTypes.add(mapType.getConstrainedType()));
                }
                KeyHashValueHolder.this.keyType = new BTupleType(keyTypes);
            }

            @Override
            public K wrapKey(MapValue<?, ?> data2) {
                TupleValueImpl arr = (TupleValueImpl)ValueCreator.createTupleValue((BTupleType)KeyHashValueHolder.this.keyType);
                for (int i = 0; i < TableValueImpl.this.fieldNames.length; ++i) {
                    arr.add((long)i, data2.get(io.ballerina.runtime.api.utils.StringUtils.fromString(TableValueImpl.this.fieldNames[i])));
                }
                return arr;
            }
        }

        private class DefaultKeyWrapper {
            public DefaultKeyWrapper() {
                if (TableValueImpl.this.fieldNames.length == 1) {
                    KeyHashValueHolder.this.keyType = TableValueImpl.this.getTableConstraintField(TableValueImpl.this.tableType.getConstrainedType(), TableValueImpl.this.fieldNames[0]);
                    if (KeyHashValueHolder.this.keyType != null && TypeUtils.getImpliedType(KeyHashValueHolder.this.keyType).getTag() == 1) {
                        TableValueImpl.this.nextKeySupported = true;
                    }
                }
            }

            public K wrapKey(MapValue<?, ?> data2) {
                return data2.get(io.ballerina.runtime.api.utils.StringUtils.fromString(TableValueImpl.this.fieldNames[0]));
            }
        }
    }

    private class ValueHolder {
        private ValueHolder() {
        }

        public void addData(V data2) {
            this.putData(data2);
        }

        public V getData(K key) {
            throw ErrorCreator.createError(ErrorReasons.TABLE_KEY_NOT_FOUND_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.KEY_NOT_FOUND_ERROR, key));
        }

        public V putData(K key, V data2) {
            throw ErrorCreator.createError(ErrorReasons.TABLE_KEY_NOT_FOUND_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.KEY_NOT_FOUND_ERROR, key));
        }

        public V putData(V data2) {
            TableValueImpl.this.checkInherentTypeViolation((MapValue)data2, TableValueImpl.this.tableType);
            ArrayList newData = new ArrayList();
            newData.add(data2);
            AbstractMap.SimpleEntry entry = new AbstractMap.SimpleEntry(data2, data2);
            ArrayList entryList = new ArrayList();
            entryList.add(entry);
            UUID uuid = UUID.randomUUID();
            Long hash = uuid.hashCode();
            TableValueImpl.this.updateIndexKeyMappings(hash, data2, data2);
            TableValueImpl.this.entries.put(hash, entryList);
            TableValueImpl.this.values.put(hash, newData);
            return data2;
        }

        public V remove(K key) {
            throw ErrorCreator.createError(ErrorReasons.TABLE_KEY_NOT_FOUND_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.KEY_NOT_FOUND_ERROR, key));
        }

        public boolean containsKey(K key) {
            return false;
        }

        public Type getKeyType() {
            throw ErrorCreator.createError(ErrorReasons.TABLE_KEY_NOT_FOUND_ERROR, io.ballerina.runtime.api.utils.StringUtils.fromString("keys are not defined"));
        }
    }

    private class TableIterator
    implements IteratorValue<Object> {
        private long cursor = 0L;

        TableIterator() {
        }

        @Override
        public Object next() {
            if (TableValueImpl.this.indexToKeyMap.containsKey(this.cursor)) {
                Object key = TableValueImpl.this.indexToKeyMap.get(this.cursor);
                Object value2 = TableValueImpl.this.keyValues.get(key);
                ArrayList<Type> types2 = new ArrayList<Type>();
                types2.add(TypeChecker.getType(key));
                types2.add(TypeChecker.getType(value2));
                BTupleType tupleType = new BTupleType(types2);
                TupleValueImpl tuple = new TupleValueImpl(tupleType);
                tuple.add(0L, key);
                tuple.add(1L, value2);
                ++this.cursor;
                return tuple;
            }
            ++this.cursor;
            return this.next();
        }

        @Override
        public boolean hasNext() {
            return this.cursor < TableValueImpl.this.noOfAddedEntries && !TableValueImpl.this.values.isEmpty();
        }
    }
}

