/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BInitialValueEntry;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BListInitialValueEntry;
import io.ballerina.runtime.api.values.BMapInitialValueEntry;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.internal.types.BAnnotatableType;
import io.ballerina.runtime.internal.types.BTypedescType;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.MappingInitialValueEntry;
import io.ballerina.runtime.internal.values.TupleValueImpl;
import io.ballerina.runtime.internal.values.TypedescValue;
import java.util.Map;
import java.util.Optional;

public class TypedescValueImpl
implements TypedescValue {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getTypeDescType();
    final Type type;
    final Type describingType;
    public MapValue<?, ?> annotations;
    private BTypedesc typedesc;

    public TypedescValueImpl(Type describingType) {
        this.type = new BTypedescType(describingType);
        this.describingType = describingType;
    }

    public TypedescValueImpl(Type describingType, MapValue<BString, Object> annotations2) {
        this(describingType);
        this.annotations = annotations2;
        ((BAnnotatableType)describingType).setAnnotations(annotations2);
    }

    @Override
    public Type getDescribingType() {
        return this.describingType;
    }

    @Override
    public Object instantiate() {
        Type referredType = TypeUtils.getImpliedType(this.describingType);
        if (referredType.getTag() == 27 || referredType.getTag() == 24) {
            return this.instantiate(new MappingInitialValueEntry[0]);
        }
        return this.instantiate(new BInitialValueEntry[0]);
    }

    @Override
    public Object instantiate(BInitialValueEntry[] initialValues) {
        Type referredType = TypeUtils.getImpliedType(this.describingType);
        if (referredType.getTag() == 27) {
            return new MapValueImpl(this.describingType, (BMapInitialValueEntry[])initialValues);
        }
        if (referredType.getTag() == 44) {
            return new TupleValueImpl(this.describingType, (BListInitialValueEntry[])initialValues, this);
        }
        throw ErrorCreator.createError(StringUtils.fromString("Given type can't be instantiated at runtime : " + String.valueOf(this.describingType)));
    }

    @Override
    public String stringValue(BLink parent) {
        return "typedesc " + this.describingType.toString();
    }

    @Override
    public String expressionStringValue(BLink parent) {
        return this.stringValue(parent);
    }

    public String toString() {
        return this.stringValue(null);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public void freezeDirect() {
    }

    @Override
    public BTypedesc getTypedesc() {
        if (this.typedesc == null) {
            this.typedesc = new TypedescValueImpl(this.type);
        }
        return this.typedesc;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public Optional<SemType> inherentTypeOf(Context cx) {
        return Optional.of(SemType.tryInto(cx, this.getType()));
    }
}

