/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.FunctionType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.BalRuntime;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.internal.values.MapValue;
import java.util.HashMap;
import java.util.Map;

public abstract class ValueCreator {
    private static final Map<String, ValueCreator> runtimeValueCreators = new HashMap<String, ValueCreator>();
    public final BalRuntime runtime;

    protected ValueCreator(BalRuntime runtime2) {
        this.runtime = runtime2;
    }

    public static void addValueCreator(String orgName, String moduleName, String moduleVersion, boolean isTestPkg, ValueCreator valueCreator) {
        String key = ValueCreator.getLookupKey(orgName, moduleName, moduleVersion, isTestPkg);
        if (!key.equals(".") && runtimeValueCreators.containsKey(key)) {
            return;
        }
        runtimeValueCreators.put(key, valueCreator);
    }

    public static String getLookupKey(Module module) {
        return ValueCreator.getLookupKey(module.getOrg(), module.getName(), module.getMajorVersion(), module.isTestPkg());
    }

    public static String getLookupKey(Module module, boolean isTestPkg) {
        return ValueCreator.getLookupKey(module.getOrg(), module.getName(), module.getMajorVersion(), isTestPkg);
    }

    public static String getLookupKey(String orgName, String moduleName, String majorVersion, boolean isTestPkg) {
        if (".".equals(moduleName)) {
            return moduleName;
        }
        if (isTestPkg) {
            moduleName = (String)moduleName + "$test";
        }
        Object pkgName = "";
        if (orgName != null && !orgName.equals("$anon")) {
            pkgName = orgName + "/";
        }
        if (majorVersion == null || majorVersion.equals("")) {
            return (String)pkgName + (String)moduleName;
        }
        return (String)pkgName + (String)moduleName + ":" + majorVersion;
    }

    public static ValueCreator getValueCreator(String key) {
        if (!runtimeValueCreators.containsKey(key)) {
            throw ErrorCreator.createError(StringUtils.fromString("Value creator object is not available for: " + key));
        }
        return runtimeValueCreators.get(key);
    }

    public static void removeValueCreator(Module rootModule) {
        String key = ValueCreator.getLookupKey(rootModule, false);
        runtimeValueCreators.remove(key);
    }

    public Object call(Strand strand, String funcName, Object ... args2) throws BError {
        throw new ErrorValue(StringUtils.fromString("No such method: " + funcName));
    }

    public static boolean containsValueCreator(String key) {
        return runtimeValueCreators.containsKey(key);
    }

    public abstract MapValue<BString, Object> createRecordValue(String var1) throws BError;

    public abstract BObject createObjectValue(String var1, Strand var2, Object[] var3) throws BError;

    public abstract BError createErrorValue(String var1, BString var2, BError var3, Object var4) throws BError;

    public abstract Type getAnonType(int var1, String var2) throws BError;

    public abstract RecordType getRecordType(String var1);

    public abstract FunctionType getFunctionType(String var1) throws BError;
}

