/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.internal.values.IteratorValue;
import io.ballerina.runtime.internal.values.ValuePair;
import io.ballerina.runtime.internal.values.XmlNonElementItem;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.apache.axiom.om.OMNode;

public class XmlComment
extends XmlNonElementItem {
    private final String data;

    public XmlComment(String data2) {
        this.data = data2;
        this.type = PredefinedTypes.TYPE_COMMENT;
    }

    public XmlComment(String data2, boolean readonly) {
        this.data = data2;
        this.type = readonly ? PredefinedTypes.TYPE_READONLY_COMMENT : PredefinedTypes.TYPE_COMMENT;
    }

    @Override
    public IteratorValue<XmlComment> getIterator() {
        final XmlComment that = this;
        return new IteratorValue<XmlComment>(this){
            boolean read = false;

            @Override
            public boolean hasNext() {
                return !this.read;
            }

            @Override
            public XmlComment next() {
                if (!this.read) {
                    this.read = true;
                    return that;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public String getTextValue() {
        return this.data;
    }

    @Override
    public XmlNodeType getNodeType() {
        return XmlNodeType.COMMENT;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        return new XmlComment(this.data);
    }

    @Override
    public OMNode value() {
        return this.factory.createOMComment(null, this.data);
    }

    @Override
    public String stringValue(BLink parent) {
        return "<!--" + this.data + "-->";
    }

    @Override
    public String informalStringValue(BLink parent) {
        return "`" + String.valueOf(this) + "`";
    }

    @Override
    public String expressionStringValue(BLink parent) {
        return "xml`" + String.valueOf(this) + "`";
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public boolean equals(Object o, Set<ValuePair> visitedValues) {
        if (!(o instanceof XmlComment)) {
            return false;
        }
        XmlComment rhXMLComment = (XmlComment)o;
        return this.getTextValue().equals(rhXMLComment.getTextValue());
    }
}

