/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.internal.values.IteratorValue;
import io.ballerina.runtime.internal.values.ValuePair;
import io.ballerina.runtime.internal.values.XmlNonElementItem;
import io.ballerina.runtime.internal.values.XmlSequence;
import io.ballerina.runtime.internal.values.XmlValue;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.apache.axiom.om.OMNode;

public class XmlText
extends XmlNonElementItem {
    private final String data;

    public XmlText(String data2) {
        this.data = data2;
        this.type = data2.isEmpty() ? PredefinedTypes.TYPE_XML_NEVER : PredefinedTypes.TYPE_TEXT;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean isSingleton() {
        return !this.isEmpty();
    }

    @Override
    public String getItemType() {
        return this.getNodeType().value();
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public String getTextValue() {
        return this.data;
    }

    @Override
    public BXml strip() {
        if (!this.data.trim().isEmpty()) {
            return this;
        }
        return new XmlText("");
    }

    @Override
    public XmlNodeType getNodeType() {
        return XmlNodeType.TEXT;
    }

    @Override
    public OMNode value() {
        return this.factory.createOMText(this.data);
    }

    @Override
    public IteratorValue<XmlText> getIterator() {
        final XmlText that = this;
        return new IteratorValue<XmlText>(this){
            boolean read = false;

            @Override
            public boolean hasNext() {
                return !this.read;
            }

            @Override
            public XmlText next() {
                if (!this.read) {
                    this.read = true;
                    return that;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public boolean equals(Object o, Set<ValuePair> visitedValues) {
        XmlSequence xmlSequence;
        if (o instanceof XmlText || this.isXmlSequenceWithSingletonTextValue(o)) {
            return this.getTextValue().equals(((XmlValue)o).getTextValue());
        }
        return this.getType() == PredefinedTypes.TYPE_XML_NEVER && o instanceof XmlSequence && (xmlSequence = (XmlSequence)o).getChildrenList().isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    private boolean isXmlSequenceWithSingletonTextValue(Object o) {
        if (!(o instanceof XmlSequence)) {
            return false;
        }
        XmlSequence sequence = (XmlSequence)o;
        return sequence.isSingleton() && sequence.getItem(0).getNodeType() == XmlNodeType.TEXT;
    }
}

