/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.xml;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BIterator;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.types.BStructureType;
import io.ballerina.runtime.internal.values.DecimalValue;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.TableValue;
import io.ballerina.runtime.internal.values.TupleValueImpl;
import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.ds.AbstractPushOMDataSource;

public class TableOmDataSource
extends AbstractPushOMDataSource {
    private static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XSI_PREFIX = "xsi";
    private static final String ARRAY_ELEMENT_NAME = "element";
    private static final String DEFAULT_ROOT_WRAPPER = "results";
    private static final String DEFAULT_ROW_WRAPPER = "result";
    private final TableValue<?, ?> table;
    private final String rootWrapper;
    private final String rowWrapper;

    public TableOmDataSource(TableValue<?, ?> table2, String rootWrapper, String rowWrapper) {
        this.table = table2;
        this.rootWrapper = rootWrapper != null ? rootWrapper : DEFAULT_ROOT_WRAPPER;
        this.rowWrapper = rowWrapper != null ? rowWrapper : DEFAULT_ROW_WRAPPER;
    }

    @Override
    public void serialize(XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("", this.rootWrapper, "");
        BIterator itr = this.table.getIterator();
        while (itr.hasNext()) {
            xmlStreamWriter.writeStartElement("", this.rowWrapper, "");
            TupleValueImpl tupleValue = (TupleValueImpl)itr.next();
            MapValue record = (MapValue)tupleValue.get(0L);
            BStructureType structType = (BStructureType)record.getType();
            if (structType != null) {
                for (Field internalStructField : structType.getFields().values()) {
                    this.writeElement(record, xmlStreamWriter, internalStructField);
                }
            }
            xmlStreamWriter.writeEndElement();
        }
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.flush();
    }

    private void writeElement(MapValue<?, ?> record, XMLStreamWriter xmlStreamWriter, Field structField) throws XMLStreamException {
        int type = TypeUtils.getImpliedType(structField.getFieldType()).getTag();
        String name = structField.getFieldName();
        boolean isArray = false;
        xmlStreamWriter.writeStartElement("", name, "");
        BString key = StringUtils.fromString(name);
        String value2 = null;
        switch (type) {
            case 6: {
                value2 = String.valueOf(record.getBooleanValue(key));
                break;
            }
            case 5: {
                value2 = String.valueOf(record.getStringValue(key));
                break;
            }
            case 1: {
                value2 = String.valueOf(record.getIntValue(key));
                break;
            }
            case 3: {
                value2 = String.valueOf(record.getFloatValue(key));
                break;
            }
            case 4: {
                DecimalValue decimalVal = (DecimalValue)record.get(key);
                value2 = String.valueOf(decimalVal);
                break;
            }
            case 32: {
                isArray = true;
                BArray array2 = record.getArrayValue(key);
                this.processArray(xmlStreamWriter, array2);
                break;
            }
            case 24: 
            case 47: {
                isArray = true;
                BMap<?, ?> structData = record.getMapValue(key);
                this.processStruct(xmlStreamWriter, structData, structField);
                break;
            }
            default: {
                value2 = String.valueOf(record.getStringValue(key));
            }
        }
        if (!isArray) {
            if (value2 == null) {
                xmlStreamWriter.writeNamespace(XSI_PREFIX, XSI_NAMESPACE);
                xmlStreamWriter.writeAttribute(XSI_PREFIX, XSI_NAMESPACE, "nil", "true");
            } else {
                xmlStreamWriter.writeCharacters(value2);
            }
        }
        xmlStreamWriter.writeEndElement();
    }

    private void processArray(XMLStreamWriter xmlStreamWriter, BArray array2) throws XMLStreamException {
        if (array2 == null) {
            return;
        }
        for (int i = 0; i < array2.size(); ++i) {
            xmlStreamWriter.writeStartElement("", ARRAY_ELEMENT_NAME, "");
            xmlStreamWriter.writeCharacters(String.valueOf(array2.get(i)));
            xmlStreamWriter.writeEndElement();
        }
    }

    private void processStruct(XMLStreamWriter xmlStreamWriter, BMap<?, ?> structData, Field structField) throws XMLStreamException {
        Type internalType = TypeUtils.getImpliedType(structField.getFieldType());
        if (internalType.getTag() != 47 && internalType.getTag() != 24) {
            throw ErrorCreator.createError(StringUtils.fromString("error in constructing the xml element from struct type data"));
        }
        Collection<Field> internalStructFields = ((BStructureType)internalType).getFields().values();
        for (Field internalStructField : internalStructFields) {
            BString internalKeyName = StringUtils.fromString(internalStructField.getFieldName());
            Object val2 = structData.get(internalKeyName);
            xmlStreamWriter.writeStartElement("", internalStructField.getFieldName(), "");
            if (val2 instanceof MapValueImpl) {
                MapValueImpl mapValue = (MapValueImpl)val2;
                this.processStruct(xmlStreamWriter, mapValue, internalStructField);
            } else {
                xmlStreamWriter.writeCharacters(val2.toString());
            }
            xmlStreamWriter.writeEndElement();
        }
    }

    @Override
    public boolean isDestructiveWrite() {
        return true;
    }
}

