/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.xml;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.api.values.BXmlQName;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.values.TableValueImpl;
import io.ballerina.runtime.internal.values.XmlComment;
import io.ballerina.runtime.internal.values.XmlItem;
import io.ballerina.runtime.internal.values.XmlPi;
import io.ballerina.runtime.internal.values.XmlSequence;
import io.ballerina.runtime.internal.values.XmlText;
import io.ballerina.runtime.internal.values.XmlValue;
import io.ballerina.runtime.internal.xml.TableOmDataSource;
import io.ballerina.runtime.internal.xml.XmlTreeBuilder;
import io.ballerina.runtime.internal.xml.XmlValidator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.DeferredParsingException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.util.StAXParserConfiguration;

public final class XmlFactory {
    public static final StAXParserConfiguration STAX_PARSER_CONFIGURATION = StAXParserConfiguration.STANDALONE;
    public static final String PARSE_ERROR = "failed to parse xml";
    public static final String PARSE_ERROR_PREFIX = "failed to parse xml: ";

    private XmlFactory() {
    }

    public static BXml parse(String xmlStr) {
        try {
            if (xmlStr.isEmpty()) {
                return new XmlSequence();
            }
            XmlTreeBuilder treeBuilder = new XmlTreeBuilder(xmlStr);
            return treeBuilder.parse();
        }
        catch (BError e2) {
            throw e2;
        }
        catch (Throwable e3) {
            String errorMessage = e3.getMessage();
            if (errorMessage == null) {
                BError bError = ErrorCreator.createError(StringUtils.fromString(PARSE_ERROR));
                bError.setStackTrace(e3.getStackTrace());
                throw bError;
            }
            throw ErrorCreator.createError(StringUtils.fromString(PARSE_ERROR_PREFIX + errorMessage));
        }
    }

    public static BXml parse(InputStream xmlStream) {
        try {
            XmlTreeBuilder treeBuilder = new XmlTreeBuilder(new InputStreamReader(xmlStream));
            return treeBuilder.parse();
        }
        catch (BError e2) {
            throw e2;
        }
        catch (DeferredParsingException e3) {
            throw ErrorCreator.createError(StringUtils.fromString(e3.getCause().getMessage()));
        }
        catch (Throwable e4) {
            throw ErrorCreator.createError(StringUtils.fromString(PARSE_ERROR_PREFIX + e4.getMessage()));
        }
    }

    public static BXml parse(InputStream xmlStream, String charset) {
        try {
            XmlTreeBuilder xmlTreeBuilder = new XmlTreeBuilder(new InputStreamReader(xmlStream, charset));
            return xmlTreeBuilder.parse();
        }
        catch (BError e2) {
            throw e2;
        }
        catch (DeferredParsingException e3) {
            throw ErrorCreator.createError(StringUtils.fromString(e3.getCause().getMessage()));
        }
        catch (Throwable e4) {
            throw ErrorCreator.createError(StringUtils.fromString(PARSE_ERROR_PREFIX + e4.getMessage()));
        }
    }

    public static BXml parse(Reader reader) {
        try {
            XmlTreeBuilder xmlTreeBuilder = new XmlTreeBuilder(reader);
            return xmlTreeBuilder.parse();
        }
        catch (BError e2) {
            throw e2;
        }
        catch (DeferredParsingException e3) {
            throw ErrorCreator.createError(StringUtils.fromString(e3.getCause().getMessage()));
        }
        catch (Throwable e4) {
            throw ErrorCreator.createError(StringUtils.fromString(PARSE_ERROR_PREFIX + e4.getMessage()));
        }
    }

    public static XmlValue concatenate(XmlValue firstSeq, XmlValue secondSeq) {
        ArrayList<BXml> concatenatedList = new ArrayList<BXml>();
        if (firstSeq.getNodeType() == XmlNodeType.TEXT && secondSeq.getNodeType() == XmlNodeType.TEXT) {
            return new XmlText(firstSeq.getTextValue() + secondSeq.getTextValue());
        }
        if (firstSeq.getNodeType() == XmlNodeType.SEQUENCE) {
            concatenatedList.addAll(((XmlSequence)firstSeq).getChildrenList());
        } else if (!firstSeq.isEmpty()) {
            concatenatedList.add(firstSeq);
        }
        if (!concatenatedList.isEmpty()) {
            int lastIndexOFLeftChildren = concatenatedList.size() - 1;
            BXml lastItem = (BXml)concatenatedList.get(lastIndexOFLeftChildren);
            if (lastItem.getNodeType() == XmlNodeType.TEXT && secondSeq.getNodeType() == XmlNodeType.SEQUENCE) {
                BXml firsOfRightSeq;
                List<BXml> rightChildren = ((XmlSequence)secondSeq).getChildrenList();
                if (!rightChildren.isEmpty() && (firsOfRightSeq = rightChildren.get(0)).getNodeType() == XmlNodeType.TEXT) {
                    concatenatedList.remove(lastIndexOFLeftChildren);
                    concatenatedList.addAll(rightChildren);
                    String merged = lastItem.getTextValue() + firsOfRightSeq.getTextValue();
                    concatenatedList.set(lastIndexOFLeftChildren, new XmlText(merged));
                    return new XmlSequence(concatenatedList);
                }
            } else if (lastItem.getNodeType() == XmlNodeType.TEXT && secondSeq.getNodeType() == XmlNodeType.TEXT) {
                String merged = lastItem.getTextValue() + secondSeq.getTextValue();
                concatenatedList.set(lastIndexOFLeftChildren, new XmlText(merged));
                return new XmlSequence(concatenatedList);
            }
        }
        if (secondSeq.getNodeType() == XmlNodeType.SEQUENCE) {
            concatenatedList.addAll(((XmlSequence)secondSeq).getChildrenList());
        } else if (!secondSeq.isEmpty()) {
            concatenatedList.add(secondSeq);
        }
        return new XmlSequence(concatenatedList);
    }

    public static BXml tableToXML(TableValueImpl<?, ?> table2) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XMLStreamWriter streamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream);
            TableOmDataSource tableOMDataSource = new TableOmDataSource(table2, null, null);
            tableOMDataSource.serialize(streamWriter);
            streamWriter.flush();
            outputStream.flush();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            return XmlFactory.parse(inputStream);
        }
        catch (IOException | XMLStreamException e2) {
            throw ErrorCreator.createError(e2);
        }
    }

    @Deprecated
    public static XmlValue createXMLElement(BXmlQName startTagName, BXmlQName endTagName, String defaultNsUri) {
        if (!(XmlFactory.isEqual(startTagName.getLocalName(), endTagName.getLocalName()) && XmlFactory.isEqual(startTagName.getUri(), endTagName.getUri()) && XmlFactory.isEqual(startTagName.getPrefix(), endTagName.getPrefix()))) {
            throw ErrorCreator.createError(StringUtils.fromString("start and end tag names mismatch: '" + String.valueOf(startTagName) + "' and '" + String.valueOf(endTagName) + "'"));
        }
        return XmlFactory.createXMLElement(startTagName, defaultNsUri);
    }

    @Deprecated
    public static XmlValue createXMLElement(BXmlQName startTagName, String defaultNsUri) {
        return XmlFactory.createXMLElement(startTagName, defaultNsUri, false);
    }

    public static XmlValue createXMLElement(BXmlQName startTagName, BString defaultNsUriVal) {
        return XmlFactory.createXMLElement(startTagName, defaultNsUriVal == null ? "" : defaultNsUriVal.getValue());
    }

    @Deprecated
    public static XmlValue createXMLElement(BXmlQName startTagName, String defaultNsUri, boolean readonly) {
        String prefix;
        XmlValidator.validateXMLQName(startTagName);
        String nsUri = startTagName.getUri();
        if (defaultNsUri == null) {
            defaultNsUri = "";
        }
        String string2 = prefix = startTagName.getPrefix() == null ? "" : startTagName.getPrefix();
        if (nsUri == null) {
            return new XmlItem(new QName(defaultNsUri, startTagName.getLocalName(), prefix), readonly);
        }
        return XmlItem.createXMLItemWithDefaultNSAttribute(new QName(nsUri, startTagName.getLocalName(), prefix), readonly, defaultNsUri);
    }

    public static XmlValue createXMLElement(BXmlQName startTagName, BString defaultNsUriVal, boolean readonly) {
        return XmlFactory.createXMLElement(startTagName, defaultNsUriVal == null ? "" : defaultNsUriVal.getValue(), readonly);
    }

    public static XmlSequence createXmlSequence() {
        return new XmlSequence();
    }

    public static XmlSequence createXmlSequence(BArray sequence) {
        ArrayList<BXml> children2 = new ArrayList<BXml>();
        for (Object value2 : sequence.getValues()) {
            children2.add((BXml)value2);
        }
        return new XmlSequence(children2);
    }

    public static XmlSequence createXmlSequence(List<BXml> sequence) {
        return new XmlSequence(sequence);
    }

    public static XmlSequence createXmlSequence(BXml child) {
        return new XmlSequence(child);
    }

    @Deprecated
    public static XmlValue createXMLComment(String content) {
        return new XmlComment(content);
    }

    public static XmlValue createXMLComment(BString content) {
        return XmlFactory.createXMLComment(content.getValue());
    }

    @Deprecated
    public static XmlValue createXMLComment(String content, boolean readonly) {
        return new XmlComment(content, readonly);
    }

    public static XmlValue createXMLComment(BString content, boolean readonly) {
        return XmlFactory.createXMLComment(content.getValue(), readonly);
    }

    @Deprecated
    public static XmlValue createXMLText(String content) {
        return new XmlText(XMLTextUnescape.unescape(content));
    }

    public static XmlValue createXMLText(BString contentVal) {
        return XmlFactory.createXMLText(contentVal.getValue());
    }

    @Deprecated
    public static XmlValue createXMLProcessingInstruction(String target, String data2) {
        return new XmlPi(data2, target);
    }

    public static XmlValue createXMLProcessingInstruction(BString target, BString data2) {
        return XmlFactory.createXMLProcessingInstruction(target.getValue(), data2.getValue());
    }

    @Deprecated
    public static XmlValue createXMLProcessingInstruction(String target, String data2, boolean readonly) {
        return new XmlPi(data2, target, readonly);
    }

    public static XmlValue createXMLProcessingInstruction(BString target, BString data2, boolean readonly) {
        return XmlFactory.createXMLProcessingInstruction(target.getValue(), data2.getValue(), readonly);
    }

    public static boolean isEqual(BXml xmlOne, BXml xmlTwo) {
        return TypeChecker.isEqual(xmlOne, xmlTwo);
    }

    public static OMElement stringToOM(String xmlFragment) {
        return XmlFactory.stringToOM(OMAbstractFactory.getOMFactory(), xmlFragment);
    }

    private static OMElement stringToOM(OMFactory omFactory, String xmlFragment) {
        return xmlFragment != null ? OMXMLBuilderFactory.createOMBuilder(omFactory, STAX_PARSER_CONFIGURATION, new StringReader(xmlFragment)).getDocumentElement() : null;
    }

    public static boolean isEqual(String s110, String s210) {
        if (s110 == s210) {
            return true;
        }
        if (s110 == null || s210 == null) {
            return false;
        }
        return s110.equals(s210);
    }

    public static final class XMLTextUnescape {
        private XMLTextUnescape() {
        }

        public static String unescape(String str) {
            return XMLTextUnescape.unescape(str.getBytes(StandardCharsets.UTF_8));
        }

        /*
         * Unable to fully structure code
         */
        private static String unescape(byte[] bytes) {
            target = new byte[bytes.length];
            size = bytes.length;
            len = 0;
            i = 0;
            while (i < size) {
                block8: {
                    block7: {
                        b = bytes[i];
                        i1 = i + 1;
                        if (b != 13 || i1 >= size || bytes[i1] != 10) break block7;
                        target[len] = 10;
                        ++i;
                        break block8;
                    }
                    if (b != 38) ** GOTO lbl-1000
                    i2 = i + 2;
                    i3 = i + 3;
                    if (i3 < size && bytes[i1] == 103 && bytes[i2] == 116 && bytes[i3] == 59) {
                        target[len] = 62;
                        i += 3;
                    } else if (i3 < size && bytes[i1] == 108 && bytes[i2] == 116 && bytes[i3] == 59) {
                        target[len] = 60;
                        i += 3;
                    } else if (i3 + 1 < size && bytes[i1] == 97 && bytes[i2] == 109 && bytes[i3] == 112 && bytes[i3 + 1] == 59) {
                        target[len] = 38;
                        i += 4;
                    } else lbl-1000:
                    // 2 sources

                    {
                        target[len] = b;
                    }
                }
                ++i;
                ++len;
            }
            return new String(target, 0, len);
        }
    }
}

