/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.observability.metrics;

import io.ballerina.runtime.observability.metrics.DefaultMetricRegistry;
import io.ballerina.runtime.observability.metrics.Metric;
import io.ballerina.runtime.observability.metrics.MetricId;
import io.ballerina.runtime.observability.metrics.MetricRegistry;
import io.ballerina.runtime.observability.metrics.Tag;
import io.ballerina.runtime.observability.metrics.Tags;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public interface Counter
extends Metric {
    public static Builder builder(String name) {
        return new Builder(name);
    }

    @Override
    default public Counter register() {
        return DefaultMetricRegistry.getInstance().register(this);
    }

    @Override
    default public void unregister() {
        DefaultMetricRegistry.getInstance().unregister(this);
    }

    default public void increment() {
        this.increment(1L);
    }

    public void reset();

    public void increment(long var1);

    public long getValue();

    public long getValueThenReset();

    public static class Builder
    implements Metric.Builder<Builder, Counter> {
        private final String name;
        private final Set<Tag> tags = new HashSet<Tag>(10);
        private String description;

        private Builder(String name) {
            this.name = name;
        }

        @Override
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder tags(String ... keyValues) {
            Tags.tags(this.tags, keyValues);
            return this;
        }

        @Override
        public Builder tags(Iterable<Tag> tags) {
            Tags.tags(this.tags, tags);
            return this;
        }

        @Override
        public Builder tag(String key, String value2) {
            Tags.tags(this.tags, key, value2);
            return this;
        }

        @Override
        public Builder tags(Map<String, String> tags) {
            Tags.tags(this.tags, tags);
            return this;
        }

        @Override
        public Counter build() {
            return DefaultMetricRegistry.getInstance().getMetricProvider().newCounter(new MetricId(this.name, this.description, this.tags));
        }

        @Override
        public Counter register() {
            return this.register(DefaultMetricRegistry.getInstance());
        }

        @Override
        public Counter register(MetricRegistry registry) {
            return registry.counter(new MetricId(this.name, this.description, this.tags));
        }
    }
}

