/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.observability.metrics;

import io.ballerina.runtime.observability.metrics.PercentileValue;
import java.time.Duration;
import java.util.Arrays;

public class Snapshot {
    private static final PercentileValue[] EMPTY_PERCENTILE_VALUES = new PercentileValue[0];
    private final Duration timeWindow;
    private final double min;
    private final double mean;
    private final double stdDev;
    private final double max;
    private final PercentileValue[] percentileValues;

    public Snapshot(Duration timeWindow, double min2, double mean, double stdDev, double max2, PercentileValue[] percentileValues) {
        this.timeWindow = timeWindow;
        this.min = min2;
        this.mean = mean;
        this.stdDev = stdDev;
        this.max = max2;
        this.percentileValues = percentileValues;
    }

    public Duration getTimeWindow() {
        return this.timeWindow;
    }

    public double getMin() {
        return this.min;
    }

    public double getMean() {
        return this.mean;
    }

    public double getStdDev() {
        return this.stdDev;
    }

    public double getMax() {
        return this.max;
    }

    public PercentileValue[] getPercentileValues() {
        return this.percentileValues != null ? Arrays.copyOf(this.percentileValues, this.percentileValues.length) : EMPTY_PERCENTILE_VALUES;
    }
}

