/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.observability.tracer;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.observability.tracer.spi.TracerProvider;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.propagation.ContextPropagators;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class TracersStore {
    private TracerProvider tracerProvider;
    private Map<String, Tracer> store;
    private static final PrintStream consoleError = System.err;
    private static final PrintStream console = System.out;
    private static final TracersStore instance = new TracersStore();
    private ContextPropagators propagators;

    public static TracersStore getInstance() {
        return instance;
    }

    private TracersStore() {
    }

    public void setTracerGenerator(TracerProvider tracerProvider) {
        this.tracerProvider = tracerProvider;
        if (tracerProvider != null) {
            this.propagators = tracerProvider.getPropagators();
        }
        this.store = new HashMap<String, Tracer>();
    }

    public Tracer getTracer(String serviceName) {
        Tracer tracer;
        if (!this.isInitialized()) {
            throw ErrorCreator.createError(StringUtils.fromString("error: the tracer store is not initialized because observability has not been enabled."));
        }
        if (this.store.containsKey(serviceName)) {
            tracer = this.store.get(serviceName);
        } else if (this.tracerProvider != null) {
            try {
                tracer = this.tracerProvider.getTracer(serviceName);
            }
            catch (Throwable e2) {
                tracer = io.opentelemetry.api.trace.TracerProvider.noop().get("");
                console.println("warning: tracing disabled while getting tracer for " + serviceName + " service.");
            }
            this.store.put(serviceName, tracer);
        } else {
            tracer = io.opentelemetry.api.trace.TracerProvider.noop().get("");
            consoleError.println("error: tracing disabled as the tracer provider had not been initialized.");
        }
        return tracer;
    }

    public ContextPropagators getPropagators() {
        if (this.propagators != null) {
            return this.propagators;
        }
        return ContextPropagators.noop();
    }

    public boolean isInitialized() {
        return this.store != null;
    }
}

