/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.parser;

import io.ballerina.toml.internal.diagnostics.DiagnosticErrorCode;
import io.ballerina.toml.internal.parser.ParserRuleContext;
import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.toml.internal.parser.tree.STNodeFactory;
import io.ballerina.toml.internal.parser.tree.STNodeList;
import io.ballerina.toml.internal.parser.tree.STToken;
import io.ballerina.toml.internal.syntax.NodeListUtils;
import io.ballerina.toml.internal.syntax.SyntaxUtils;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import io.ballerina.tools.diagnostics.DiagnosticCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class SyntaxErrors {
    private SyntaxErrors() {
    }

    public static STNodeDiagnostic createDiagnostic(DiagnosticCode diagnosticCode, Object ... args2) {
        return STNodeDiagnostic.from(diagnosticCode, args2);
    }

    public static <T extends STNode> T addDiagnostic(T node, DiagnosticCode diagnosticCode, Object ... args2) {
        return SyntaxErrors.addSyntaxDiagnostic(node, SyntaxErrors.createDiagnostic(diagnosticCode, args2));
    }

    public static <T extends STNode> T addSyntaxDiagnostic(T node, STNodeDiagnostic diagnostic) {
        return SyntaxErrors.addSyntaxDiagnostics(node, Collections.singletonList(diagnostic));
    }

    public static <T extends STNode> T addSyntaxDiagnostics(T node, Collection<STNodeDiagnostic> diagnostics) {
        ArrayList<STNodeDiagnostic> newDiagnostics;
        if (diagnostics.isEmpty()) {
            return node;
        }
        Collection<STNodeDiagnostic> oldDiagnostics = node.diagnostics();
        if (oldDiagnostics.isEmpty()) {
            newDiagnostics = new ArrayList<STNodeDiagnostic>(diagnostics);
        } else {
            newDiagnostics = new ArrayList<STNodeDiagnostic>(oldDiagnostics);
            newDiagnostics.addAll(diagnostics);
        }
        return (T)node.modifyWith(newDiagnostics);
    }

    public static STToken createMissingToken(SyntaxKind expectedKind) {
        return STNodeFactory.createMissingToken(expectedKind);
    }

    public static STToken createMissingTokenWithDiagnostics(SyntaxKind expectedKind, ParserRuleContext currentCtx) {
        return SyntaxErrors.createMissingTokenWithDiagnostics(expectedKind, SyntaxErrors.getErrorCode(currentCtx));
    }

    public static STToken createMissingTokenWithDiagnostics(SyntaxKind expectedKind, DiagnosticCode diagnosticCode) {
        ArrayList<STNodeDiagnostic> diagnosticList = new ArrayList<STNodeDiagnostic>();
        diagnosticList.add(SyntaxErrors.createDiagnostic(diagnosticCode, new Object[0]));
        return STNodeFactory.createMissingToken(expectedKind, diagnosticList);
    }

    private static DiagnosticCode getErrorCode(ParserRuleContext currentCtx) {
        return switch (currentCtx) {
            case ParserRuleContext.STRING_BODY -> DiagnosticErrorCode.ERROR_MISSING_STRING_LITERAL;
            case ParserRuleContext.ASSIGN_OP -> DiagnosticErrorCode.ERROR_MISSING_EQUAL_TOKEN;
            case ParserRuleContext.ARRAY_VALUE_LIST_END, ParserRuleContext.TABLE_END, ParserRuleContext.ARRAY_TABLE_FIRST_END, ParserRuleContext.ARRAY_TABLE_SECOND_END -> DiagnosticErrorCode.ERROR_MISSING_CLOSE_BRACKET_TOKEN;
            case ParserRuleContext.COMMA -> DiagnosticErrorCode.ERROR_MISSING_COMMA_TOKEN;
            case ParserRuleContext.ARRAY_VALUE_LIST_START, ParserRuleContext.TABLE_START, ParserRuleContext.ARRAY_TABLE_FIRST_START, ParserRuleContext.ARRAY_TABLE_SECOND_START -> DiagnosticErrorCode.ERROR_MISSING_OPEN_BRACKET_TOKEN;
            case ParserRuleContext.INLINE_TABLE_END -> DiagnosticErrorCode.ERROR_MISSING_CLOSE_BRACE_TOKEN;
            case ParserRuleContext.INLINE_TABLE_START -> DiagnosticErrorCode.ERROR_MISSING_OPEN_BRACE_TOKEN;
            case ParserRuleContext.DOT -> DiagnosticErrorCode.ERROR_MISSING_DOT_TOKEN;
            case ParserRuleContext.STRING_END, ParserRuleContext.STRING_START -> DiagnosticErrorCode.ERROR_MISSING_DOUBLE_QUOTE_TOKEN;
            case ParserRuleContext.MULTILINE_STRING_START, ParserRuleContext.MULTILINE_STRING_END -> DiagnosticErrorCode.ERROR_MISSING_TRIPLE_DOUBLE_QUOTE_TOKEN;
            case ParserRuleContext.LITERAL_STRING_END, ParserRuleContext.LITERAL_STRING_START -> DiagnosticErrorCode.ERROR_MISSING_SINGLE_QUOTE_TOKEN;
            case ParserRuleContext.MULTILINE_LITERAL_STRING_START, ParserRuleContext.MULTILINE_LITERAL_STRING_END -> DiagnosticErrorCode.ERROR_MISSING_TRIPLE_SINGLE_QUOTE_TOKEN;
            case ParserRuleContext.DECIMAL_INTEGER_LITERAL, ParserRuleContext.DECIMAL_FLOATING_POINT_LITERAL, ParserRuleContext.BOOLEAN_LITERAL -> DiagnosticErrorCode.ERROR_MISSING_VALUE;
            case ParserRuleContext.NEWLINE -> DiagnosticErrorCode.ERROR_MISSING_NEW_LINE;
            case ParserRuleContext.IDENTIFIER_LITERAL -> DiagnosticErrorCode.ERROR_MISSING_IDENTIFIER;
            default -> DiagnosticErrorCode.ERROR_SYNTAX_ERROR;
        };
    }

    public static STNode cloneWithLeadingInvalidNodeMinutiae(STNode toClone, STNode invalidNode) {
        return SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(toClone, invalidNode, null, new Object[0]);
    }

    public static STNode cloneWithLeadingInvalidNodeMinutiae(STNode toClone, STNode invalidNode, DiagnosticCode diagnosticCode, Object ... args2) {
        STToken firstToken = toClone.firstToken();
        STToken firstTokenWithInvalidNodeMinutiae = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(firstToken, invalidNode, diagnosticCode, args2);
        return toClone.replace(firstToken, firstTokenWithInvalidNodeMinutiae);
    }

    public static STToken cloneWithLeadingInvalidNodeMinutiae(STToken toClone, STNode invalidNode, DiagnosticCode diagnosticCode, Object ... args2) {
        List<STNode> minutiaeList = SyntaxErrors.convertInvalidNodeToMinutiae(invalidNode);
        STNodeList leadingMinutiae = (STNodeList)toClone.leadingMinutiae();
        leadingMinutiae = leadingMinutiae.addAll(0, minutiaeList);
        STToken cloned = toClone.modifyWith(leadingMinutiae, toClone.trailingMinutiae());
        return diagnosticCode == null ? cloned : SyntaxErrors.addDiagnostic(cloned, diagnosticCode, args2);
    }

    public static STNode cloneWithTrailingInvalidNodeMinutiae(STNode toClone, STNode invalidNode) {
        return SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(toClone, invalidNode, null, new Object[0]);
    }

    public static STNode cloneWithTrailingInvalidNodeMinutiae(STNode toClone, STNode invalidNode, DiagnosticCode diagnosticCode, Object ... args2) {
        STToken lastToken = toClone.lastToken();
        STToken lastTokenWithInvalidNodeMinutiae = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(lastToken, invalidNode, diagnosticCode, args2);
        return toClone.replace(lastToken, lastTokenWithInvalidNodeMinutiae);
    }

    public static STToken cloneWithTrailingInvalidNodeMinutiae(STToken toClone, STNode invalidNode, DiagnosticCode diagnosticCode, Object ... args2) {
        List<STNode> minutiaeList = SyntaxErrors.convertInvalidNodeToMinutiae(invalidNode);
        STNodeList trailingMinutiae = (STNodeList)toClone.trailingMinutiae();
        trailingMinutiae = trailingMinutiae.addAll(minutiaeList);
        STToken cloned = toClone.modifyWith(toClone.leadingMinutiae(), trailingMinutiae);
        return diagnosticCode == null ? cloned : SyntaxErrors.addDiagnostic(cloned, diagnosticCode, args2);
    }

    private static List<STNode> convertInvalidNodeToMinutiae(STNode invalidNode) {
        ArrayList<STNode> minutiaeList = new ArrayList<STNode>();
        List<STToken> tokens = invalidNode.tokens();
        for (STToken token : tokens) {
            SyntaxErrors.addMinutiaeToList(minutiaeList, token.leadingMinutiae());
            if (!token.isMissing()) {
                STToken tokenWithNoMinutiae = token.modifyWith(STNodeFactory.createEmptyNodeList(), STNodeFactory.createEmptyNodeList());
                minutiaeList.add(STNodeFactory.createInvalidNodeMinutiae(tokenWithNoMinutiae));
            }
            SyntaxErrors.addMinutiaeToList(minutiaeList, token.trailingMinutiae());
        }
        return minutiaeList;
    }

    private static void addMinutiaeToList(List<STNode> list, STNode minutiae) {
        if (!NodeListUtils.isSTNodeList(minutiae)) {
            list.add(minutiae);
            return;
        }
        STNodeList minutiaeList = (STNodeList)minutiae;
        for (int index = 0; index < minutiaeList.size(); ++index) {
            STNode element = minutiaeList.get(index);
            if (!SyntaxUtils.isSTNodePresent(element)) continue;
            list.add(element);
        }
    }
}

